/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.Mod;

@Config(modid="mysticalworld")
@Mod.EventBusSubscriber(modid="mysticalworld")
public class ConfigManager {
    @Config.Comment(value={"Inject some items from Mystical World into dungeon & other loot chests"})
    public static boolean InjectLoot = true;
    @Config.Comment(value={"Minimum number of pulls for injected loot"})
    public static int InjectMinimum = 1;
    @Config.Comment(value={"Maximum nubmer of pulls for injected loot"})
    public static int InjectMaximum = 1;
    @Config.Comment(value={"Mystical world content modules. These modules are applied before any other config options."})
    public static ConfigMysticalWorldModules modules = new ConfigMysticalWorldModules();
    @Config.Comment(value={"Controls the spawning of mobs in Mystical World and dependent mods."})
    public static ConfigMysticalWorldMobs mobs = new ConfigMysticalWorldMobs();
    @Config.Comment(value={"Controls the spawn settings of Deer"})
    public static ConfigMysticalWorldDeer deer = new ConfigMysticalWorldDeer();
    @Config.Comment(value={"Controls the spawn settings of Foxes"})
    public static ConfigMysticalWorldFox fox = new ConfigMysticalWorldFox();
    @Config.Comment(value={"Controls the spawn settings of Beetle"})
    public static ConfigMysticalWorldBeetle beetle = new ConfigMysticalWorldBeetle();
    @Config.Comment(value={"Controls the spawn settings of Frog"})
    public static ConfigMysticalWorldFrog frog = new ConfigMysticalWorldFrog();
    @Config.Comment(value={"Controls the spawn settings of Sprout"})
    public static ConfigMysticalWorldSprout sprout = new ConfigMysticalWorldSprout();
    @Config.Comment(value={"Minimum distance between Barrow structures. Set to -1 to disable."})
    @Config.RangeInt(min=0)
    public static int BarrowDistance = 400;
    @Config.Comment(value={"Mininmum distance between Hut structures. Set to -1 to disable."})
    @Config.RangeInt(min=0)
    public static int HutDistance = 400;
    @Config.Comment(value={"Mystical world gems and their components"})
    public static ConfigMysticalWorldGems gems = new ConfigMysticalWorldGems();
    @Config.Comment(value={"Mystical world metals and their components."})
    public static ConfigMysticalWorldMetals metals = new ConfigMysticalWorldMetals();
    @Config.Comment(value={"Ore Debugging Options"})
    public static ConfigMysticalWorldOreDebugging oreDebugging = new ConfigMysticalWorldOreDebugging();
    @Config.Comment(value={"Controls ore generation for Mystical World Ores."})
    public static ConfigMysticalWorldOreGen oreGen = new ConfigMysticalWorldOreGen();

    public static class ConfigMysticalWorldOreGen {
        @Config.Comment(value={"The amount of copper veins to generate per chunk. Set to 0 to disable."})
        public int copperPerChunk = 6;
        @Config.Comment(value={"The maximum size of a copper ore vein."})
        public int copperVeinSize = 12;
        @Config.Comment(value={"The highest a copper ore vein can generate."})
        @Config.RangeInt(min=0, max=255)
        public int copperMaxY = 64;
        @Config.Comment(value={"The lowest a copper of vein can generate."})
        @Config.RangeInt(min=0, max=255)
        public int copperMinY = 0;
        @Config.Comment(value={"The amount of amethyst veins to generate per chunk. Set to 0 to disable."})
        public int amethystPerChunk = 2;
        @Config.Comment(value={"The maximum size of an amethyst ore vein."})
        public int amethystVeinSize = 5;
        @Config.Comment(value={"The highest an amethyst ore vein can generate"})
        @Config.RangeInt(min=0, max=255)
        public int amethystMaxY = 32;
        @Config.Comment(value={"The lowest an amethsyt ore vein can generate"})
        @Config.RangeInt(min=0, max=255)
        public int amethystMinY = 5;
        @Config.Comment(value={"The amount of silver veins to generate per chunk. Set to 0 to disable."})
        public int silverPerChunk = 4;
        @Config.Comment(value={"The maximum size of a silver ore vein."})
        public int silverVeinSize = 8;
        @Config.Comment(value={"The highest a silver ore vein can generate."})
        @Config.RangeInt(min=0, max=255)
        public int silverMaxY = 28;
        @Config.Comment(value={"The lowest a silver of vein can generate."})
        @Config.RangeInt(min=0, max=255)
        public int silverMinY = 0;
    }

    public static class ConfigMysticalWorldOreDebugging {
        @Config.Comment(value={"Enable debugging at all. Specific ores will need to be enabled individually before any messages will be printed."})
        @Config.Name(value="Enable Debugging")
        public boolean enableDebugging = false;
        @Config.Comment(value={"Enable debugging to the standard log file. Useful if you do not generate or have access to debug.log. WARNING: WILL OVERLY INFLATE YOUR STANDARD LOG FILE. ONLY ENABLE IF NEEDED."})
        @Config.Name(value="Enable Info Debugging (ONLY IF NEEDED)")
        public boolean enableInfoDebugging = false;
        @Config.Comment(value={"Enable the debugging of Amethyst Ore"})
        @Config.Name(value="Debug Amethyst Ore")
        public boolean debugAmethyst = false;
        @Config.Comment(value={"Enable the debugging of Copper Ore"})
        @Config.Name(value="Debug Copper Ore")
        public boolean debugCopper = false;
        @Config.Comment(value={"Enable the debugging of Silver Ore"})
        @Config.Name(value="Debug Silver Ore")
        public boolean debugSilver = false;
    }

    public static class ConfigMysticalWorldMetals {
        @Config.Comment(value={"Enable Tiny Dusts for Metals"})
        public boolean enableTinyDusts = true;
        @Config.Comment(value={"Enable Dusts for Metals"})
        public boolean enableDusts = true;
        @Config.Comment(value={"Enable Ores for Metals"})
        public boolean enableOres = true;
        @Config.Comment(value={"Enable Blocks for Metals"})
        public boolean enableBlocks = true;
        @Config.Comment(value={"Enable Ingots for Metals"})
        public boolean enableIngots = true;
        @Config.Comment(value={"Enable Nuggets for Metals"})
        public boolean enableNuggets = true;
        @Config.Comment(value={"Enable Copper"})
        public boolean enableCopper = true;
        @Config.Comment(value={"Enable Silver"})
        public boolean enableSilver = true;
    }

    public static class ConfigMysticalWorldGems {
        @Config.Comment(value={"Enabled Amethyst"})
        public boolean enableAmethyst = true;
        @Config.Comment(value={"Enable blocks"})
        public boolean enableBlocks = true;
        @Config.Comment(value={"Enable gems"})
        public boolean enableGems = true;
        @Config.Comment(value={"Enable ore"})
        public boolean enableOres = true;
    }

    public static class ConfigMysticalWorldFrog {
        @Config.Comment(value={"Spawn rate of frog"})
        public int rate = 6;
        @Config.Comment(value={"Min number of frogs to spawn in a group"})
        public int min = 2;
        @Config.Comment(value={"Maximum number of frogs to spawn in a group"})
        public int max = 4;
        @Config.Comment(value={"Biomes to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"SWAMP", "JUNGLE", "BEACH", "RIVER"};
    }

    public static class ConfigMysticalWorldBeetle {
        @Config.Comment(value={"Spawn rate of beetle"})
        public int rate = 5;
        @Config.Comment(value={"Min number of beetles to spawn in a group"})
        public int min = 2;
        @Config.Comment(value={"Maximum number of beetles to spawn in a group"})
        public int max = 4;
        @Config.Comment(value={"Biome types to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"SWAMP", "JUNGLE", "FOREST", "PLAINS"};
    }

    public static class ConfigMysticalWorldFox {
        @Config.Comment(value={"Spawn rate of fox"})
        public int rate = 4;
        @Config.Comment(value={"Min number of fox to spawn in a group"})
        public int min = 1;
        @Config.Comment(value={"Maximum number of fox to spawn in a group"})
        public int max = 3;
        @Config.Comment(value={"Biomes to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"FOREST", "COLD", "CONIFEROUS"};
    }

    public static class ConfigMysticalWorldDeer {
        @Config.Comment(value={"Spawn rate of deer"})
        public int rate = 6;
        @Config.Comment(value={"Min number of deer to spawn in a group"})
        public int min = 2;
        @Config.Comment(value={"Maximum number of deer to spawn in a group"})
        public int max = 4;
        @Config.Comment(value={"Biomes to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"FOREST", "COLD", "CONIFEROUS", "PLAINS"};
    }

    public static class ConfigMysticalWorldSprout {
        @Config.Comment(value={"Spawn rate of sprouts"})
        public int rate = 2;
        @Config.Comment(value={"Min number of sprouts to spawn in a group"})
        public int min = 2;
        @Config.Comment(value={"Maximum number of sprouts to spawn in a group"})
        public int max = 4;
        @Config.Comment(value={"Biomes to spawn in. List consisting of elements from: |SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID|"})
        public String[] biomes = new String[]{"JUNGLE", "LUSH", "MAGICAL", "RIVER", "FOREST", "BEACH"};
    }

    public static class ConfigMysticalWorldMobs {
        @Config.Comment(value={"Enable the spawning of Deer."})
        public boolean spawnDeer = true;
        @Config.Comment(value={"Enable the spawning of Fox."})
        public boolean spawnFox = true;
        @Config.Comment(value={"Enable the spawning of Beetle."})
        public boolean spawnBeetle = true;
        @Config.Comment(value={"Enable the spawning of Frog."})
        public boolean spawnFrog = true;
        @Config.Comment(value={"Enable the spawning of Sprouts"})
        public boolean spawnSprout = true;
    }

    public static class ConfigMysticalWorldModules {
        @Config.Comment(value={"Enable Roots Content"})
        public boolean rootsModuleEnabled = true;
        @Config.Comment(value={"Enable Embers Content"})
        public boolean embersModuleEnabled = true;
        @Config.Comment(value={"Enable Mystical World Content"})
        public boolean mysticalWorldModuleEnabled = true;
        @Config.Comment(value={"Enable Solar Content"})
        public boolean solarModuleEnabled = true;
    }
}

