/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.blocks;

import com.blakebr0.cucumber.block.BlockBase;
import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.iface.IModelHelper;
import com.blakebr0.mysticalagradditions.MysticalAgradditions;
import com.blakebr0.mysticalagradditions.config.ModConfig;
import com.blakebr0.mysticalagriculture.util.ModChecker;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;

public class BlockSpecial
extends BlockBase
implements IModelHelper {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"variant", Type.class);

    public BlockSpecial() {
        super("ma.special", Material.field_151576_e, SoundType.field_185851_d, 5.0f, 10.0f);
        this.func_149647_a(MysticalAgradditions.tabMysticalAgradditions);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.NETHER_STAR)));
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> stacks) {
        for (Type type : Type.values()) {
            if (!type.isEnabled()) continue;
            stacks.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public void initModels() {
        for (Type type : Type.values()) {
            if (!type.isEnabled()) continue;
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)ResourceHelper.getModelResource((String)"mysticalagradditions", (String)("special_" + Type.byMetadata(type.getMetadata()).func_176610_l()), (String)"inventory"));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public static enum Type implements IStringSerializable
    {
        NETHER_STAR(0, "nether_star", ModConfig.confNetherStarSeeds),
        DRAGON_EGG(1, "dragon_egg", ModConfig.confDragonEggSeeds),
        PH2(2, "ph2", false),
        PH3(3, "ph3", false),
        AWAKENED_DRACONIUM(4, "awakened_draconium", ModConfig.confAwakenedDraconiumSeeds && ModChecker.DRACONIC_EVOLUTION),
        NEUTRONIUM(5, "neutronium", ModConfig.confNeutroniumSeeds && Loader.isModLoaded((String)"avaritia"));

        private static final Type[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final boolean enabled;
        private boolean debug = false;

        private Type(int meta, String name, boolean enabled) {
            this.meta = meta;
            this.name = name;
            this.enabled = enabled;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled || this.debug;
        }

        public static Type byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.META_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

