/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public final class StackUtils {
    public static boolean equalsWildcard(ItemStack wild, ItemStack check) {
        if (wild.func_190926_b() && check.func_190926_b()) {
            return true;
        }
        return wild.func_77973_b() == check.func_77973_b() && (wild.func_77952_i() == Short.MAX_VALUE || check.func_77952_i() == Short.MAX_VALUE || wild.func_77952_i() == check.func_77952_i());
    }

    public static boolean equalsWildcardWithNBT(ItemStack wild, ItemStack check) {
        boolean wildcard = StackUtils.equalsWildcard(wild, check);
        if (wild.func_190926_b() || check.func_190926_b()) {
            return wildcard;
        }
        return wildcard && (!wild.func_77942_o() ? !check.func_77942_o() : wild.func_77978_p() == check.func_77978_p() || wild.func_77978_p().equals((Object)check.func_77978_p()));
    }

    public static ItemStack subtract(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack2.func_190926_b()) {
            return stack1;
        }
        return StackUtils.size(stack1, stack1.func_190916_E() - stack2.func_190916_E());
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = stack.func_77946_l();
        ret.func_190920_e(size);
        return ret;
    }

    public static List<ItemStack> getMergeRejects(NonNullList<ItemStack> orig, NonNullList<ItemStack> toAdd) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < toAdd.size(); ++i) {
            ItemStack reject;
            if (((ItemStack)toAdd.get(i)).func_190926_b() || (reject = StackUtils.getMergeReject((ItemStack)orig.get(i), (ItemStack)toAdd.get(i))).func_190926_b()) continue;
            ret.add(reject);
        }
        return ret;
    }

    public static void merge(NonNullList<ItemStack> orig, NonNullList<ItemStack> toAdd) {
        for (int i = 0; i < toAdd.size(); ++i) {
            if (((ItemStack)toAdd.get(i)).func_190926_b()) continue;
            orig.set(i, (Object)StackUtils.merge((ItemStack)orig.get(i), (ItemStack)toAdd.get(i)));
        }
    }

    private static ItemStack merge(ItemStack orig, ItemStack toAdd) {
        if (orig.func_190926_b()) {
            return toAdd;
        }
        if (toAdd.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)orig, (ItemStack)toAdd)) {
            return orig;
        }
        return StackUtils.size(orig, Math.min(orig.func_77976_d(), orig.func_190916_E() + toAdd.func_190916_E()));
    }

    private static ItemStack getMergeReject(ItemStack orig, ItemStack toAdd) {
        if (orig.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (toAdd.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)orig, (ItemStack)toAdd)) {
            return orig;
        }
        int newSize = orig.func_190916_E() + toAdd.func_190916_E();
        if (newSize > orig.func_77976_d()) {
            return StackUtils.size(orig, newSize - orig.func_77976_d());
        }
        return StackUtils.size(orig, newSize);
    }

    public static int hashItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return -1;
        }
        ResourceLocation registryName = stack.func_77973_b().getRegistryName();
        int nameHash = registryName == null ? 0 : registryName.hashCode();
        return nameHash << 8 | stack.func_77960_j();
    }

    @Nonnull
    public static IBlockState getStateForPlacement(ItemStack stack, World world, BlockPos pos, EntityPlayer player) {
        Block blockFromItem = Block.func_149634_a((Item)stack.func_77973_b());
        return blockFromItem.getStateForPlacement(world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, stack.func_77960_j(), (EntityLivingBase)player, EnumHand.MAIN_HAND);
    }
}

