/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.feature;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.Quark;
import vazkii.quark.base.client.RenderBlank;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.network.message.MessageDismountSeat;

public class SitInStairs
extends Feature {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        String name = "quark:seat";
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(name), Seat.class, (String)name, (int)12, (Object)Quark.instance, (int)16, (int)128, (boolean)false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        RenderingRegistry.registerEntityRenderingHandler(Seat.class, RenderBlank::new);
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        List seats;
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_70093_af() || player.func_184187_bx() != null) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Vec3d vec = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        double maxDist = 2.0;
        if ((vec.field_72450_a - player.field_70165_t) * (vec.field_72450_a - player.field_70165_t) + (vec.field_72448_b - player.field_70163_u) * (vec.field_72448_b - player.field_70163_u) + (vec.field_72449_c - player.field_70161_v) * (vec.field_72449_c - player.field_70161_v) > maxDist * maxDist) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack1 = player.func_184614_ca();
        ItemStack stack2 = player.func_184592_cb();
        if (!stack1.func_190926_b() || !stack2.func_190926_b()) {
            return;
        }
        if (state.func_177230_c() instanceof BlockStairs && state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.BOTTOM && !state.isSideSolid((IBlockAccess)world, pos, Objects.requireNonNull(event.getFace())) && SitInStairs.canBeAbove(world, pos) && (seats = world.func_72872_a(Seat.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)))).isEmpty()) {
            Seat seat = new Seat(world, pos);
            world.func_72838_d((Entity)seat);
            if (event.getEntityPlayer().func_184220_m((Entity)seat)) {
                event.getEntityPlayer().func_70634_a(seat.field_70165_t, seat.field_70163_u, seat.field_70161_v);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public static boolean canBeAbove(World world, BlockPos pos) {
        BlockPos upPos = pos.func_177984_a();
        IBlockState state = world.func_180495_p(upPos);
        return state.func_185890_d((IBlockAccess)world, upPos) == null;
    }

    public static class Seat
    extends Entity {
        public Seat(World world, BlockPos pos) {
            this(world);
            this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }

        public Seat(World par1World) {
            super(par1World);
            this.func_70105_a(0.25f, 0.25f);
        }

        public double func_70042_X() {
            return -0.25;
        }

        @Nonnull
        public BlockPos func_180425_c() {
            return new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }

        public boolean func_70075_an() {
            return false;
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            BlockPos pos = this.func_180425_c();
            if (!(this.func_130014_f_().func_180495_p(pos).func_177230_c() instanceof BlockStairs) || !SitInStairs.canBeAbove(this.func_130014_f_(), pos)) {
                this.func_70106_y();
                return;
            }
            List passengers = this.func_184188_bt();
            if (passengers.isEmpty()) {
                this.func_70106_y();
            }
            for (Entity e : passengers) {
                if (!e.func_70093_af() && !(e.func_70068_e((Entity)this) >= 1.0)) continue;
                this.func_70106_y();
            }
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (this.field_70170_p.field_72995_K) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDismountSeat());
            }
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(@Nonnull NBTTagCompound nbttagcompound) {
        }

        protected void func_70014_b(@Nonnull NBTTagCompound nbttagcompound) {
        }
    }
}

