/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.interf.IStateMapperProvider;
import vazkii.quark.decoration.client.state.FlowerPotStateMapper;
import vazkii.quark.decoration.feature.ColoredFlowerPots;

public class BlockCustomFlowerPot
extends BlockFlowerPot
implements IBlockColorProvider,
IStateMapperProvider {
    public static final PropertyBool CUSTOM = PropertyBool.func_177716_a((String)"custom");
    public static final String TAG_TEXTURE_PATH = "texture_path";

    public BlockCustomFlowerPot() {
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176443_b, (Comparable)BlockFlowerPot.EnumFlowerType.EMPTY).func_177226_a((IProperty)field_176444_a, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)CUSTOM, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected ExtendedBlockState createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{field_176443_b, field_176444_a, CUSTOM}, new IUnlistedProperty[]{TEXTURE});
    }

    public boolean func_180639_a(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, EntityPlayer player, @Nonnull EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityFlowerPot)) {
            return false;
        }
        TileEntityFlowerPot flowerPot = (TileEntityFlowerPot)te;
        ItemStack flower = flowerPot.func_184403_b();
        if (flower.func_190926_b()) {
            if (!ColoredFlowerPots.isFlower(stack)) {
                return false;
            }
            flowerPot.func_190614_a(stack);
            flowerPot.getTileData().func_82580_o(TAG_TEXTURE_PATH);
            player.func_71029_a(StatList.field_188088_V);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        } else {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)flower, (int)player.field_71071_by.field_70461_c);
            flowerPot.func_190614_a(ItemStack.field_190927_a);
        }
        flowerPot.func_70296_d();
        world.func_184138_a(pos, state, state, 3);
        return true;
    }

    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity te;
        if ((state = super.func_176221_a(state, world, pos)).func_177229_b((IProperty)field_176443_b) == BlockFlowerPot.EnumFlowerType.EMPTY && (te = world.func_175625_s(pos)) instanceof TileEntityFlowerPot && !((TileEntityFlowerPot)te).func_184403_b().func_190926_b()) {
            state = state.func_177226_a((IProperty)CUSTOM, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)CUSTOM)).booleanValue()) {
            return state;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFlowerPot) {
            Block block;
            ItemStack stack;
            TileEntityFlowerPot flowerPot = (TileEntityFlowerPot)te;
            String texture = flowerPot.getTileData().func_74779_i(TAG_TEXTURE_PATH);
            if (texture.isEmpty() && !(stack = flowerPot.func_184403_b()).func_190926_b() && (block = Block.func_149634_a((Item)stack.func_77973_b())) != Blocks.field_150350_a) {
                IBlockState blockState = block.func_176203_a(stack.func_77973_b().getMetadata(stack));
                texture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(blockState).func_94215_i();
                flowerPot.getTileData().func_74778_a(TAG_TEXTURE_PATH, texture);
            }
            if (!texture.isEmpty()) {
                state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)TEXTURE, (Object)texture);
            }
        }
        return state;
    }

    public boolean func_149740_M(IBlockState state) {
        return ColoredFlowerPots.enableComparatorLogic;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        if (!ColoredFlowerPots.enableComparatorLogic) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFlowerPot) {
            return this.getComparatorSignal(((TileEntityFlowerPot)te).func_184403_b());
        }
        return 0;
    }

    private int getComparatorSignal(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return ColoredFlowerPots.getFlowerComparatorPower(stack);
    }

    public IItemColor getItemColor() {
        return (stack, i) -> -1;
    }

    public IBlockColor getBlockColor() {
        return (state, world, pos, index) -> {
            TileEntity tileentity;
            if (world != null && pos != null && (tileentity = world.func_175625_s(pos)) instanceof TileEntityFlowerPot) {
                ItemStack stack = ((TileEntityFlowerPot)tileentity).func_184403_b();
                return ColoredFlowerPots.getStackBlockColorsSafe(stack, world, pos, 0);
            }
            return -1;
        };
    }

    @SideOnly(value=Side.CLIENT)
    public IStateMapper getStateMapper() {
        return FlowerPotStateMapper.INSTANCE;
    }
}

