/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.api.module.IFeature;
import vazkii.quark.api.module.IModule;
import vazkii.quark.base.module.ConfigHelper;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleLoader;

public class Feature
implements IFeature {
    public Module module;
    public boolean loadtimeDone;
    public boolean enabledAtLoadtime;
    public boolean enabledByDefault;
    public boolean enabled;
    public boolean prevEnabled;
    public String configCategory;
    public String configName;
    public Property prop;
    public boolean forceLoad;

    public final void setupConstantConfig() {
        String[] incompat = this.getIncompatibleMods();
        if (incompat != null && incompat.length > 0) {
            StringBuilder desc = new StringBuilder("This feature disables itself if any of the following mods are loaded: \n");
            for (String s : incompat) {
                desc.append(" - ").append(s).append("\n");
            }
            desc.append("This is done to prevent content overlap.\nYou can turn this on to force the feature to be loaded even if the above mods are also loaded.");
            ConfigHelper.needsRestart = true;
            this.forceLoad = this.loadPropBool("Force Enabled", desc.toString(), false);
        }
    }

    public void setupConfig() {
    }

    public void onEnabled() {
    }

    public void onDisabled() {
    }

    public void preInit(FMLPreInitializationEvent event) {
    }

    public void postPreInit() {
    }

    public void init() {
    }

    public void postInit() {
    }

    public void finalInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
    }

    @SideOnly(value=Side.CLIENT)
    public void initClient() {
    }

    @SideOnly(value=Side.CLIENT)
    public void postInitClient() {
    }

    public void serverStarting() {
    }

    public String[] getIncompatibleMods() {
        return null;
    }

    public boolean hasSubscriptions() {
        return false;
    }

    public boolean hasTerrainSubscriptions() {
        return false;
    }

    public boolean hasOreGenSubscriptions() {
        return false;
    }

    public String getFeatureDescription() {
        return "";
    }

    public String getFeatureIngameConfigName() {
        return WordUtils.capitalizeFully((String)this.configName);
    }

    public boolean requiresMinecraftRestartToEnable() {
        return false;
    }

    public static void registerTile(Class<? extends TileEntity> clazz, String key) {
        GameRegistry.registerTileEntity(clazz, (ResourceLocation)new ResourceLocation("quark", key));
    }

    public static void addOreDict(String key, Item value) {
        Feature.addOreDict(key, ProxyRegistry.newStack((Item)value));
    }

    public static void addOreDict(String key, Block value) {
        Feature.addOreDict(key, ProxyRegistry.newStack((Block)value));
    }

    public static void addOreDict(String key, ItemStack value) {
        ModuleLoader.lazyOreDictRegisters.add(() -> OreDictionary.registerOre((String)key, (ItemStack)value));
    }

    @Override
    public final boolean isClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public final boolean hasConfigKey(String propName) {
        return ConfigHelper.hasConfigKey(propName, this.configCategory);
    }

    public final int loadPropInt(String propName, String desc, int default_) {
        return ConfigHelper.loadPropInt(propName, this.configCategory, desc, default_);
    }

    public final double loadPropDouble(String propName, String desc, double default_) {
        return ConfigHelper.loadPropDouble(propName, this.configCategory, desc, default_);
    }

    public final boolean loadPropBool(String propName, String desc, boolean default_) {
        return ConfigHelper.loadPropBool(propName, this.configCategory, desc, default_);
    }

    public final String loadPropString(String propName, String desc, String default_) {
        return ConfigHelper.loadPropString(propName, this.configCategory, desc, default_);
    }

    public final String[] loadPropStringList(String propName, String desc, String[] default_) {
        return ConfigHelper.loadPropStringList(propName, this.configCategory, desc, default_);
    }

    public final double loadLegacyPropChance(String propName, String oldName, String desc, double default_) {
        return ConfigHelper.loadLegacyPropChance(propName, this.configCategory, oldName, desc, default_);
    }

    public final void initializeEnchantmentList(String[] enchantNames, List<Enchantment> enchants) {
        enchants.clear();
        for (String s : enchantNames) {
            ResourceLocation r = new ResourceLocation(s);
            Enchantment e = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)r);
            if (e == null) continue;
            enchants.add(e);
        }
    }

    public static boolean isVanilla(IForgeRegistryEntry entry) {
        ResourceLocation loc = entry.getRegistryName();
        return loc != null && loc.func_110624_b().equals("minecraft");
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getName() {
        return this.configName;
    }
}

