/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.asm;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiBeacon;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.automation.client.render.PistonTileEntityRenderer;
import vazkii.quark.automation.feature.PistonSpikes;
import vazkii.quark.automation.feature.PistonsMoveTEs;
import vazkii.quark.automation.feature.PistonsPushPullItems;
import vazkii.quark.client.feature.BetterFireEffect;
import vazkii.quark.client.feature.ItemsFlashBeforeExpiring;
import vazkii.quark.client.feature.RenderItemsInChat;
import vazkii.quark.client.feature.ShowInvalidSlots;
import vazkii.quark.decoration.feature.IronLadders;
import vazkii.quark.decoration.feature.MoreBannerLayers;
import vazkii.quark.experimental.features.BetterNausea;
import vazkii.quark.experimental.features.CollateralPistonMovement;
import vazkii.quark.experimental.features.ColoredLights;
import vazkii.quark.management.feature.BetterCraftShifting;
import vazkii.quark.misc.feature.AncientTomes;
import vazkii.quark.misc.feature.ColorRunes;
import vazkii.quark.misc.feature.ExtraPotions;
import vazkii.quark.misc.feature.Pickarang;
import vazkii.quark.tweaks.feature.HoeSickle;
import vazkii.quark.tweaks.feature.ImprovedSleeping;
import vazkii.quark.tweaks.feature.SpringySlime;
import vazkii.quark.vanity.client.emotes.EmoteHandler;
import vazkii.quark.vanity.client.render.BoatBannerRenderer;
import vazkii.quark.vanity.feature.BoatSails;
import vazkii.quark.vanity.feature.WitchHat;

public final class ASMHooks {
    public static void updateEmotes(Entity e) {
        EmoteHandler.updateEmotes(e);
    }

    public static void setColorRuneTargetStack(EntityLivingBase entity, EntityEquipmentSlot slot) {
        ColorRunes.setTargetStack(entity, slot);
    }

    public static void setColorRuneTargetStack(ItemStack stack) {
        ColorRunes.setTargetStack(stack);
    }

    public static int getRuneColor(int original) {
        return ColorRunes.getColor(original);
    }

    public static void applyRuneColor() {
        ColorRunes.applyColor();
    }

    public static void onBoatUpdate(EntityBoat boat) {
        BoatSails.onBoatUpdate(boat);
    }

    public static void dropBoatBanner(EntityBoat boat) {
        BoatSails.dropBoatBanner(boat);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBannerOnBoat(EntityBoat boat, float partial) {
        BoatBannerRenderer.renderBanner(boat, partial);
    }

    public static void onPistonMove(World world, BlockPos sourcePos, BlockPistonStructureHelper helper, EnumFacing facing, boolean extending) {
        EnumFacing realFacing = extending ? facing : facing.func_176734_d();
        PistonSpikes.breakStuffWithSpikes(world, sourcePos, helper, realFacing, extending);
        CollateralPistonMovement.applyCollateralMovements(world, helper, realFacing, extending);
        PistonsMoveTEs.detachTileEntities(world, helper, realFacing);
    }

    public static int getMaxInventoryBoundaryCrafting(int min, int max) {
        return BetterCraftShifting.getMaxInventoryBoundaryCrafting(min, max);
    }

    public static int getMaxInventoryBoundaryVillager(int min, int max) {
        return BetterCraftShifting.getMaxInventoryBoundaryVillager(min, max);
    }

    public static int getMinInventoryBoundaryCrafting(int min, int max) {
        return BetterCraftShifting.getMinInventoryBoundaryCrafting(min, max);
    }

    public static int getMinInventoryBoundaryVillager(int min, int max) {
        return BetterCraftShifting.getMinInventoryBoundaryVillager(min, max);
    }

    public static boolean shouldPistonMoveTE(boolean te, IBlockState state) {
        return PistonsMoveTEs.shouldMoveTE(te, state);
    }

    public static boolean setPistonBlock(World world, BlockPos pos, IBlockState state, int flags) {
        return PistonsMoveTEs.setPistonBlock(world, pos, state, flags);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean renderPistonBlock(BlockPos pos, IBlockState state, BufferBuilder buffer, World world, boolean checkSides) {
        return PistonTileEntityRenderer.renderPistonBlock(pos, state, buffer, world, checkSides);
    }

    public static void onPistonUpdate(TileEntityPiston piston) {
        PistonsPushPullItems.onPistonUpdate(piston);
    }

    public static int isEveryoneAsleep(World world) {
        return ImprovedSleeping.isEveryoneAsleep(world);
    }

    public static void whenPlayersWake(WorldServer world) {
        ImprovedSleeping.whenNightPasses(world);
    }

    @SideOnly(value=Side.CLIENT)
    public static void putColorsFlat(IBlockAccess world, IBlockState state, BlockPos pos, BufferBuilder buffer, BakedQuad quad, int brightness) {
        ColoredLights.putColorsFlat(world, state, pos, buffer, quad, brightness);
    }

    public static int shiftLayerCount(int amount) {
        return amount + 6 - MoreBannerLayers.getLayerCount();
    }

    public static boolean renderFire(Entity entity, double x, double y, double z) {
        return BetterFireEffect.renderFire(entity, x, y, z);
    }

    public static boolean hasWitchHat(EntityLiving attacker, @Nullable EntityLivingBase target) {
        return WitchHat.hasWitchHat(attacker, target);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawInvalidSlotOverlays(GuiContainer container) {
        ShowInvalidSlots.renderElements(container);
    }

    public static void applyCollisionLogic(Entity entity, double attemptedX, double attemptedY, double attemptedZ, double dX, double dY, double dZ) {
        SpringySlime.onEntityCollision(entity, attemptedX, attemptedY, attemptedZ, dX, dY, dZ);
    }

    public static void recordMotion(Entity entity) {
        SpringySlime.recordMotion(entity);
    }

    public static void ensureUpdatedItemAge(EntityItem entityItem) {
        ItemsFlashBeforeExpiring.updateItemInfo(entityItem);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean renderBeaconButton(GuiButton button, GuiBeacon beacon, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        return ExtraPotions.renderPotion(button, beacon, minecraft, mouseX, mouseY, partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderNausea(EntityRenderer renderer, float partialTicks) {
        BetterNausea.renderNausea(renderer, partialTicks);
    }

    public static boolean canSharpnessApply(ItemStack stack) {
        return Pickarang.canSharpnessApply(stack);
    }

    public static ITextComponent createStackComponent(ITextComponent component) {
        return RenderItemsInChat.createStackComponent(component);
    }

    public static boolean canFortuneApply(Enchantment enchantment, ItemStack stack) {
        return HoeSickle.canFortuneApply(enchantment, stack);
    }

    public static boolean isBlockNotBrokenByWater(Block block) {
        return IronLadders.isBlockNotBrokenByWater(block);
    }

    public static NBTTagList getEnchantmentsForStack(NBTTagList previous, ItemStack stack) {
        return AncientTomes.getEnchantmentsForStack(previous, stack);
    }
}

