/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.feature;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;

public class AnimalsEatFloorFood
extends Feature {
    private static final int MOB_COUNT_DIV = 289;
    private static final Set<ChunkPos> eligibleChunksForSpawning = new HashSet<ChunkPos>();
    public static int maxCreaturesPerChunkArea;

    @Override
    public void setupConfig() {
        maxCreaturesPerChunkArea = this.loadPropInt("Maximum entities per chunk area", "Prevents entities from proliferating infinitely. Set to 0 or less to disable checking.", 30);
    }

    private int getSpawnAllowedChunks(EntityAnimal animal, WorldServer world) {
        eligibleChunksForSpawning.clear();
        int chunks = 0;
        for (EntityPlayer entityplayer : world.field_73010_i) {
            if (entityplayer.func_175149_v() || !(animal.func_70068_e((Entity)entityplayer) < 4096.0)) continue;
            int chunkX = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int chunkZ = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            for (int x = -8; x <= 8; ++x) {
                for (int z = -8; z <= 8; ++z) {
                    PlayerChunkMapEntry chunkEntry;
                    boolean chunkEdge = x == -8 || x == 8 || z == -8 || z == 8;
                    ChunkPos chunkPos = new ChunkPos(x + chunkX, z + chunkZ);
                    if (eligibleChunksForSpawning.contains(chunkPos)) continue;
                    ++chunks;
                    if (chunkEdge || !world.func_175723_af().func_177730_a(chunkPos) || (chunkEntry = world.func_184164_w().func_187301_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) == null || !chunkEntry.func_187274_e()) continue;
                    eligibleChunksForSpawning.add(chunkPos);
                }
            }
        }
        return chunks;
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        EntityAnimal animal;
        if (event.getEntityLiving() instanceof EntityAnimal && event.getEntityLiving().field_70170_p instanceof WorldServer && (animal = (EntityAnimal)event.getEntityLiving()).func_70874_b() == 0 && animal.field_70173_aa % 20 == 0 && !animal.func_70880_s() && !animal.field_70128_L) {
            int max;
            int count;
            double range = 2.0;
            if (maxCreaturesPerChunkArea > 0 && (count = animal.field_70170_p.countEntities(EnumCreatureType.CREATURE, true)) > (max = maxCreaturesPerChunkArea * this.getSpawnAllowedChunks(animal, (WorldServer)animal.field_70170_p) / 289)) {
                return;
            }
            List nearbyFood = animal.func_130014_f_().func_175647_a(EntityItem.class, animal.func_174813_aQ().func_72321_a(range, 0.0, range), i -> i != null && !i.func_92059_d().func_190926_b() && !i.field_70128_L && animal.func_70877_b(i.func_92059_d()) && i.func_92059_d().func_77973_b() != Items.field_151078_bh);
            if (!nearbyFood.isEmpty()) {
                nearbyFood.sort(Comparator.comparingDouble(ent -> ent.func_70068_e((Entity)animal)));
                EntityItem e = (EntityItem)nearbyFood.get(0);
                ItemStack stack = e.func_92059_d();
                ItemStack original = stack.func_77946_l();
                stack.func_190918_g(1);
                e.func_92058_a(stack);
                if (stack.func_190926_b()) {
                    e.func_70106_y();
                }
                if (animal instanceof EntityWolf && original.func_77973_b() instanceof ItemFood && animal.func_110143_aJ() < animal.func_110138_aP()) {
                    animal.func_70691_i((float)((ItemFood)original.func_77973_b()).func_150905_g(original));
                } else {
                    animal.func_146082_f(null);
                }
            }
        }
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"betterwithmods", "easybreeding", "animania"};
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

