/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import com.google.common.base.Preconditions;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeMutationBuilder;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleEffect;
import forestry.api.genetics.IAlleleSpeciesBuilder;
import forestry.api.genetics.IMutationCondition;
import forestry.apiculture.items.EnumHoneyComb;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import magicbees.MagicBees;
import magicbees.bees.BeeIntegrationInterface;
import magicbees.bees.EnumBeeBranches;
import magicbees.bees.mutation.MoonPhaseMutationBonus;
import magicbees.bees.mutation.MoonPhaseMutationRestriction;
import magicbees.elec332.corerepack.compat.forestry.ForestryAlleles;
import magicbees.elec332.corerepack.compat.forestry.IIndividualBranch;
import magicbees.elec332.corerepack.compat.forestry.IIndividualDefinition;
import magicbees.elec332.corerepack.compat.forestry.bee.BeeGenomeTemplate;
import magicbees.elec332.corerepack.compat.forestry.bee.IBeeTemplate;
import magicbees.elec332.corerepack.util.MoonPhase;
import magicbees.init.AlleleRegister;
import magicbees.init.ItemRegister;
import magicbees.item.types.EnumCombType;
import magicbees.item.types.EnumDropType;
import magicbees.item.types.EnumPollenType;
import magicbees.item.types.EnumResourceType;
import magicbees.util.EnumOreResourceType;
import magicbees.util.IMagicBeesBranch;
import magicbees.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public enum EnumBeeSpecies implements IBeeTemplate
{
    MYSTICAL("mysticum", EnumBeeBranches.VEILED, true, new Color(11534263)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MUNDANE), Float.valueOf(0.15f));
        }

        @Override
        public void registerMutations() {
            this.registerMundaneMutations();
        }
    }
    ,
    SORCEROUS("fascinatio", EnumBeeBranches.VEILED, true, new Color(0xEA9A9A)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setFertility(ForestryAlleles.FERTILITY_HIGH);
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_DOWN_2);
            template.setHumidityTolerance(ForestryAlleles.TOLERANCE_UP_1);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HOT);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MUNDANE), Float.valueOf(0.15f));
        }

        @Override
        public void registerMutations() {
            this.registerMundaneMutations();
        }
    }
    ,
    UNUSUAL("inusitatus", EnumBeeBranches.VEILED, true, new Color(7525217)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_2);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MUNDANE), Float.valueOf(0.15f));
        }

        @Override
        public void registerMutations() {
            this.registerMundaneMutations();
        }
    }
    ,
    ATTUNED("similis", EnumBeeBranches.VEILED, true, new Color(34472)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setFertility(ForestryAlleles.FERTILITY_HIGH);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MUNDANE), Float.valueOf(0.15f));
        }

        @Override
        public void registerMutations() {
            this.registerMundaneMutations();
        }
    }
    ,
    ELDRITCH("prodigiosus", EnumBeeBranches.VEILED, true, new Color(9270688)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setSpeed(ForestryAlleles.SPEED_SLOWER);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MUNDANE), Float.valueOf(0.15f));
        }

        @Override
        public void registerMutations() {
        }
    }
    ,
    ESOTERIC("secretiore", EnumBeeBranches.ARCANE, true, new Color(4249)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.OCCULT), Float.valueOf(0.18f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Cultivated"), ELDRITCH, 10);
        }
    }
    ,
    MYSTERIOUS("mysticus", EnumBeeBranches.ARCANE, true, new Color(7744450)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_2);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.OCCULT), Float.valueOf(0.2f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(ELDRITCH, ESOTERIC, 8);
        }
    }
    ,
    ARCANE("arcanus", EnumBeeBranches.ARCANE, true, new Color(13779679)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_2);
            template.setFertility(ForestryAlleles.FERTILITY_NORMAL);
            template.setFloweringSpeed(ForestryAlleles.FLOWERING_AVERAGE);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.OCCULT), Float.valueOf(0.25f));
            speciesBuilder.addSpecialty(EnumBeeSpecies.getDrop(EnumDropType.ENCHANTED), Float.valueOf(0.09f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(ESOTERIC, MYSTERIOUS, 8).addMutationCondition((IMutationCondition)new MoonPhaseMutationBonus(MoonPhase.WAXING_CRESCENT, MoonPhase.WAXING_GIBBOUS, 1.2f));
        }
    }
    ,
    CHARMED("larvatus", EnumBeeBranches.SUPERNATURAL, true, new Color(4779756)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.OTHERWORLDLY), Float.valueOf(0.18f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Cultivated"), ELDRITCH, 10);
        }
    }
    ,
    ENCHANTED("cantatus", EnumBeeBranches.SUPERNATURAL, true, new Color(1632038)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.OTHERWORLDLY), Float.valueOf(0.2f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(ELDRITCH, CHARMED, 8);
        }
    }
    ,
    SUPERNATURAL("coeleste", EnumBeeBranches.SUPERNATURAL, true, new Color(22036)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_2);
            template.setHumidityTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.OTHERWORLDLY), Float.valueOf(0.25f));
            speciesBuilder.addSpecialty(EnumBeeSpecies.getPollen(EnumPollenType.UNUSUAL), Float.valueOf(0.08f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(CHARMED, ENCHANTED, 8).addMutationCondition((IMutationCondition)new MoonPhaseMutationBonus(MoonPhase.WANING_GIBBOUS, MoonPhase.WANING_CRESCENT, 1.2f));
        }
    }
    ,
    ETHEREAL("diaphanum", (IMagicBeesBranch)EnumBeeBranches.MAGICAL, true, new Color(0xBA3B3B), new Color(0xEFF8FF)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setLifeSpan(ForestryAlleles.LIFESPAN_SHORTENED);
            template.setFloweringSpeed(ForestryAlleles.FLOWERING_AVERAGE);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.OCCULT), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.OTHERWORLDLY), Float.valueOf(0.1f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(ARCANE, SUPERNATURAL, 7);
        }
    }
    ,
    WATERY("aquatilis", EnumBeeBranches.MAGICAL, true, new Color(3226718)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setHumidityTolerance(ForestryAlleles.TOLERANCE_UP_1);
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_DOWN_2);
            template.setFlowerProvider(ForestryAlleles.FLOWERS_SNOW);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.WATERY), Float.valueOf(0.25f));
            speciesBuilder.addSpecialty(new ItemStack(Blocks.field_150432_aD), Float.valueOf(0.025f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SUPERNATURAL, ETHEREAL, 14).requireResource(new IBlockState[]{Blocks.field_150355_j.func_176223_P()});
        }
    }
    ,
    EARTHY("fictili", EnumBeeBranches.MAGICAL, true, new Color(7897645)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setHumidityTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
            template.setLifeSpan(ForestryAlleles.LIFESPAN_LONG);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.EARTHY), Float.valueOf(0.25f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SUPERNATURAL, ETHEREAL, 14).requireResource((IBlockState[])Blocks.field_150336_V.func_176194_O().func_177619_a().toArray((Object[])new IBlockState[0]));
        }
    }
    ,
    FIREY("ardens", EnumBeeBranches.MAGICAL, true, new Color(13848857)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setHumidityTolerance(ForestryAlleles.TOLERANCE_DOWN_1);
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_UP_2);
            template.setFlowerProvider(ForestryAlleles.FLOWERS_CACTI);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FIREY), Float.valueOf(0.25f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SUPERNATURAL, ETHEREAL, 14).requireResource(new IBlockState[]{Blocks.field_150353_l.func_176223_P()});
        }
    }
    ,
    WINDY("ventosum", EnumBeeBranches.MAGICAL, true, new Color(16776634)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_2);
            template.setSpeed(ForestryAlleles.SPEED_FASTER);
            template.setFloweringSpeed(ForestryAlleles.FLOWERING_FASTER);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.AIRY), Float.valueOf(0.25f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SUPERNATURAL, ETHEREAL, 14).requireResource("treeLeaves");
        }
    }
    ,
    PUPIL("disciplina", EnumBeeBranches.SCHOLARLY, true, new Color(0xFFFF00)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setSpeed(ForestryAlleles.SPEED_SLOWER);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.PAPERY), Float.valueOf(0.2f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Monastic"), ARCANE, 10);
        }
    }
    ,
    SCHOLARLY("studiosis", EnumBeeBranches.SCHOLARLY, false, new Color(0x6E0000)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setFertility(ForestryAlleles.FERTILITY_LOW);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.PAPERY), Float.valueOf(0.25f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(ARCANE, PUPIL, 8);
        }
    }
    ,
    SAVANT("philologus", EnumBeeBranches.SCHOLARLY, false, new Color(16752706)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setSpeed(ForestryAlleles.SPEED_NORMAL);
            template.setFertility(ForestryAlleles.FERTILITY_LOW);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.PAPERY), Float.valueOf(0.4f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(PUPIL, SCHOLARLY, 6);
        }
    }
    ,
    AWARE("sensibilis", EnumBeeBranches.SOUL, false, new Color(6198709)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.INTELLECT), Float.valueOf(0.18f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(ETHEREAL, ATTUNED, 10);
        }
    }
    ,
    SPIRIT("larva", EnumBeeBranches.SOUL, true, new Color(11703883)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setLifeSpan(ForestryAlleles.LIFESPAN_SHORTENED);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.INTELLECT), Float.valueOf(0.22f));
            speciesBuilder.addSpecialty(EnumBeeSpecies.getComb(EnumCombType.SOUL), Float.valueOf(0.16f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(ETHEREAL, AWARE, 8);
            this.registerMutation(ATTUNED, AWARE, 8);
        }
    }
    ,
    SOUL("anima", EnumBeeBranches.SOUL, false, new Color(8214811)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_DOWN_2);
            template.setLifeSpan(ForestryAlleles.LIFESPAN_NORMAL);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.INTELLECT), Float.valueOf(0.28f));
            speciesBuilder.addSpecialty(EnumBeeSpecies.getComb(EnumCombType.SOUL), Float.valueOf(0.2f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(AWARE, SPIRIT, 7);
        }
    }
    ,
    SKULKING("malevolens", EnumBeeBranches.SKULKING, true, new Color(5392423)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setIsSecret();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.1f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Modest"), ELDRITCH, 12);
        }
    }
    ,
    GHASTLY("pallens", (IMagicBeesBranch)EnumBeeBranches.SKULKING, false, new Color(0xCCCCEE), new Color(12552060)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
            template.setToleratesRain(ForestryAlleles.TRUE_RECESSIVE);
            template.setFertility(ForestryAlleles.FERTILITY_LOW);
            template.setEffect((IAlleleEffect)AlleleRegister.spawnGhast);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setIsSecret();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.08f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151073_bk), Float.valueOf(0.099f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(BATTY, ETHEREAL, 9);
        }
    }
    ,
    SPIDERY("araneolus", (IMagicBeesBranch)EnumBeeBranches.SKULKING, true, new Color(0x888888), new Color(0x222222)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
            template.setTerritory(ForestryAlleles.TERRITORY_LARGER);
            template.setEffect((IAlleleEffect)AlleleRegister.spawnSpider);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setIsSecret();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.13f));
            speciesBuilder.addProduct(new ItemStack(Items.field_151007_F), Float.valueOf(0.08f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151070_bp), Float.valueOf(0.08f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Tropical"), SKULKING, 10);
        }
    }
    ,
    SMOULDERING("flagrantia", (IMagicBeesBranch)EnumBeeBranches.SKULKING, false, new Color(16762695), new Color(15369028)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
            template.setEffect((IAlleleEffect)AlleleRegister.spawnBlaze);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HELLISH);
            speciesBuilder.setIsSecret();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MOLTEN), Float.valueOf(0.1f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151072_bj), Float.valueOf(0.05f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(GHASTLY, HATEFUL, 7).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    BRAINY("cerebrum", EnumBeeBranches.SKULKING, true, new Color(8650608)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setFertility(ForestryAlleles.FERTILITY_LOW);
            template.setEffect((IAlleleEffect)AlleleRegister.spawnZombie);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setIsSecret();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.1f));
            speciesBuilder.addProduct(new ItemStack(Items.field_151078_bh), Float.valueOf(0.06f));
        }

        @Override
        public void registerMutations() {
            int chance;
            EnumBeeSpecies second;
            if (EnumBeeBranches.THAUMIC.enabled()) {
                second = MUTABLE;
                chance = 9;
            } else {
                second = MUTABLE;
                chance = 14;
            }
            this.registerMutation(SKULKING, second, chance);
        }

        @Override
        public boolean isActive() {
            return false;
        }
    }
    ,
    BIGBAD("magnumalum", (IMagicBeesBranch)EnumBeeBranches.SKULKING, true, new Color(11088971), new Color(4535606)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
            template.setEffect((IAlleleEffect)AlleleRegister.spawnWolf);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setNocturnal();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.18f));
            speciesBuilder.addProduct(new ItemStack(Items.field_151082_bd), Float.valueOf(0.12f));
            speciesBuilder.addProduct(new ItemStack(Items.field_151076_bf), Float.valueOf(0.12f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SKULKING, MYSTERIOUS, 7).addMutationCondition((IMutationCondition)new MoonPhaseMutationRestriction(MoonPhase.FULL));
        }
    }
    ,
    CHICKEN("pullus", (IMagicBeesBranch)EnumBeeBranches.FLESHY, true, new Color(0xFF0000), new Color(0xD3D3D3)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setEffect((IAlleleEffect)AlleleRegister.spawnChicken);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.23f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151008_G), Float.valueOf(0.08f));
            speciesBuilder.addProduct(new ItemStack(Items.field_151110_aK), Float.valueOf(0.08f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Common"), SKULKING, 12).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        }
    }
    ,
    BEEF("bubulae", (IMagicBeesBranch)EnumBeeBranches.FLESHY, true, new Color(0xB7B7B7), new Color(4141092)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setEffect((IAlleleEffect)AlleleRegister.spawnCow);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.25f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151116_aA), Float.valueOf(0.865f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Common"), SKULKING, 12).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        }
    }
    ,
    PORK("porcina", (IMagicBeesBranch)EnumBeeBranches.FLESHY, true, new Color(15838892), new Color(14648443)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setEffect((IAlleleEffect)AlleleRegister.spawnPig);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.1f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151172_bF), Float.valueOf(0.865f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Common"), SKULKING, 12).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN});
        }
    }
    ,
    BATTY("chiroptera", (IMagicBeesBranch)EnumBeeBranches.FLESHY, true, new Color(5982251), new Color(2562831)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setTerritory(ForestryAlleles.TERRITORY_LARGE);
            template.setEffect((IAlleleEffect)AlleleRegister.spawnBats);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.1f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151007_F), Float.valueOf(1.0E-5f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SKULKING, WINDY, 9);
        }
    }
    ,
    SHEEPISH("balans", (IMagicBeesBranch)EnumBeeBranches.FLESHY, true, new Color(0xF7F7F7), new Color(0xCACACA)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_DOWN_2);
            template.setEffect((IAlleleEffect)AlleleRegister.spawnSheep);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.25f));
            speciesBuilder.addSpecialty(new ItemStack(Blocks.field_150325_L), Float.valueOf(0.16f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151015_O), Float.valueOf(0.24f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(PORK, SKULKING, 13).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        }
    }
    ,
    HORSE("equus", (IMagicBeesBranch)EnumBeeBranches.FLESHY, true, new Color(9462576), new Color(8080923)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setSpeed(ForestryAlleles.SPEED_FASTEST);
            template.setEffect((IAlleleEffect)AlleleRegister.spawnHorse);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.25f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151116_aA), Float.valueOf(0.24f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151034_e), Float.valueOf(0.38f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(BEEF, SHEEPISH, 12).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        }
    }
    ,
    CATTY("feline", (IMagicBeesBranch)EnumBeeBranches.FLESHY, true, new Color(15525508), new Color(5651492)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_3);
            template.setEffect((IAlleleEffect)AlleleRegister.spawnCat);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HOT);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.25f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151115_aP), Float.valueOf(0.24f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(CHICKEN, SPIDERY, 15).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE});
        }
    }
    ,
    TIMELY("gallifreis", EnumBeeBranches.TIME, true, new Color(13021062)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setLifeSpan(ForestryAlleles.LIFESPAN_ELONGATED);
            template.setEffect((IAlleleEffect)AlleleRegister.effectSlowSpeed);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TEMPORAL), Float.valueOf(0.16f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Imperial"), ETHEREAL, 8);
        }
    }
    ,
    LORDLY("rassilonis", (IMagicBeesBranch)EnumBeeBranches.TIME, false, new Color(13021062), new Color(9306643)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setLifeSpan(ForestryAlleles.LIFESPAN_LONG);
            template.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
            template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectDrunkard"));
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TEMPORAL), Float.valueOf(0.19f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Imperial"), TIMELY, 8);
        }
    }
    ,
    DOCTORAL("medicus qui", (IMagicBeesBranch)EnumBeeBranches.TIME, false, new Color(14542332), new Color(4943500)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_3);
            template.setTerritory(ForestryAlleles.TERRITORY_LARGE);
            template.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
            template.setLifeSpan(ForestryAlleles.LIFESPAN_LONGEST);
            template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectHeroic"));
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TEMPORAL), Float.valueOf(0.24f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(TIMELY, LORDLY, 7);
        }
    }
    ,
    INFERNAL("infernales", EnumBeeBranches.ABOMINABLE, true, new Color(0xFF1C1C)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setSpeed(ForestryAlleles.SPEED_SLOW);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MOLTEN), Float.valueOf(0.12f));
        }

        @Override
        public void registerMutations() {
        }
    }
    ,
    HATEFUL("odibilis", EnumBeeBranches.ABOMINABLE, false, new Color(0xDB00DB)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setSpeed(ForestryAlleles.SPEED_SLOW);
            template.setLifeSpan(ForestryAlleles.LIFESPAN_ELONGATED);
            template.setTerritory(ForestryAlleles.TERRITORY_LARGER);
            template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectMisanthrope"));
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MOLTEN), Float.valueOf(0.18f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(INFERNAL, ELDRITCH, 9).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    SPITEFUL("maligna", EnumBeeBranches.ABOMINABLE, false, new Color(6278144)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setLifeSpan(ForestryAlleles.LIFESPAN_LONG);
            template.setSpeed(ForestryAlleles.SPEED_NORMAL);
            template.setTerritory(ForestryAlleles.TERRITORY_LARGER);
            template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectMisanthrope"));
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MOLTEN), Float.valueOf(0.23f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(INFERNAL, HATEFUL, 7).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    WITHERING("vietus", EnumBeeBranches.ABOMINABLE, false, new Color(0x5B5B5B)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setTerritory(ForestryAlleles.TERRITORY_LARGEST);
            template.setFertility(ForestryAlleles.FERTILITY_LOW);
            template.setEffect((IAlleleEffect)AlleleRegister.effectWithering);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.addSpecialty(ItemRegister.resourceItem.getStackFromType(EnumResourceType.SKULL_CHIP), Float.valueOf(0.15f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Demonic"), SPITEFUL, 6).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    OBLIVION("oblivioni", EnumBeeBranches.EXTRINSIC, false, new Color(14009317)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setFertility(ForestryAlleles.FERTILITY_MAXIMUM);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FORGOTTEN), Float.valueOf(0.14f));
        }

        @Override
        public void registerMutations() {
        }
    }
    ,
    NAMELESS("sine nomine", EnumBeeBranches.EXTRINSIC, true, new Color(9217995)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setFertility(ForestryAlleles.FERTILITY_HIGH);
            template.setHumidityTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FORGOTTEN), Float.valueOf(0.19f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(ETHEREAL, OBLIVION, 10);
        }
    }
    ,
    ABANDONED("reliquit", EnumBeeBranches.EXTRINSIC, true, new Color(12962700)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setHumidityTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
            template.setLifeSpan(ForestryAlleles.LIFESPAN_ELONGATED);
            template.setFertility(ForestryAlleles.FERTILITY_NORMAL);
            template.setSpeed(ForestryAlleles.SPEED_SLOW);
            template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectRepulsion"));
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FORGOTTEN), Float.valueOf(0.24f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(OBLIVION, NAMELESS, 8);
        }
    }
    ,
    FORLORN("perditus", EnumBeeBranches.EXTRINSIC, false, new Color(13346956)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setFertility(ForestryAlleles.FERTILITY_LOW);
            template.setHumidityTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
            template.setLifeSpan(ForestryAlleles.LIFESPAN_LONGEST);
            template.setSpeed(ForestryAlleles.SPEED_SLOW);
            template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectRepulsion"));
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FORGOTTEN), Float.valueOf(0.3f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(NAMELESS, ABANDONED, 6);
        }
    }
    ,
    DRACONIC("draconic", (IMagicBeesBranch)EnumBeeBranches.EXTRINSIC, false, new Color(10442413), new Color(5913442)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setFertility(ForestryAlleles.FERTILITY_LOW);
            template.setHumidityTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
            template.setLifeSpan(ForestryAlleles.LIFESPAN_LONGEST);
            template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectMisanthrope"));
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.addProduct(ItemRegister.resourceItem.getStackFromType(EnumResourceType.DRAGON_DUST), Float.valueOf(0.15f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Imperial"), ABANDONED, 6).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.END});
        }
    }
    ,
    MUTABLE("mutable", (IMagicBeesBranch)EnumBeeBranches.TRANSMUTING, false, new Color(14398028), new Color(14734758)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.PARCHED), Float.valueOf(0.3f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TRANSMUTED), Float.valueOf(0.1f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(UNUSUAL, ELDRITCH, 12);
        }
    }
    ,
    TRANSMUTING("effectTransmuting", (IMagicBeesBranch)EnumBeeBranches.TRANSMUTING, false, new Color(14398028), new Color(10670808)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setEffect((IAlleleEffect)AlleleRegister.effectTransmuting);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.PARCHED), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TRANSMUTED), Float.valueOf(0.3f));
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.SILKY), Float.valueOf(0.05f));
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.SIMMERING), Float.valueOf(0.05f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(UNUSUAL, MUTABLE, 9);
        }
    }
    ,
    CRUMBLING("crumbling", (IMagicBeesBranch)EnumBeeBranches.TRANSMUTING, false, new Color(14398028), new Color(14394532)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setEffect((IAlleleEffect)AlleleRegister.effectCrumbling);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HOT);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.PARCHED), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TRANSMUTED), Float.valueOf(0.3f));
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.POWDERY), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.COCOA), Float.valueOf(0.15f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(UNUSUAL, MUTABLE, 9);
        }
    }
    ,
    INVISIBLE("invisible", (IMagicBeesBranch)EnumBeeBranches.VEILED, false, new Color(0xFFCCFF), new Color(0xFFCCFF)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setLifeSpan(ForestryAlleles.LIFESPAN_SHORTEST);
            template.setHumidityTolerance(ForestryAlleles.TOLERANCE_UP_1);
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_DOWN_2);
            template.setEffect((IAlleleEffect)AlleleRegister.alleleInvisibility);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MUNDANE), Float.valueOf(0.35f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(MYSTICAL, MUTABLE, 15);
        }
    }
    ,
    IRON("ferrus", (IMagicBeesBranch)EnumBeeBranches.METALLIC, true, new Color(0x686868), new Color(0xE9E9E9)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.IRON, speciesBuilder, 0.18f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Common"), EnumBeeSpecies.getForestrySpecies("Industrious"), 12).requireResource(new IBlockState[]{Blocks.field_150339_S.func_176223_P()});
        }
    }
    ,
    GOLD("aurum", (IMagicBeesBranch)EnumBeeBranches.METALLIC, false, new Color(6834945), new Color(0xFFFF0B)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            this.addOreProduct(EnumOreResourceType.GOLD, speciesBuilder, 0.16f);
        }

        @Override
        public void registerMutations() {
            EnumBeeSpecies bee1 = LEAD.isActive() ? LEAD : IRON;
            IAlleleBeeSpecies bee2 = EnumBeeSpecies.getForestrySpecies("Imperial");
            this.registerMutation(bee2, bee1, 8).requireResource(new IBlockState[]{Blocks.field_150340_R.func_176223_P()});
        }
    }
    ,
    COPPER("aercus", (IMagicBeesBranch)EnumBeeBranches.METALLIC, true, new Color(6834945), new Color(16762906)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.COPPER, speciesBuilder, 0.2f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Industrious"), EnumBeeSpecies.getForestrySpecies("Meadows"), 12).requireResource("blockCopper");
        }
    }
    ,
    TIN("stannum", (IMagicBeesBranch)EnumBeeBranches.METALLIC, true, new Color(4086125), new Color(10926795)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.TIN, speciesBuilder, 0.2f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Industrious"), EnumBeeSpecies.getForestrySpecies("Forest"), 12).requireResource("blockTin");
        }
    }
    ,
    SILVER("argenteus", (IMagicBeesBranch)EnumBeeBranches.METALLIC, false, new Color(7634049), new Color(9879492)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.SILVER, speciesBuilder, 0.16f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Imperial"), EnumBeeSpecies.getForestrySpecies("Modest"), 8).requireResource("blockSilver");
        }
    }
    ,
    LEAD("plumbeus", (IMagicBeesBranch)EnumBeeBranches.METALLIC, true, new Color(9879492), new Color(9546227)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.LEAD, speciesBuilder, 0.17f);
        }

        @Override
        public void registerMutations() {
            EnumBeeSpecies bee2 = TIN.isActive() ? TIN : (COPPER.isActive() ? COPPER : IRON);
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Common"), bee2, 10).requireResource("blockLead");
        }
    }
    ,
    ALUMINIUM("aluminium", (IMagicBeesBranch)EnumBeeBranches.METALLIC, true, new Color(0xEDEDED), new Color(0x767676)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.ALUMINIUM, speciesBuilder, 0.2f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Industrious"), EnumBeeSpecies.getForestrySpecies("Cultivated"), 10).requireResource("blockAluminium");
        }
    }
    ,
    ARDITE("aurantiaco", (IMagicBeesBranch)EnumBeeBranches.METALLIC, false, new Color(0x720000), new Color(16752128)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HOT);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            this.addOreProduct(EnumOreResourceType.ARDITE, speciesBuilder, 0.18f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Industrious"), INFERNAL, 9).requireResource("blockArdite");
        }
    }
    ,
    COBALT("caeruleo", (IMagicBeesBranch)EnumBeeBranches.METALLIC, false, new Color(206431), new Color(5876463)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HOT);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            this.addOreProduct(EnumOreResourceType.COBALT, speciesBuilder, 0.18f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Imperial"), INFERNAL, 11).requireResource("blockCobalt");
        }
    }
    ,
    MANYULLYN("manahmanah", (IMagicBeesBranch)EnumBeeBranches.METALLIC, false, new Color(4726125), new Color(12423921)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HOT);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            speciesBuilder.setHasEffect();
            this.addOreProduct(EnumOreResourceType.MANYULLYN, speciesBuilder, 0.16f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(ARDITE, COBALT, 9).requireResource("blockManyullyn");
        }
    }
    ,
    OSMIUM("hyacintho", (IMagicBeesBranch)EnumBeeBranches.METALLIC, false, new Color(3623771), new Color(7109513)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setLifeSpan(ForestryAlleles.LIFESPAN_LONGER);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.OSMIUM, speciesBuilder, 0.16f);
        }

        @Override
        public void registerMutations() {
            IAlleleBeeSpecies bee1 = SILVER.isActive() ? SILVER.getSpecies() : EnumBeeSpecies.getForestrySpecies("Imperial");
            EnumBeeSpecies bee2 = COBALT.isActive() ? COBALT : INFERNAL;
            this.registerMutation(bee1, bee2, 11).requireResource("blockOsmium");
        }
    }
    ,
    ELECTRUM("electrum", EnumBeeBranches.METALLIC, false, new Color(962425)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HOT);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            this.addOreProduct(EnumOreResourceType.ELECTRUM, speciesBuilder, 0.18f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SILVER, GOLD, 10).requireResource("blockElectrum");
        }
    }
    ,
    PLATINUM("platinum", EnumBeeBranches.METALLIC, false, new Color(10414071)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BeeIntegrationInterface.getTemplateTENether(template);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.PLATINUM, speciesBuilder, 0.18f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(NICKEL, INVAR, 10).requireResource("blockPlatinum");
        }
    }
    ,
    NICKEL("nickel", EnumBeeBranches.METALLIC, false, new Color(11848073)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.NICKEL, speciesBuilder, 0.18f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(IRON, ESOTERIC, 14).requireResource("blockNickel");
        }
    }
    ,
    INVAR("invar", EnumBeeBranches.METALLIC, false, new Color(13493153)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BeeIntegrationInterface.getTemplateTENether(template);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HOT);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            this.addOreProduct(EnumOreResourceType.INVAR, speciesBuilder, 0.18f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(IRON, NICKEL, 14).requireResource("blockInvar");
        }
    }
    ,
    BRONZE("bronze", EnumBeeBranches.METALLIC, false, new Color(11889927)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.BRONZE, speciesBuilder, 0.18f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(TIN, COPPER, 12).requireResource("blockBronze");
        }
    }
    ,
    DIAMOND("diamond", (IMagicBeesBranch)EnumBeeBranches.GEM, false, new Color(2135425), new Color(9303523)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.DIAMOND, speciesBuilder, 0.06f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Austere"), GOLD, 7).requireResource("blockDiamond");
        }
    }
    ,
    EMERALD("prasinus", (IMagicBeesBranch)EnumBeeBranches.GEM, false, new Color(21248), new Color(1564002)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.EMERALD, speciesBuilder, 0.04f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Austere"), SILVER.isActive() ? SILVER.getSpecies() : EnumBeeSpecies.getForestrySpecies("Imperial"), 6).requireResource("blockEmerald");
        }
    }
    ,
    APATITE("apatite", (IMagicBeesBranch)EnumBeeBranches.GEM, false, new Color(3057644), new Color(7505)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setSpeed(ForestryAlleles.SPEED_NORMAL);
            template.setLifeSpan(ForestryAlleles.LIFESPAN_NORMAL);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.APATITE, speciesBuilder, 0.1f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Rural"), COPPER, 12).requireResource("oreApatite");
        }
    }
    ,
    SILICON("siliconisque", (IMagicBeesBranch)EnumBeeBranches.GEM, false, new Color(11379367), new Color(7562869)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setSpeed(ForestryAlleles.SPEED_SLOW);
            template.setTerritory(ForestryAlleles.TERRITORY_LARGER);
            template.setToleratesRain(ForestryAlleles.TRUE_RECESSIVE);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.SILICON, speciesBuilder, 0.16f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(AE_SKYSTONE.isActive() ? AE_SKYSTONE : EARTHY, IRON, 17);
        }
    }
    ,
    CERTUS("alia cristallum", (IMagicBeesBranch)EnumBeeBranches.GEM, true, new Color(9684991), new Color(10926279)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setSpeed(ForestryAlleles.SPEED_SLOWER);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.CERTUS, speciesBuilder, 0.08f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SILICON.isActive() ? SILICON : IRON, AE_SKYSTONE.isActive() ? AE_SKYSTONE : EARTHY, 17);
        }
    }
    ,
    FLUIX("alia cristallum", (IMagicBeesBranch)EnumBeeBranches.GEM, true, new Color(16540574), new Color(5457815)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setSpeed(ForestryAlleles.SPEED_SLOWEST);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            this.addOreProduct(EnumOreResourceType.FLUIX, speciesBuilder, 0.06f);
        }

        @Override
        public void registerMutations() {
            EnumBeeSpecies beeA = CERTUS.isActive() ? CERTUS : (SILICON.isActive() ? SILICON : IRON);
            EnumBeeSpecies beeB = AE_SKYSTONE.isActive() ? AE_SKYSTONE : EARTHY;
            this.registerMutation(beeA, beeB, 17);
        }
    }
    ,
    TE_BLIZZY("blizzard", (IMagicBeesBranch)EnumBeeBranches.ABOMINABLE, false, new Color(29636), new Color(16743462)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BeeIntegrationInterface.getTemplateTEEnd(template);
            template.setFlowerProvider(ForestryAlleles.FLOWERS_SNOW);
            template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectGlacial"));
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.COLD);
            speciesBuilder.setHumidity(EnumHumidity.NORMAL);
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.FROZEN), Float.valueOf(0.1f));
            this.addRequiredOreDictSpeciality("dustBlizz", speciesBuilder, 0.09f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Wintry"), SKULKING, 12);
        }

        @Override
        public boolean isActive() {
            return super.isActive() && Loader.isModLoaded((String)"thermalfoundation");
        }
    }
    ,
    TE_GELID("cyro", (IMagicBeesBranch)EnumBeeBranches.ABOMINABLE, true, new Color(4894711), new Color(16743462)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            TE_BLIZZY.modifyGenomeTemplate(template);
            template.setEffect(BeeIntegrationInterface.effectSpawnBlizz);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.setTemperature(EnumTemperature.COLD);
            speciesBuilder.setHumidity(EnumHumidity.NORMAL);
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.FROZEN), Float.valueOf(0.1f));
            this.addRequiredOreDictSpeciality("dustCryotheum", speciesBuilder, 0.09f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Icy"), TE_BLIZZY, 8);
        }

        @Override
        public boolean isActive() {
            return super.isActive() && Loader.isModLoaded((String)"thermalfoundation");
        }
    }
    ,
    TE_DANTE("inferno", (IMagicBeesBranch)EnumBeeBranches.ABOMINABLE, false, new Color(16231498), new Color(16743462)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BeeIntegrationInterface.getTemplateTENether(template);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HELLISH);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MOLTEN), Float.valueOf(0.1f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151065_br), Float.valueOf(0.05f));
            this.addRequiredOreDictSpeciality("dustSulfur", speciesBuilder, 0.09f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Austere"), SMOULDERING, 12).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }

        @Override
        public boolean isActive() {
            return super.isActive() && Loader.isModLoaded((String)"thermalfoundation");
        }
    }
    ,
    TE_PYRO("pyromania", (IMagicBeesBranch)EnumBeeBranches.ABOMINABLE, true, new Color(16421644), new Color(16743462)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BeeIntegrationInterface.getTemplateTEEnd(template);
            template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectIgnition"));
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.setTemperature(EnumTemperature.HELLISH);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MOLTEN), Float.valueOf(0.1f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151065_br), Float.valueOf(0.05f));
            this.addRequiredOreDictSpeciality("dustPyrotheum", speciesBuilder, 0.09f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(TE_DANTE, TE_COAL, 8).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }

        @Override
        public boolean isActive() {
            return super.isActive() && Loader.isModLoaded((String)"thermalfoundation");
        }
    }
    ,
    TE_SHOCKING("horrendum", (IMagicBeesBranch)EnumBeeBranches.ABOMINABLE, false, new Color(12975910), new Color(16313856)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BeeIntegrationInterface.getTemplateTEEnd(template);
            template.setSpeed(ForestryAlleles.SPEED_FAST);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.NORMAL);
            speciesBuilder.setHumidity(EnumHumidity.NORMAL);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.AIRY), Float.valueOf(0.16f));
            this.addRequiredOreDictSpeciality("dustBlitz", speciesBuilder, 0.09f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SMOULDERING, WINDY, 12);
        }

        @Override
        public boolean isActive() {
            return super.isActive() && Loader.isModLoaded((String)"thermalfoundation");
        }
    }
    ,
    TE_AMPED("concitatus", (IMagicBeesBranch)EnumBeeBranches.ABOMINABLE, false, new Color(0x8AFFFF), new Color(15525488)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            TE_SHOCKING.modifyGenomeTemplate(template);
            template.setEffect(BeeIntegrationInterface.effectSpawnBlitz);
            template.setSpeed(AlleleRegister.speedBlinding);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.setTemperature(EnumTemperature.NORMAL);
            speciesBuilder.setHumidity(EnumHumidity.NORMAL);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.AIRY), Float.valueOf(0.29f));
            this.addRequiredOreDictSpeciality("dustAerotheum", speciesBuilder, 0.09f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(TE_SHOCKING, WINDY, 8);
        }

        @Override
        public boolean isActive() {
            return super.isActive() && Loader.isModLoaded((String)"thermalfoundation");
        }
    }
    ,
    TE_GROUNDED("tellus", (IMagicBeesBranch)EnumBeeBranches.ABOMINABLE, true, new Color(0xCEC1C1), new Color(8546151)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BeeIntegrationInterface.getTemplateTEEnd(template);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HOT);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.EARTHY), Float.valueOf(0.16f));
            this.addRequiredOreDictSpeciality("dustBasalz", speciesBuilder, 0.09f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SMOULDERING, EARTHY, 12);
        }

        @Override
        public boolean isActive() {
            return super.isActive() && Loader.isModLoaded((String)"thermalfoundation");
        }
    }
    ,
    TE_ROCKING("saxsous", (IMagicBeesBranch)EnumBeeBranches.ABOMINABLE, true, new Color(0x980000), new Color(11247003)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            TE_GROUNDED.modifyGenomeTemplate(template);
            template.setSpeed(ForestryAlleles.SPEED_FASTER);
            template.setEffect(BeeIntegrationInterface.effectSpawnBasalz);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.setTemperature(EnumTemperature.HOT);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.EARTHY), Float.valueOf(0.29f));
            this.addRequiredOreDictSpeciality("dustPetrotheum", speciesBuilder, 0.09f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(TE_GROUNDED, EARTHY, 9);
        }

        @Override
        public boolean isActive() {
            return super.isActive() && Loader.isModLoaded((String)"thermalfoundation");
        }
    }
    ,
    TE_COAL("carbonis", EnumBeeBranches.THERMAL, false, new Color(0x2E2D2D)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.HONEY), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TE_CARBON), Float.valueOf(0.05f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151044_h), Float.valueOf(0.05f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SPITEFUL, TIN, 12).requireResource(new IBlockState[]{Blocks.field_150365_q.func_176223_P()});
        }
    }
    ,
    TE_DESTABILIZED("electric", EnumBeeBranches.THERMAL, false, new Color(6160899)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.OCCULT), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TE_DESTABILIZED), Float.valueOf(0.1f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151137_ax), Float.valueOf(0.05f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Industrious"), SPITEFUL, 12).requireResource(new IBlockState[]{Blocks.field_150450_ax.func_176223_P()});
        }
    }
    ,
    TE_LUX("lux", EnumBeeBranches.THERMAL, false, new Color(15858313)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BeeIntegrationInterface.getTemplateTENether(template);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.OCCULT), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TE_LUX), Float.valueOf(0.1f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151114_aO), Float.valueOf(0.05f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(SMOULDERING, INFERNAL, 12).requireResource(new IBlockState[]{Blocks.field_150426_aN.func_176223_P()});
        }
    }
    ,
    TE_WINSOME("cuniculus", EnumBeeBranches.THERMAL, false, new Color(617319)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.FURTIVE), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TE_ENDEARING), Float.valueOf(0.1f));
            this.addRequiredOreDictSpeciality("dustPlatinum", speciesBuilder, 0.09f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(PLATINUM, OBLIVION, 12);
        }
    }
    ,
    TE_ENDEARING("cognito", EnumBeeBranches.THERMAL, true, new Color(433815)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BeeIntegrationInterface.getTemplateTEEnd(template);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setHasEffect();
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.MYSTERIOUS), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TE_ENDEARING), Float.valueOf(0.05f));
            speciesBuilder.addSpecialty(new ItemStack(Items.field_151079_bi), Float.valueOf(0.05f));
            this.addRequiredOreDictSpeciality("nuggetEnderium", speciesBuilder, 0.09f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(TE_WINSOME, TE_COAL, 8).requireResource("blockEnderium");
        }
    }
    ,
    RSA_FLUXED("Thermametallic electroflux", EnumBeeBranches.THERMAL, false, new Color(10356237)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BeeIntegrationInterface.getTemplateTENether(template);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.HONEY), Float.valueOf(0.1f));
            speciesBuilder.addSpecialty(BeeIntegrationInterface.itemRSAFluxedElectrumNugget.func_77946_l(), Float.valueOf(0.09f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(ELECTRUM, TE_DESTABILIZED, 10).requireResource("blockElectrumFlux");
        }

        @Override
        public boolean isActive() {
            return Loader.isModLoaded((String)"redstonearsenal");
        }
    }
    ,
    BOT_ROOTED("truncus", EnumBeeBranches.BOTANICAL, true, new Color(43008)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            Utils.setSecret((IAlleleSpeciesBuilder)speciesBuilder);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MUNDANE), Float.valueOf(0.1f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EnumBeeSpecies.getForestrySpecies("Forest"), ELDRITCH, 15).requireResource(new IBlockState[]{BeeIntegrationInterface.livingWood});
        }
    }
    ,
    BOT_BOTANIC("botanica", EnumBeeBranches.BOTANICAL, true, new Color(9750113)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setFlowerProvider(BeeIntegrationInterface.flowersBotania);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            Utils.setSecret((IAlleleSpeciesBuilder)speciesBuilder);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MUNDANE), Float.valueOf(0.1f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TRANSMUTED), Float.valueOf(0.05f));
            BeeIntegrationInterface.addPetals(speciesBuilder, 0.01f);
        }

        @Override
        public void registerMutations() {
        }
    }
    ,
    BOT_BLOSSOM("viridis", EnumBeeBranches.BOTANICAL, false, new Color(10797459)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BOT_BOTANIC.modifyGenomeTemplate(template);
            template.setFertility(ForestryAlleles.FERTILITY_MAXIMUM);
            template.setFloweringSpeed(ForestryAlleles.FLOWERING_FASTER);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            Utils.setSecret((IAlleleSpeciesBuilder)speciesBuilder);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MUNDANE), Float.valueOf(0.2f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TRANSMUTED), Float.valueOf(0.05f));
            BeeIntegrationInterface.addPetals(speciesBuilder, 0.04f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(BOT_BOTANIC, EARTHY, 12);
        }
    }
    ,
    BOT_FLORAL("florens", EnumBeeBranches.BOTANICAL, true, new Color(2742298)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BOT_BLOSSOM.modifyGenomeTemplate(template);
            template.setFertility(ForestryAlleles.FERTILITY_HIGH);
            template.setFloweringSpeed(ForestryAlleles.FLOWERING_MAXIMUM);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            Utils.setSecret((IAlleleSpeciesBuilder)speciesBuilder);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.MUNDANE), Float.valueOf(0.25f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TRANSMUTED), Float.valueOf(0.05f));
            BeeIntegrationInterface.addPetals(speciesBuilder, 0.16f);
        }

        @Override
        public void registerMutations() {
            this.registerMutation(BOT_BOTANIC, BOT_BLOSSOM, 8);
        }
    }
    ,
    BOT_VAZBEE("vazbii", EnumBeeBranches.BOTANICAL, false, new Color(16739228)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BOT_FLORAL.modifyGenomeTemplate(template);
            template.setFertility(ForestryAlleles.FERTILITY_LOW);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            Utils.setSecret((IAlleleSpeciesBuilder)speciesBuilder);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.SOUL), Float.valueOf(0.05f));
            speciesBuilder.addProduct(new ItemStack(Items.field_151100_aR, 1, 9), Float.valueOf(0.2f));
            speciesBuilder.addProduct(new ItemStack(Blocks.field_150325_L, 1, 9), Float.valueOf(0.02f));
            speciesBuilder.addProduct(new ItemStack((Block)Blocks.field_150328_O), Float.valueOf(0.06f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.TRANSMUTED), Float.valueOf(0.15f));
            if (BeeIntegrationInterface.itemPastureSeed == null) {
                return;
            }
            for (int i = 0; i < BeeIntegrationInterface.seedTypes; ++i) {
                speciesBuilder.addSpecialty(new ItemStack(BeeIntegrationInterface.itemPastureSeed, 1, i), Float.valueOf(0.04f));
            }
        }

        @Override
        public void registerMutations() {
        }
    }
    ,
    BOT_SOMNOLENT("soporatus", EnumBeeBranches.BOTANICAL, true, new Color(2717894)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setFlowerProvider(BeeIntegrationInterface.flowersBotania);
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_UP_2);
            template.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
            template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
            template.setSpeed(ForestryAlleles.SPEED_SLOWEST);
            template.setEffect((IAlleleEffect)AlleleRegister.effectSlowSpeed);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setNocturnal();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.WATERY), Float.valueOf(0.08f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.SOUL), Float.valueOf(0.15f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(BOT_ROOTED, WATERY, 16).requireNight();
        }
    }
    ,
    BOT_DREAMING("somnior", EnumBeeBranches.BOTANICAL, true, new Color(1193046)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BOT_SOMNOLENT.modifyGenomeTemplate(template);
            template.setSpeed(ForestryAlleles.SPEED_NORMAL);
            template.setTerritory(ForestryAlleles.TERRITORY_LARGER);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setNocturnal();
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.WATERY), Float.valueOf(0.16f));
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.SOUL), Float.valueOf(0.33f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(WINDY, BOT_SOMNOLENT, 8).requireNight();
        }
    }
    ,
    BOT_ALFHEIM("alfheimis", (IMagicBeesBranch)EnumBeeBranches.BOTANICAL, false, new Color(-1), new Color(-1)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            BOT_DREAMING.modifyGenomeTemplate(template);
            template.setEffect(BeeIntegrationInterface.effectDreaming);
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            Utils.setSecret((IAlleleSpeciesBuilder)speciesBuilder);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.OTHERWORLDLY), Float.valueOf(0.28f));
        }

        @Override
        public void registerMutations() {
        }
    }
    ,
    AE_SKYSTONE("terra astris", (IMagicBeesBranch)EnumBeeBranches.TRANSMUTING, true, new Color(4948865), new Color(0x252929)){

        @Override
        public void modifyGenomeTemplate(BeeGenomeTemplate template) {
            template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
            template.setFertility(ForestryAlleles.FERTILITY_LOW);
            template.setLifeSpan(ForestryAlleles.LIFESPAN_SHORTER);
            template.setHumidityTolerance(ForestryAlleles.TOLERANCE_NONE);
            template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_NONE);
            template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectIgnition"));
        }

        @Override
        public void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesBuilder) {
            speciesBuilder.setTemperature(EnumTemperature.HOT);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
            speciesBuilder.addProduct(EnumBeeSpecies.getComb(EnumCombType.EARTHY), Float.valueOf(0.19f));
            speciesBuilder.addSpecialty(new ItemStack(BeeIntegrationInterface.aeSkyStone.func_177230_c()), Float.valueOf(0.02f));
        }

        @Override
        public void registerMutations() {
            this.registerMutation(EARTHY, WINDY, 20).requireResource(new IBlockState[]{BeeIntegrationInterface.aeSkyStone});
        }

        @Override
        public boolean isActive() {
            return super.isActive() && Loader.isModLoaded((String)"appliedenergistics2");
        }
    };

    private final IMagicBeesBranch branch;
    private final int primaryColor;
    private final int secondaryColor;
    private final String binominalName;
    private final String uid;
    private final String unlocalisedName;
    private final boolean dominant;
    private boolean enabledOverride;
    private IIndividualDefinition<IBeeGenome, IBee, EnumBeeType> individual;

    private EnumBeeSpecies(String binominalName, IMagicBeesBranch branch, boolean dominant, Color primaryColor) {
        this(binominalName, branch, dominant, primaryColor, branch.getSecondaryColor());
    }

    private EnumBeeSpecies(String binomialName, IMagicBeesBranch branch, boolean dominant, Color primaryColor, Color secondaryColor) {
        String nme;
        this.branch = branch;
        this.primaryColor = primaryColor.getRGB();
        this.secondaryColor = secondaryColor.getRGB();
        this.binominalName = binomialName;
        this.dominant = dominant;
        String[] spl = this.name().split("_");
        if (spl.length == 1) {
            nme = WordUtils.capitalize((String)spl[0].toLowerCase(Locale.ENGLISH));
        } else if (spl.length == 2) {
            nme = spl[0] + WordUtils.capitalize((String)spl[1].toLowerCase(Locale.ENGLISH));
        } else {
            throw new RuntimeException();
        }
        this.unlocalisedName = this.uid = "magicbees.species" + nme;
        this.enabledOverride = true;
    }

    @Override
    public int getPrimaryColor() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    @Override
    @Nonnull
    public String getUid() {
        return this.uid;
    }

    @Override
    public boolean isDominant() {
        return this.dominant;
    }

    @Override
    @Nonnull
    public String getUnlocalizedName() {
        return this.unlocalisedName;
    }

    @Override
    @Nonnull
    public String getBinominalName() {
        return this.binominalName;
    }

    @Override
    @Nonnull
    public IIndividualBranch<BeeGenomeTemplate> getIndividualBranch() {
        return this.branch;
    }

    @Override
    public abstract void modifyGenomeTemplate(BeeGenomeTemplate var1);

    @Override
    public abstract void setSpeciesProperties(IAlleleBeeSpeciesBuilder var1);

    @Override
    public abstract void registerMutations();

    private static ItemStack getComb(EnumCombType combType) {
        return ItemRegister.combItem.getStackFromType(combType);
    }

    private static ItemStack getDrop(EnumDropType drop) {
        return ItemRegister.dropItem.getStackFromType(drop);
    }

    private static ItemStack getPollen(EnumPollenType pollen) {
        return ItemRegister.pollenItem.getStackFromType(pollen);
    }

    private static ItemStack getForestryComb(EnumHoneyComb type) {
        return new ItemStack((Item)Utils.getApicultureItems().beeComb, 1, type.ordinal());
    }

    protected final void addRequiredOreDictSpeciality(String resource, IAlleleBeeSpeciesBuilder speciesBuilder, float speciality) {
        NonNullList l = OreDictionary.getOres((String)resource);
        for (ItemStack stack : l) {
            if (stack.func_190926_b()) continue;
            speciesBuilder.addSpecialty(stack, Float.valueOf(speciality));
            return;
        }
        this.enabledOverride = false;
    }

    protected final void addOreProduct(EnumOreResourceType resource, IAlleleBeeSpeciesBuilder speciesBuilder, float speciality) {
        speciesBuilder.addProduct(EnumBeeSpecies.getForestryComb(EnumHoneyComb.HONEY), Float.valueOf(0.1f));
        this.enabledOverride = resource.enabled();
        if (this.enabledOverride) {
            speciesBuilder.addSpecialty(resource.getStack(), Float.valueOf(speciality));
        }
    }

    protected final IBeeMutationBuilder registerMutation(EnumBeeSpecies bee1, EnumBeeSpecies bee2, int chance) {
        if (!bee1.isActive()) {
            MagicBees.logger.info("Species " + bee1 + " is not active, not registering mutation for bee: " + this);
        }
        return this.registerMutation(bee1.getSpecies(), bee2, chance);
    }

    protected final IBeeMutationBuilder registerMutation(IAlleleBeeSpecies bee1, EnumBeeSpecies bee2, int chance) {
        if (!bee2.isActive()) {
            MagicBees.logger.info("Species " + bee2 + " is not active, not registering mutation for bee: " + this);
        }
        return this.registerMutation(bee1, bee2.getSpecies(), chance);
    }

    protected final IBeeMutationBuilder registerMutation(IAlleleBeeSpecies bee1, IAlleleBeeSpecies bee2, int chance) {
        Preconditions.checkNotNull((Object)bee1);
        Preconditions.checkNotNull((Object)bee2);
        return BeeManager.beeMutationFactory.createMutation(bee1, bee2, this.individual.getAlleles(), chance);
    }

    public IAlleleBeeSpecies getSpecies() {
        return (IAlleleBeeSpecies)this.individual.getAlleles()[EnumBeeChromosome.SPECIES.ordinal()];
    }

    @Override
    public boolean isActive() {
        return this.branch.enabled() && this.enabledOverride;
    }

    @Override
    public void setIndividualDefinition(IIndividualDefinition<IBeeGenome, IBee, EnumBeeType> iIndividualDefinition) {
        this.individual = iIndividualDefinition;
    }

    @Override
    public IIndividualDefinition<IBeeGenome, IBee, EnumBeeType> getIndividualDefinition() {
        return this.individual;
    }

    protected void registerMundaneMutations() {
        String[] forestryMundane;
        for (String s : forestryMundane = new String[]{"Forest", "Meadows", "Modest", "Wintry", "Tropical", "Marshy"}) {
            BeeManager.beeMutationFactory.createMutation(this.getSpecies(), EnumBeeSpecies.getForestrySpecies(s), EnumBeeSpecies.getForestrySpeciesTemplate("Common"), 15);
        }
        BeeManager.beeMutationFactory.createMutation(this.getSpecies(), EnumBeeSpecies.getForestrySpecies("Common"), EnumBeeSpecies.getForestrySpeciesTemplate("Cultivated"), 12);
        BeeManager.beeMutationFactory.createMutation(this.getSpecies(), EnumBeeSpecies.getForestrySpecies("Cultivated"), ELDRITCH.getAlleles(), 12);
    }

    protected static IAllele[] getForestrySpeciesTemplate(String speciesName) {
        return BeeManager.beeRoot.getTemplate("forestry.species" + speciesName);
    }

    public static IAlleleBeeSpecies getForestrySpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + name);
    }

    public static IAllele getForestryAllele(String name) {
        return AlleleManager.alleleRegistry.getAllele("forestry." + name);
    }
}

