/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.api.client.render;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.render.RenderUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IWidgetMap {
    public int getSize();

    @Nonnull
    public ResourceLocation getTexture();

    @SideOnly(value=Side.CLIENT)
    public void render(@Nonnull IWidgetIcon var1, double var2, double var4);

    @SideOnly(value=Side.CLIENT)
    public void render(@Nonnull IWidgetIcon var1, double var2, double var4, boolean var6);

    @SideOnly(value=Side.CLIENT)
    public void render(@Nonnull IWidgetIcon var1, double var2, double var4, boolean var6, boolean var7);

    @SideOnly(value=Side.CLIENT)
    public void render(@Nonnull IWidgetIcon var1, double var2, double var4, double var6, boolean var8);

    @SideOnly(value=Side.CLIENT)
    public void render(@Nonnull IWidgetIcon var1, double var2, double var4, double var6, boolean var8, boolean var9);

    @SideOnly(value=Side.CLIENT)
    public void render(@Nonnull IWidgetIcon var1, double var2, double var4, double var6, double var8, double var10, boolean var12);

    @SideOnly(value=Side.CLIENT)
    public void render(@Nonnull IWidgetIcon var1, double var2, double var4, double var6, double var8, double var10, boolean var12, boolean var13);

    public static class WidgetMapImpl
    implements IWidgetMap {
        private final int size;
        @Nonnull
        private final ResourceLocation res;

        public WidgetMapImpl(int size, @Nonnull ResourceLocation res) {
            this.size = size;
            this.res = res;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        @Nonnull
        public ResourceLocation getTexture() {
            return this.res;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(@Nonnull IWidgetIcon widget, double x, double y) {
            this.render(widget, x, y, false);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(@Nonnull IWidgetIcon widget, double x, double y, boolean doDraw) {
            this.render(widget, x, y, widget.getWidth(), widget.getHeight(), 0.0, doDraw);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(@Nonnull IWidgetIcon widget, double x, double y, boolean doDraw, boolean flipY) {
            this.render(widget, x, y, widget.getWidth(), widget.getHeight(), 0.0, doDraw, flipY);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(@Nonnull IWidgetIcon widget, double x, double y, double zLevel, boolean doDraw) {
            this.render(widget, x, y, widget.getWidth(), widget.getHeight(), zLevel, doDraw);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(@Nonnull IWidgetIcon widget, double x, double y, double zLevel, boolean doDraw, boolean flipY) {
            this.render(widget, x, y, widget.getWidth(), widget.getHeight(), zLevel, doDraw, flipY);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(@Nonnull IWidgetIcon widget, double x, double y, double width, double height, double zLevel, boolean doDraw) {
            this.render(widget, x, y, width, height, zLevel, doDraw, false);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(@Nonnull IWidgetIcon widget, double x, double y, double width, double height, double zLevel, boolean doDraw, boolean flipY) {
            BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
            if (doDraw) {
                RenderUtil.bindTexture(this.getTexture());
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            }
            double minU = (double)widget.getX() / (double)this.getSize();
            double maxU = (double)(widget.getX() + widget.getWidth()) / (double)this.getSize();
            double minV = (double)widget.getY() / (double)this.getSize();
            double maxV = (double)(widget.getY() + widget.getHeight()) / (double)this.getSize();
            if (flipY) {
                tes.func_181662_b(x, y + height, zLevel).func_187315_a(minU, minV).func_181675_d();
                tes.func_181662_b(x + width, y + height, zLevel).func_187315_a(maxU, minV).func_181675_d();
                tes.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(maxU, maxV).func_181675_d();
                tes.func_181662_b(x, y + 0.0, zLevel).func_187315_a(minU, maxV).func_181675_d();
            } else {
                tes.func_181662_b(x, y + height, zLevel).func_187315_a(minU, maxV).func_181675_d();
                tes.func_181662_b(x + width, y + height, zLevel).func_187315_a(maxU, maxV).func_181675_d();
                tes.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(maxU, minV).func_181675_d();
                tes.func_181662_b(x, y + 0.0, zLevel).func_187315_a(minU, minV).func_181675_d();
            }
            IWidgetIcon overlay = widget.getOverlay();
            if (overlay != null) {
                overlay.getMap().render(overlay, x, y, width, height, zLevel, false, flipY);
            }
            if (doDraw) {
                Tessellator.func_178181_a().func_78381_a();
            }
        }
    }
}

