/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.item;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.colossalchests.Advancements;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.block.PropertyMaterial;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;

public class ItemUpgradeTool
extends ConfigurableItem {
    private static ItemUpgradeTool _instance = null;

    public static ItemUpgradeTool getInstance() {
        return _instance;
    }

    public ItemUpgradeTool(ExtendedConfig eConfig) {
        super(eConfig);
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + (itemStack.func_77960_j() == 0 ? "" : ".reverse");
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        IBlockState blockState = world.func_180495_p(pos);
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((IBlockState)blockState, (IProperty)ColossalChest.ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockPos tileLocation = ColossalChest.getCoreLocation(world, pos);
            TileColossalChest tile = (TileColossalChest)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)tileLocation, TileColossalChest.class));
            PropertyMaterial.Type newType = this.transformType(itemStack, tile.getMaterial());
            if (newType == null) {
                if (world.field_72995_K) {
                    return EnumActionResult.PASS;
                }
                ColossalChest.addPlayerChatError(player, new L10NHelpers.UnlocalizedString("multiblock.colossalchests.error.upgradeLimit", new Object[0]));
                return EnumActionResult.FAIL;
            }
            L10NHelpers.UnlocalizedString firstError = null;
            do {
                L10NHelpers.UnlocalizedString error;
                if ((error = this.attemptTransform(world, pos, player, tile, newType, tile.getMaterial())) != null) {
                    if (firstError != null) continue;
                    firstError = error;
                    continue;
                }
                return world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
            } while ((newType = this.transformType(itemStack, newType)) != null);
            ColossalChest.addPlayerChatError(player, firstError);
            return world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.FAIL;
        }
        return world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
    }

    protected L10NHelpers.UnlocalizedString attemptTransform(final World world, BlockPos pos, EntityPlayer player, final TileColossalChest tile, final PropertyMaterial.Type newType, PropertyMaterial.Type currentType) {
        int currentItemMeta = currentType.ordinal();
        int requiredItemMeta = newType.ordinal();
        Vec3i size = tile.getSize();
        final ItemStack requiredCores = new ItemStack((Block)ColossalChest.getInstance(), 0, requiredItemMeta);
        final ItemStack requiredInterfaces = new ItemStack((Block)Interface.getInstance(), 0, requiredItemMeta);
        final ItemStack requiredWalls = new ItemStack((Block)ChestWall.getInstance(), 0, requiredItemMeta);
        TileColossalChest.detector.detect(world, pos, null, new CubeDetector.IValidationAction(){

            public L10NHelpers.UnlocalizedString onValidate(BlockPos location, IBlockState blockState) {
                if (blockState.func_177230_c() == ColossalChest.getInstance()) {
                    requiredCores.func_190917_f(1);
                } else if (blockState.func_177230_c() == Interface.getInstance()) {
                    requiredInterfaces.func_190917_f(1);
                } else if (blockState.func_177230_c() == ChestWall.getInstance()) {
                    requiredWalls.func_190917_f(1);
                }
                return null;
            }
        }, false);
        if (!(this.consumeItems(player, requiredCores, true) && this.consumeItems(player, requiredInterfaces, true) && this.consumeItems(player, requiredWalls, true))) {
            return new L10NHelpers.UnlocalizedString("multiblock.colossalchests.error.upgrade", new Object[]{requiredCores.func_190916_E(), requiredInterfaces.func_190916_E(), requiredWalls.func_190916_E(), newType.getLocalizedName()});
        }
        this.consumeItems(player, requiredCores.func_77946_l(), false);
        this.consumeItems(player, requiredInterfaces.func_77946_l(), false);
        this.consumeItems(player, requiredWalls.func_77946_l(), false);
        if (!world.field_72995_K) {
            tile.setSize(Vec3i.field_177959_e);
            tile.setMaterial(newType);
            TileColossalChest.detector.detect(world, pos, null, new CubeDetector.IValidationAction(){

                public L10NHelpers.UnlocalizedString onValidate(BlockPos location, IBlockState blockState) {
                    world.func_180501_a(location, blockState.func_177226_a((IProperty)ColossalChest.MATERIAL, (Comparable)((Object)newType)), 2);
                    if (blockState.func_177230_c() == ColossalChest.getInstance() || blockState.func_177230_c() == Interface.getInstance()) {
                        tile.addInterface((Vec3i)location);
                    }
                    return null;
                }
            }, false);
            tile.setSize(size);
            Advancements.CHEST_FORMED.trigger((EntityPlayerMP)player, Pair.of((Object)((Object)newType), (Object)(size.func_177958_n() + 1)));
        }
        ItemStack returnedCores = requiredCores.func_77946_l();
        ItemStack returnedInterfaces = requiredInterfaces.func_77946_l();
        ItemStack returnedWalls = requiredWalls.func_77946_l();
        returnedCores.func_77964_b(currentItemMeta);
        returnedInterfaces.func_77964_b(currentItemMeta);
        returnedWalls.func_77964_b(currentItemMeta);
        InventoryHelpers.tryReAddToStack((EntityPlayer)player, (ItemStack)ItemStack.field_190927_a, (ItemStack)returnedCores);
        InventoryHelpers.tryReAddToStack((EntityPlayer)player, (ItemStack)ItemStack.field_190927_a, (ItemStack)returnedInterfaces);
        InventoryHelpers.tryReAddToStack((EntityPlayer)player, (ItemStack)ItemStack.field_190927_a, (ItemStack)returnedWalls);
        return null;
    }

    protected boolean consumeItems(EntityPlayer player, ItemStack consumeStack, boolean simulate) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        int validItems = 0;
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (stack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)consumeStack)) continue;
            int previousValidItems = validItems;
            validItems += stack.func_190916_E();
            validItems = Math.min(consumeStack.func_190916_E(), validItems);
            if (simulate) continue;
            stack.func_190918_g(validItems - previousValidItems);
            it.replace(stack.func_190916_E() == 0 ? ItemStack.field_190927_a : stack);
        }
        return validItems == consumeStack.func_190916_E();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!ItemStackHelpers.isValidCreativeTab((Item)this, (CreativeTabs)tab)) {
            return;
        }
        super.func_150895_a(tab, subItems);
        subItems.add((Object)new ItemStack((Item)this, 1, 1));
    }

    protected PropertyMaterial.Type transformType(ItemStack itemStack, PropertyMaterial.Type type) {
        if (itemStack.func_77960_j() == 0 && type.ordinal() < PropertyMaterial.Type.values().length - 1) {
            return PropertyMaterial.Type.values()[type.ordinal() + 1];
        }
        if (itemStack.func_77960_j() == 1 && type.ordinal() > 0) {
            return PropertyMaterial.Type.values()[type.ordinal() - 1];
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemUpgradeTool)) {
            return false;
        }
        ItemUpgradeTool other = (ItemUpgradeTool)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemUpgradeTool;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "ItemUpgradeTool()";
    }
}

