/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class PauseCitizenMessage
extends AbstractMessage<PauseCitizenMessage, IMessage> {
    private int colonyId;
    private int colonyDim;
    private int citizenID;

    public PauseCitizenMessage() {
    }

    public PauseCitizenMessage(@NotNull AbstractBuildingView building, int citizenID) {
        this.colonyId = building.getColony().getID();
        this.colonyDim = building.getColony().getDimension();
        this.citizenID = citizenID;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.colonyDim = buf.readInt();
        this.citizenID = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.colonyDim);
        buf.writeInt(this.citizenID);
    }

    @Override
    public void messageOnServerThread(PauseCitizenMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.colonyDim);
        if (colony != null) {
            CitizenData citizen;
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            citizen.setPaused(!(citizen = colony.getCitizenManager().getCitizen(message.citizenID)).isPaused());
        }
    }
}

