/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.entity.ai.mobs.EntityMercenary;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HireMercenaryMessage
extends AbstractMessage<HireMercenaryMessage, IMessage> {
    private int colonyID = 0;
    private int dimension = 0;

    public HireMercenaryMessage() {
    }

    public HireMercenaryMessage(ColonyView colony) {
        this.colonyID = colony.getID();
        this.dimension = colony.getDimension();
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.colonyID = byteBuf.readInt();
        this.dimension = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.colonyID);
        byteBuf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(HireMercenaryMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyID, message.dimension);
        if (colony != null) {
            EntityMercenary.spawnMercenariesInColony(colony);
            colony.getWorld().func_184134_a((double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), SoundEvents.field_193784_dd, null, 1.0f, 1.0f, true);
        }
    }
}

