/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCrusher;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class CrusherSetModeMessage
extends AbstractMessage<CrusherSetModeMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private int dimension;
    private int quantity;
    private ItemStack crusherMode;

    public CrusherSetModeMessage() {
    }

    public CrusherSetModeMessage(@NotNull BuildingCrusher.View building, ItemStorage crusherMode, int dailyQuantity) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.quantity = dailyQuantity;
        this.crusherMode = crusherMode.getItemStack();
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.dimension = buf.readInt();
        this.quantity = buf.readInt();
        this.crusherMode = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.dimension);
        buf.writeInt(this.quantity);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.crusherMode);
    }

    @Override
    public void messageOnServerThread(CrusherSetModeMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            BuildingCrusher building = colony.getBuildingManager().getBuilding(message.buildingId, BuildingCrusher.class);
            if (building != null) {
                int qty = message.quantity;
                if (qty > building.getMaxDailyQuantity()) {
                    qty = building.getMaxDailyQuantity();
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.crusher.toomuch", new Object[]{qty}));
                }
                building.setCrusherMode(new ItemStorage(message.crusherMode), qty);
            }
        }
    }
}

