/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class DebugRendererChunkBorder {
    private Tuple<Integer, Integer> center = new Tuple<Integer, Integer>(0, 0);
    private Map<Tuple<Integer, Integer>, Integer> colonies = new HashMap<Tuple<Integer, Integer>, Integer>();

    @SubscribeEvent
    public void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        double partialTicks = event.getPartialTicks();
        EntityPlayerSP entityplayer = Minecraft.func_71410_x().field_71439_g;
        if (entityplayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() != ModItems.buildTool) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ColonyView view = ColonyManager.getClosestColonyView((World)world, entityplayer.func_180425_c());
        if (view == null) {
            return;
        }
        if (!this.center.equals(new Tuple<Integer, Integer>(entityplayer.field_70176_ah, entityplayer.field_70164_aj))) {
            this.center = new Tuple<Integer, Integer>(entityplayer.field_70176_ah, entityplayer.field_70164_aj);
            this.colonies.clear();
            int range = Configurations.gameplay.workingRangeTownHallChunks;
            for (int incX = -range; incX <= range; ++incX) {
                for (int incZ = -range; incZ <= range; ++incZ) {
                    Chunk chunk = world.func_72964_e(entityplayer.field_70176_ah + incX, entityplayer.field_70164_aj + incZ);
                    IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
                    if (cap == null) continue;
                    this.colonies.put(new Tuple<Integer, Integer>(incX, incZ), cap.getOwningColony());
                }
            }
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double relPlayerX = entityplayer.field_70142_S + (entityplayer.field_70165_t - entityplayer.field_70142_S) * partialTicks;
        double relPlayerY = entityplayer.field_70137_T + (entityplayer.field_70163_u - entityplayer.field_70137_T) * partialTicks;
        double relPlayerZ = entityplayer.field_70136_U + (entityplayer.field_70161_v - entityplayer.field_70136_U) * partialTicks;
        double lowerYLimit = 5.0 - relPlayerY;
        double upperYLimit = 255.0 - relPlayerY;
        double lowerYLimitSmaller = Math.max(lowerYLimit, entityplayer.field_70163_u - 30.0 - relPlayerY);
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        double chunkCoordX = (double)(entityplayer.field_70176_ah << 4) - relPlayerX;
        double chunkCoordZ = (double)(entityplayer.field_70164_aj << 4) - relPlayerZ;
        GlStateManager.func_187441_d((float)1.0f);
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (Map.Entry<Tuple<Integer, Integer>, Integer> c : this.colonies.entrySet()) {
            int x = (Integer)c.getKey().func_76341_a();
            int z = (Integer)c.getKey().func_76340_b();
            int incX = x * 16;
            int incZ = z * 16;
            if (c.getValue().intValue() != view.getID()) continue;
            boolean north = false;
            boolean south = false;
            boolean east = false;
            boolean west = false;
            if (!c.getValue().equals(this.colonies.get(new Tuple<Integer, Integer>(x, z - 1))) && this.colonies.containsKey(new Tuple<Integer, Integer>(x, z - 1))) {
                north = true;
            }
            if (!c.getValue().equals(this.colonies.get(new Tuple<Integer, Integer>(x, z + 1))) && this.colonies.containsKey(new Tuple<Integer, Integer>(x, z + 1))) {
                south = true;
            }
            if (!c.getValue().equals(this.colonies.get(new Tuple<Integer, Integer>(x + 1, z))) && this.colonies.containsKey(new Tuple<Integer, Integer>(x + 1, z))) {
                east = true;
            }
            if (!c.getValue().equals(this.colonies.get(new Tuple<Integer, Integer>(x - 1, z))) && this.colonies.containsKey(new Tuple<Integer, Integer>(x - 1, z))) {
                west = true;
            }
            double levels = lowerYLimit;
            while (levels <= upperYLimit) {
                if (north) {
                    bufferbuilder.func_181662_b(chunkCoordX + (double)incX, levels, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(chunkCoordX + 16.0 + (double)incX, levels, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                }
                if (south) {
                    bufferbuilder.func_181662_b(chunkCoordX + 16.0 + (double)incX, levels, chunkCoordZ + 16.0 + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(chunkCoordX + (double)incX, levels, chunkCoordZ + 16.0 + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                }
                if (east) {
                    bufferbuilder.func_181662_b(chunkCoordX + 16.0 + (double)incX, levels, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(chunkCoordX + 16.0 + (double)incX, levels, chunkCoordZ + 16.0 + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                }
                if (west) {
                    bufferbuilder.func_181662_b(chunkCoordX + (double)incX, levels, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(chunkCoordX + (double)incX, levels, chunkCoordZ + 16.0 + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                }
                if (levels > lowerYLimitSmaller) {
                    levels += upperYLimit / relPlayerY / (upperYLimit / relPlayerY - levels / relPlayerY) * 10.0;
                    continue;
                }
                levels += 5.0;
            }
            if (north) {
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX, lowerYLimit, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX, lowerYLimit, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX, upperYLimit, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX, upperYLimit, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            }
            if (south) {
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX + 16.0, lowerYLimit, chunkCoordZ + (double)incZ + 16.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX + 16.0, lowerYLimit, chunkCoordZ + (double)incZ + 16.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX + 16.0, upperYLimit, chunkCoordZ + (double)incZ + 16.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX + 16.0, upperYLimit, chunkCoordZ + (double)incZ + 16.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            }
            if (east) {
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX + 16.0, lowerYLimit, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX + 16.0, lowerYLimit, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX + 16.0, upperYLimit, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                bufferbuilder.func_181662_b(chunkCoordX + (double)incX + 16.0, upperYLimit, chunkCoordZ + (double)incZ).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            }
            if (!west) continue;
            bufferbuilder.func_181662_b(chunkCoordX + (double)incX, lowerYLimit, chunkCoordZ + (double)incZ + 16.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(chunkCoordX + (double)incX, lowerYLimit, chunkCoordZ + (double)incZ + 16.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
            bufferbuilder.func_181662_b(chunkCoordX + (double)incX, upperYLimit, chunkCoordZ + (double)incZ + 16.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
            bufferbuilder.func_181662_b(chunkCoordX + (double)incX, upperYLimit, chunkCoordZ + (double)incZ + 16.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)2.0f);
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
    }
}

