/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.statemachine.tickratestatemachine;

import com.minecolonies.coremod.entity.ai.statemachine.basestatemachine.BasicTransition;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class TickingTransition
extends BasicTransition {
    @NotNull
    private int tickRate;
    @NotNull
    private final int tickOffset;
    private static int tickOffsetVariant = 0;

    public TickingTransition(@NotNull IAIState state, @NotNull BooleanSupplier condition, @NotNull Supplier<IAIState> nextState, @NotNull int tickRate) {
        super(state, condition, nextState);
        this.tickRate = tickRate > 500 ? 500 : tickRate;
        this.tickRate = this.tickRate < 1 ? 1 : this.tickRate;
        this.tickOffset = tickOffsetVariant % this.tickRate;
        if (++tickOffsetVariant >= 50) {
            tickOffsetVariant = 0;
        }
    }

    protected TickingTransition(@NotNull BooleanSupplier condition, @NotNull Supplier<IAIState> nextState, @NotNull int tickRate) {
        super(condition, nextState);
        this.tickRate = tickRate > 500 ? 500 : tickRate;
        this.tickRate = this.tickRate < 1 ? 1 : this.tickRate;
        this.tickOffset = tickOffsetVariant % this.tickRate;
        if (++tickOffsetVariant >= 50) {
            tickOffsetVariant = 0;
        }
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public void setTickRate(@NotNull int tickRate) {
        this.tickRate = tickRate;
    }

    public int getTickOffset() {
        return this.tickOffset;
    }
}

