/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.constant.RaiderConstants;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.entity.IColonyRelatedEntity;
import com.minecolonies.coremod.entity.ai.mobs.util.BarbarianUtils;
import com.minecolonies.coremod.entity.ai.mobs.util.MobSpawnUtils;
import com.minecolonies.coremod.entity.pathfinding.PathNavigate;
import com.minecolonies.coremod.items.ItemChiefSword;
import com.minecolonies.coremod.sounds.BarbarianSounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityMinecoloniesMob
extends EntityMob
implements IColonyRelatedEntity {
    private PathNavigate newNavigator;
    private Colony colony;
    private final Random random = new Random();
    private int currentCount = 0;
    private long worldTimeAtSpawn = 0L;
    private int currentTick = 0;
    private int stuckCounter = 1;
    private int ladderCounter = 0;

    public AbstractEntityMinecoloniesMob(World world) {
        super(world);
    }

    protected void func_184651_r() {
        MobSpawnUtils.setMobAI(this);
    }

    protected void func_70088_a() {
        this.worldTimeAtSpawn = this.field_70170_p.func_82737_E();
        this.func_110163_bv();
        super.func_70088_a();
    }

    public void func_70108_f(@NotNull Entity entityIn) {
        if (entityIn instanceof AbstractEntityMinecoloniesMob && (this.stuckCounter > 0 || this.ladderCounter > 0 || ((AbstractEntityMinecoloniesMob)entityIn).stuckCounter > 0 || ((AbstractEntityMinecoloniesMob)entityIn).ladderCounter > 0)) {
            return;
        }
        super.func_70108_f(entityIn);
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && this.field_70170_p.field_73012_v.nextInt(100) <= 1) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return BarbarianSounds.barbarianSay;
    }

    protected boolean func_70692_ba() {
        return this.shouldDespawn() || this.getColony() == null;
    }

    private boolean shouldDespawn() {
        return this.worldTimeAtSpawn != 0L && this.field_70170_p.func_82737_E() - this.worldTimeAtSpawn >= 12000L;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            super.func_70636_d();
            return;
        }
        if (this.currentTick % (this.random.nextInt(20) + 1) == 0) {
            if (this.worldTimeAtSpawn == 0L) {
                this.worldTimeAtSpawn = this.field_70170_p.func_82737_E();
            }
            if (this.shouldDespawn()) {
                this.func_70106_y();
            }
            if (this.currentCount <= 0) {
                this.currentCount = 960;
                MobSpawnUtils.setMobAttributes((EntityLiving)this, this.getColony());
                if (!this.func_184614_ca().func_190926_b() && RaiderConstants.SPEED_EFFECT != null && this.func_184614_ca().func_77973_b() instanceof ItemChiefSword && Configurations.gameplay.barbarianHordeDifficulty >= 5) {
                    BarbarianUtils.getBarbariansCloseToEntity((Entity)this, 7.0).stream().filter(entity -> !entity.func_70644_a(RaiderConstants.SPEED_EFFECT)).forEach(entity -> entity.func_70690_d(new PotionEffect(RaiderConstants.SPEED_EFFECT, 60, 2)));
                }
            } else {
                --this.currentCount;
            }
        }
        ++this.currentTick;
        super.func_70636_d();
    }

    public int getStuckCounter() {
        return this.stuckCounter;
    }

    public void setStuckCounter(int stuckCounter) {
        this.stuckCounter = stuckCounter;
    }

    public int getLadderCounter() {
        return this.ladderCounter;
    }

    public void setLadderCounter(int ladderCounter) {
        this.ladderCounter = ladderCounter;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return BarbarianSounds.barbarianHurt;
    }

    protected SoundEvent func_184615_bR() {
        return BarbarianSounds.barbarianDeath;
    }

    @NotNull
    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74772_a("time", this.worldTimeAtSpawn);
        compound.func_74768_a("stuck", this.stuckCounter);
        compound.func_74768_a("ladder", this.ladderCounter);
        compound.func_74768_a("colony", this.colony == null ? 0 : this.colony.getID());
        return super.func_189511_e(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        int colonyId;
        this.worldTimeAtSpawn = compound.func_74763_f("time");
        this.stuckCounter = compound.func_74762_e("stuck");
        this.ladderCounter = compound.func_74762_e("ladder");
        if (compound.func_74764_b("colony") && (colonyId = compound.func_74762_e("colony")) != 0) {
            this.setColony(ColonyManager.getColonyByWorld(colonyId, this.field_70170_p));
        }
        super.func_70020_e(compound);
    }

    @NotNull
    public PathNavigate getNavigator() {
        if (this.newNavigator == null) {
            this.newNavigator = new PathNavigate((EntityLiving)this, this.field_70170_p);
            this.field_70699_by = this.newNavigator;
            this.newNavigator.func_179693_d(true);
            this.newNavigator.func_179691_c(false);
        }
        return this.newNavigator;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        MobSpawnUtils.setEquipment(this);
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_70609_aI() {
        if (!(this.func_94060_bK() instanceof EntityPlayer) && this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            int experience = EntityXPOrb.func_70527_a((int)1);
            CompatibilityUtils.spawnEntity(this.field_70170_p, (Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, experience));
        }
        super.func_70609_aI();
    }

    @Override
    public Colony getColony() {
        if (!this.field_70170_p.field_72995_K && this.colony == null) {
            this.setColony(ColonyManager.getClosestColony(CompatibilityUtils.getWorld((Entity)this), this.func_180425_c()));
        }
        return this.colony;
    }

    @Override
    public void registerWithColony() {
        this.getColony();
    }

    public void func_70645_a(@NotNull DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.getColony() != null) {
            this.getColony().getRaiderManager().unregisterRaider(this, (WorldServer)this.field_70170_p);
        }
    }

    @Override
    public void setColony(Colony colony) {
        if (colony != null) {
            this.colony = colony;
            this.colony.getRaiderManager().registerRaider(this);
        }
    }
}

