/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.coremod.entity.ai.statemachine.AITarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import com.minecolonies.coremod.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class EntityAICitizenChild
extends EntityAIBase {
    protected final EntityCitizen child;
    private final Random rand = new Random();
    private final TickRateStateMachine stateMachine;
    private int actionTimer = 0;
    private static final int START_FOLLOW_DISTANCE = 10;
    private int AIActiveTime = 0;
    private static final int MIN_ACTIVE_TIME = 4000;
    private WeakReference<Entity> followTarget = new WeakReference<Object>(null);
    private BlockPos followStart;
    private BlockPos visitHutPos;
    private PathResult visitingPath;

    public EntityAICitizenChild(@NotNull EntityCitizen citizen) {
        this.child = citizen;
        this.func_75248_a(1);
        this.stateMachine = new TickRateStateMachine(State.IDLE, this::handleAIException);
        this.stateMachine.addTransition(new AIEventTarget(AIBlockingEventType.STATE_BLOCKING, this::updateTimers, this.stateMachine::getState, 1));
        this.stateMachine.addTransition(new AIEventTarget(AIBlockingEventType.EVENT, this::tryGrowUp, () -> State.IDLE, 500));
        this.stateMachine.addTransition(new AITarget(State.IDLE, this::searchEntityToFollow, () -> State.FOLLOWING, 150));
        this.stateMachine.addTransition(new AITarget(State.IDLE, this::isReadyForActivity, () -> State.VISITING, 300));
        this.stateMachine.addTransition(new AITarget((IAIState)State.FOLLOWING, this::followingEntity, 20));
        this.stateMachine.addTransition(new AITarget((IAIState)State.VISITING, this::visitHuts, 120));
    }

    private void handleAIException(RuntimeException ex) {
        this.stateMachine.reset();
        Log.getLogger().warn("EntityAICitizenChild Child: " + this.child.func_70005_c_() + " threw an exception:", (Throwable)ex);
    }

    private boolean updateTimers() {
        if (this.actionTimer > 0) {
            this.actionTimer -= Configurations.gameplay.updateRate;
        }
        this.AIActiveTime += Configurations.gameplay.updateRate;
        return false;
    }

    private boolean isReadyForActivity() {
        return this.actionTimer <= 0;
    }

    private void setDelayForNextAction() {
        this.actionTimer = this.rand.nextInt(2400) + 3600;
    }

    private boolean searchEntityToFollow() {
        if (!this.isReadyForActivity()) {
            return false;
        }
        CompatibilityUtils.getWorld((Entity)this.child).func_175674_a((Entity)this.child, this.child.func_174813_aQ().func_72321_a(10.0, 1.0, 10.0), target -> target.func_70089_S() && (target instanceof EntityAgeable || target instanceof EntityPlayer)).stream().findFirst().ifPresent(entity -> {
            this.followTarget = new WeakReference<Entity>((Entity)entity);
        });
        if (this.followTarget.get() != null) {
            this.actionTimer = this.rand.nextInt(600) + 600;
            this.followStart = this.child.func_180425_c();
            return true;
        }
        return false;
    }

    private IAIState followingEntity() {
        if (this.actionTimer <= 0 || this.followTarget.get() == null) {
            this.child.getNavigator().moveToXYZ(this.followStart.func_177958_n(), this.followStart.func_177956_o(), this.followStart.func_177952_p(), 1.0);
            this.setDelayForNextAction();
            return State.IDLE;
        }
        this.child.getNavigator().moveToEntityLiving((Entity)this.followTarget.get(), 1.0);
        return State.FOLLOWING;
    }

    private IAIState visitHuts() {
        if (this.visitingPath == null && this.child.getCitizenColonyHandler().getColony() != null) {
            if (this.actionTimer <= 0 && this.visitHutPos == null) {
                this.actionTimer = 3600;
            }
            int index = this.child.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().size();
            index = this.rand.nextInt(index);
            ArrayList<BlockPos> buildings = new ArrayList<BlockPos>(this.child.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().keySet());
            this.visitHutPos = (BlockPos)buildings.get(index);
            this.visitingPath = this.child.getNavigator().moveToXYZ(this.visitHutPos.func_177958_n(), this.visitHutPos.func_177956_o(), this.visitHutPos.func_177952_p(), 1.0);
        }
        if (this.actionTimer > 0) {
            if (this.visitingPath != null && !this.visitingPath.isInProgress()) {
                this.visitingPath = this.child.getNavigator().moveToXYZ(this.visitHutPos.func_177958_n(), this.visitHutPos.func_177956_o(), this.visitHutPos.func_177952_p(), 1.0);
            }
            return State.VISITING;
        }
        this.child.getNavigator().func_75499_g();
        this.visitingPath = null;
        this.visitHutPos = null;
        this.setDelayForNextAction();
        return State.IDLE;
    }

    private boolean tryGrowUp() {
        if (this.AIActiveTime >= 4000) {
            if (!this.child.func_70631_g_()) {
                return true;
            }
            if (this.rand.nextInt((int)(70.0 / Configurations.gameplay.growthModifier)) == 0 || (double)this.AIActiveTime > 70000.0 / Configurations.gameplay.growthModifier) {
                LanguageHandler.sendPlayersMessage(this.child.getCitizenColonyHandler().getColony().getMessageEntityPlayers(), "com.minecolonies.coremod.progress.childGrow", this.child.func_70005_c_());
                this.child.setIsChild(false);
                this.child.getCitizenData().setIsChild(false);
                return true;
            }
        }
        return false;
    }

    public boolean func_75250_a() {
        return this.child.func_70631_g_();
    }

    public boolean func_75253_b() {
        if (this.child.getDesiredActivity() == DesiredActivity.SLEEP || !this.child.func_70631_g_()) {
            return false;
        }
        this.stateMachine.tick();
        return true;
    }

    public static enum State implements IAIState
    {
        IDLE,
        BORED,
        PLAYING,
        VISITING,
        FOLLOWING;


        @Override
        public boolean isOkayToEat() {
            return true;
        }
    }
}

