/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.trainingcamps;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIBasic;
import com.minecolonies.coremod.entity.ai.statemachine.AITarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAITraining<J extends AbstractJob>
extends AbstractEntityAIBasic<AbstractJob> {
    private static final int TARGET_SEARCH_CHANCE = 10;
    protected static final int ONE_HUNDRED_PERCENT = 100;
    private AxisAlignedBB range;
    protected BlockPos currentPathingTarget;
    protected IAIState stateAfterPathing;
    protected int currentAttackDelay = 0;

    public AbstractEntityAITraining(@NotNull AbstractJob job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING), new AITarget((IAIState)AIWorkerState.START_WORKING, () -> AIWorkerState.DECIDE), new AITarget((IAIState)AIWorkerState.DECIDE, this::decide), new AITarget((IAIState)AIWorkerState.TRAINING_WANDER, this::wander), new AITarget((IAIState)AIWorkerState.GO_TO_TARGET, this::pathToTarget));
        this.worker.func_98053_h(true);
    }

    public IAIState decide() {
        this.setDelay(5);
        if (!this.isSetup()) {
            return AIWorkerState.DECIDE;
        }
        if (this.worker.getRandom().nextInt(100) < 10) {
            return AIWorkerState.COMBAT_TRAINING;
        }
        return AIWorkerState.TRAINING_WANDER;
    }

    protected abstract boolean isSetup();

    private IAIState wander() {
        this.setDelay(5);
        if (this.currentPathingTarget == null) {
            this.currentPathingTarget = this.getWanderPosition();
        }
        if (!this.walkToBlock(this.currentPathingTarget) || this.worker.getCitizenStuckHandler().isStuck()) {
            this.currentPathingTarget = null;
            return AIWorkerState.DECIDE;
        }
        return AIWorkerState.TRAINING_WANDER;
    }

    private IAIState pathToTarget() {
        this.setDelay(5);
        if (this.walkToBlock(this.currentPathingTarget, 2)) {
            return this.getState();
        }
        return this.stateAfterPathing;
    }

    private BlockPos getWanderPosition() {
        BlockPos pos = BlockPosUtil.getRandomPosition(this.world, this.worker.func_180425_c(), ((AbstractSchematicProvider)this.getOwnBuilding()).getLocation());
        if (this.range == null) {
            this.range = ((AbstractSchematicProvider)this.getOwnBuilding()).getTargetableArea(this.world);
        }
        if (this.range.func_186667_c(new Vec3d((Vec3i)pos))) {
            return pos;
        }
        return ((AbstractSchematicProvider)this.getOwnBuilding()).getLocation();
    }

    protected void reduceAttackDelay() {
        if (this.currentAttackDelay > 0) {
            --this.currentAttackDelay;
        }
    }
}

