/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.views.MobEntryView;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIFight;
import com.minecolonies.coremod.entity.ai.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.coremod.entity.ai.statemachine.AITarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import com.minecolonies.coremod.util.TeleportHelper;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIGuard<J extends AbstractJobGuard>
extends AbstractEntityAIFight<J> {
    private static final int ACTIONS_UNTIL_DUMPING = 5;
    private static final int MAX_PATROL_DERIVATION = 50;
    private static final int MAX_FOLLOW_DERIVATION = 20;
    private static final int MAX_GUARD_DERIVATION = 10;
    private static final int STOP_PERSECUTION_AFTER = 200;
    protected int currentAttackDelay = 0;
    private int lastSeen = 0;
    protected EntityLivingBase target = null;
    private BlockPos currentPatrolPoint = null;
    private WeakReference<EntityCitizen> helpCitizen = new WeakReference<Object>(null);
    protected final AbstractBuildingGuards buildingGuards;

    public AbstractEntityAIGuard(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.DECIDE, this::decide), new AITarget((IAIState)AIWorkerState.GUARD_PATROL, this::patrol), new AITarget((IAIState)AIWorkerState.GUARD_FOLLOW, this::follow), new AITarget((IAIState)AIWorkerState.GUARD_GUARD, this::guard), new AITarget((IAIState)AIWorkerState.GUARD_REGEN, this::regen), new AITarget((IAIState)AIWorkerState.HELP_CITIZEN, this::helping, 20));
        this.buildingGuards = (AbstractBuildingGuards)this.getOwnBuilding();
    }

    private IAIState regen() {
        this.setDelay(5);
        if (this.walkToBuilding() || (double)this.worker.func_110143_aJ() < (double)((int)this.worker.func_110138_aP()) * 0.5 && this.buildingGuards.shallRetrieveOnLowHealth()) {
            return this.getState();
        }
        return AIWorkerState.START_WORKING;
    }

    public abstract IAIState getAttackState();

    private IAIState guard() {
        if (this.checkForTarget()) {
            if (this.hasTool()) {
                return this.getAttackState();
            }
            return AIWorkerState.START_WORKING;
        }
        this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getGuardPos(), 3);
        return AIWorkerState.GUARD_GUARD;
    }

    private IAIState follow() {
        if (this.checkForTarget()) {
            if (this.hasTool()) {
                return this.getAttackState();
            }
            return AIWorkerState.START_WORKING;
        }
        this.worker.func_70690_d(new PotionEffect(Constants.GLOW_EFFECT, 600, 20));
        this.world.func_96441_U().func_151392_a(this.worker.func_70005_c_(), "teamcolony" + this.worker.getCitizenColonyHandler().getColonyId());
        if (BlockPosUtil.getDistance2D(this.worker.func_180425_c(), this.buildingGuards.getPlayerToFollow()) > 20L) {
            TeleportHelper.teleportCitizen(this.worker, this.worker.field_70170_p, this.buildingGuards.getPlayerToFollow());
            return AIWorkerState.GUARD_FOLLOW;
        }
        if (this.buildingGuards.isTightGrouping()) {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPlayerToFollow(), 8);
        } else if (!this.isWithinPersecutionDistance(this.buildingGuards.getPlayerToFollow())) {
            this.worker.getNavigator().func_75499_g();
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
        } else {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPlayerToFollow(), 20);
        }
        return AIWorkerState.GUARD_FOLLOW;
    }

    private IAIState patrol() {
        if (this.checkForTarget()) {
            if (this.hasTool()) {
                return this.getAttackState();
            }
            return AIWorkerState.START_WORKING;
        }
        if (this.currentPatrolPoint == null) {
            this.currentPatrolPoint = this.buildingGuards.getNextPatrolTarget(null);
        }
        if (this.currentPatrolPoint != null && (this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 2) || this.worker.getCitizenStuckHandler().isStuck())) {
            this.currentPatrolPoint = this.buildingGuards.getNextPatrolTarget(this.currentPatrolPoint);
        }
        return AIWorkerState.GUARD_PATROL;
    }

    @Override
    public Class getExpectedBuildingClass() {
        return AbstractBuildingGuards.class;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return this.getOwnBuilding(AbstractBuildingGuards.class).getTask() == GuardTask.FOLLOW || this.target != null ? Integer.MAX_VALUE : 5 * ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel();
    }

    public boolean hasTool() {
        this.setDelay(20);
        for (ToolType toolType : this.toolsNeeded) {
            if (InventoryUtils.hasItemHandlerToolWithLevel((IItemHandler)new InvWrapper((IInventory)this.getInventory()), toolType, 0, this.buildingGuards.getMaxToolLevel())) continue;
            this.setDelay(5);
            return false;
        }
        return true;
    }

    public void startHelpCitizen(EntityCitizen citizen, EntityLivingBase attacker) {
        if (this.canHelp()) {
            this.registerTarget(new AIOneTimeEventTarget(AIWorkerState.HELP_CITIZEN));
            this.target = attacker;
            this.helpCitizen = new WeakReference<EntityCitizen>(citizen);
        }
    }

    public boolean canHelp() {
        return (this.target == null || this.target.field_70128_L) && this.getState() != AIWorkerState.HELP_CITIZEN;
    }

    private IAIState helping() {
        if (this.helpCitizen.get() == null || !((EntityCitizen)((Object)this.helpCitizen.get())).isCurrentlyFleeing()) {
            return AIWorkerState.DECIDE;
        }
        if (this.target == null || this.target.field_70128_L) {
            this.target = ((EntityCitizen)((Object)this.helpCitizen.get())).func_70638_az();
            if (this.target == null || this.target.field_70128_L) {
                return AIWorkerState.DECIDE;
            }
        }
        this.currentPatrolPoint = null;
        if (this.worker.func_70635_at().func_75522_a((Entity)this.target) && this.isWithinPersecutionDistance(this.target.func_180425_c())) {
            this.target.func_70604_c((EntityLivingBase)this.worker);
            return this.getAttackState();
        }
        this.moveInAttackPosition();
        return AIWorkerState.HELP_CITIZEN;
    }

    protected IAIState decide() {
        this.setDelay(5);
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return this.patrol();
            }
            case GUARD: {
                return this.guard();
            }
            case FOLLOW: {
                return this.follow();
            }
        }
        this.worker.isWorkerAtSiteWithMove(this.worker.getCitizenColonyHandler().getWorkBuilding().getLocation(), 3);
        return AIWorkerState.DECIDE;
    }

    protected boolean checkForTarget() {
        if (this.target != null && this.target.field_70128_L) {
            this.incrementActionsDoneAndDecSaturation();
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.target = null;
        }
        this.target = this.getTarget();
        if (this.target != null) {
            if (!this.isInAttackDistance(this.target.func_180425_c())) {
                if (this.worker.getNavigator().func_75500_f()) {
                    this.moveInAttackPosition();
                }
                this.setDelay(0);
                return false;
            }
            this.setDelay(0);
            return true;
        }
        return false;
    }

    public abstract void moveInAttackPosition();

    public IAIState preAttackChecks() {
        if (!this.hasMainWeapon()) {
            this.target = null;
            return AIWorkerState.START_WORKING;
        }
        if ((double)this.worker.func_110143_aJ() < (double)((int)this.worker.func_110138_aP()) * 0.2 && this.buildingGuards.shallRetrieveOnLowHealth()) {
            this.target = null;
            this.setDelay(5);
            return AIWorkerState.GUARD_REGEN;
        }
        if (this.worker.func_70643_av() != null && !this.worker.func_70643_av().field_70128_L && (this.isInAttackDistance(this.worker.func_70643_av().func_180425_c()) || this.isWithinPersecutionDistance(this.worker.func_70643_av().func_180425_c()))) {
            this.target = this.worker.func_70643_av();
        }
        if (this.target == null || this.target.field_70128_L || !this.isWithinPersecutionDistance(this.target.func_180425_c())) {
            this.worker.getNavigator().func_75499_g();
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
            return AIWorkerState.DECIDE;
        }
        this.wearWeapon();
        return this.getState();
    }

    public abstract boolean hasMainWeapon();

    protected EntityLivingBase getTarget() {
        Colony colony;
        this.reduceAttackDelay(1);
        if (this.worker.func_110144_aD() != null && !this.worker.func_110144_aD().field_70128_L) {
            if (!this.isWithinPersecutionDistance(this.worker.func_110144_aD().func_180425_c())) {
                this.worker.func_130011_c(null);
            }
            this.target = this.worker.func_110144_aD();
        }
        if (this.target != null) {
            if (!this.worker.func_70685_l((Entity)this.target) && this.lastSeen < 200 || !this.isWithinPersecutionDistance(this.target.func_180425_c())) {
                this.target = null;
            } else {
                ++this.lastSeen;
                return this.target;
            }
        }
        if ((colony = this.worker.getCitizenColonyHandler().getColony()) != null) {
            if (!colony.getRaiderManager().getHorde((WorldServer)this.worker.field_70170_p).isEmpty() || colony.isColonyUnderAttack()) {
                for (CitizenData citizen : colony.getCitizenManager().getCitizens()) {
                    if (!citizen.getCitizenEntity().isPresent()) continue;
                    EntityLivingBase entity2 = citizen.getCitizenEntity().get().func_110144_aD();
                    if (entity2 instanceof AbstractEntityMinecoloniesMob && this.worker.func_70685_l((Entity)entity2)) {
                        return entity2;
                    }
                    if (entity2 instanceof EntityCitizen && this.worker.func_70685_l((Entity)entity2) && ((EntityCitizen)entity2).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
                        return entity2;
                    }
                    if (!(entity2 instanceof EntityPlayer) || !this.worker.func_70685_l((Entity)entity2)) continue;
                    colony.isValidAttackingPlayer((EntityPlayer)entity2);
                }
            }
            List targets = this.world.func_175647_a(EntityLivingBase.class, this.getSearchArea(), entity -> this.buildingGuards.getMobsToAttack().stream().filter(MobEntryView::hasAttack).anyMatch(mobEntry -> mobEntry.getEntityEntry().getEntityClass().isInstance(entity)));
            int closest = Integer.MAX_VALUE;
            EntityLivingBase targetEntity = null;
            for (EntityLivingBase entity3 : targets) {
                if (!this.worker.func_70685_l((Entity)entity3) || !this.isWithinPersecutionDistance(entity3.func_180425_c())) continue;
                if (entity3 instanceof EntityPlayer && (colony.getPermissions().hasPermission((EntityPlayer)entity3, Action.GUARDS_ATTACK) || colony.isValidAttackingPlayer((EntityPlayer)entity3))) {
                    return entity3;
                }
                if (entity3 instanceof EntityCitizen && colony.isValidAttackingGuard((EntityCitizen)entity3)) {
                    return entity3;
                }
                int tempDistance = (int)this.worker.func_180425_c().func_177954_c(entity3.field_70165_t, entity3.field_70163_u, entity3.field_70161_v);
                if (tempDistance >= closest) continue;
                closest = tempDistance;
                targetEntity = entity3;
            }
            return targetEntity;
        }
        return null;
    }

    public abstract void wearWeapon();

    public boolean isInAttackDistance(BlockPos position) {
        return BlockPosUtil.getMaxDistance2D(this.worker.func_180425_c(), position) <= this.getAttackRange();
    }

    public void reduceAttackDelay(int tickRate) {
        if (this.currentAttackDelay > 0) {
            this.currentAttackDelay -= tickRate;
        }
    }

    private boolean isWithinPersecutionDistance(BlockPos entityPos) {
        return BlockPosUtil.getMaxDistance2D(this.getTaskReferencePoint(), entityPos) <= this.getPersecutionDistance() + this.getAttackRange();
    }

    public int getLevelDamage() {
        if (this.worker.getCitizenData() == null) {
            return 0;
        }
        return this.worker.getCitizenData().getLevel() / (5 + this.worker.getCitizenData().getLevel() / 15);
    }

    private BlockPos getTaskReferencePoint() {
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return this.currentPatrolPoint != null ? this.currentPatrolPoint : this.worker.getCurrentPosition();
            }
            case FOLLOW: {
                return this.buildingGuards.getPlayerToFollow();
            }
        }
        return this.buildingGuards.getGuardPos();
    }

    private int getPersecutionDistance() {
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return 50;
            }
            case FOLLOW: {
                return 20;
            }
        }
        return 10;
    }

    private AxisAlignedBB getSearchArea() {
        AbstractBuildingGuards building = (AbstractBuildingGuards)this.getOwnBuilding();
        double x1 = this.worker.field_70165_t + (double)(building.getBonusVision() + 10);
        double x2 = this.worker.field_70165_t - (double)(building.getBonusVision() + 10);
        double y1 = this.worker.field_70163_u + 5.0;
        double y2 = this.worker.field_70163_u - 20.0;
        double z1 = this.worker.field_70161_v + (double)(building.getBonusVision() + 10);
        double z2 = this.worker.field_70161_v - (double)(building.getBonusVision() + 10);
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    @Override
    protected abstract int getAttackRange();
}

