/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.baker;

import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBaker;
import com.minecolonies.coremod.colony.jobs.JobBaker;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import com.minecolonies.coremod.entity.ai.citizen.baker.BakerRecipes;
import com.minecolonies.coremod.entity.ai.citizen.baker.BakingProduct;
import com.minecolonies.coremod.entity.ai.citizen.baker.ProductState;
import com.minecolonies.coremod.entity.ai.statemachine.AITarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkBaker
extends AbstractEntityAISkill<JobBaker> {
    private static final int INTELLIGENCE_MULTIPLIER = 2;
    private static final int DEXTERITY_MULTIPLIER = 1;
    private static final int KNEADING_TIME = 5;
    private static final int HIT_DELAY = 20;
    private static final int UNABLE_TO_CRAFT_DELAY = 100;
    private static final int UNTIL_DUMP = 3;
    private static final int PROGRESS_MULTIPLIER = 50;
    private static final int MAX_LEVEL = 50;
    private static final double XP_PER_PRODUCT = 10.0;
    private BlockPos currentFurnace = null;
    private BakingProduct currentBakingProduct = null;
    private int progress = 0;
    private int currentRecipe = -1;

    public EntityAIWorkBaker(@NotNull JobBaker job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForBaking), new AITarget((IAIState)AIWorkerState.BAKER_KNEADING, this::kneadTheDough), new AITarget((IAIState)AIWorkerState.BAKER_BAKING, this::bake), new AITarget((IAIState)AIWorkerState.BAKER_TAKE_OUT_OF_OVEN, this::takeFromOven), new AITarget((IAIState)AIWorkerState.BAKER_FINISHING, this::finishing));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getIntelligence() + 1 * this.worker.getCitizenData().getDexterity());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingBaker.class;
    }

    private IAIState finishing() {
        if (this.currentBakingProduct == null || this.currentBakingProduct.getState() != ProductState.BAKED) {
            this.progress = 0;
            List<BakingProduct> bakingProducts = this.getOwnBuilding().getTasks().get((Object)ProductState.BAKED);
            if (bakingProducts == null || bakingProducts.isEmpty()) {
                this.getOwnBuilding().removeFromTasks(ProductState.BAKED, null);
                return AIWorkerState.PREPARING;
            }
            this.currentBakingProduct = bakingProducts.get(0);
        }
        if (this.currentBakingProduct.getState() != ProductState.BAKED) {
            return AIWorkerState.PREPARING;
        }
        this.worker.func_184611_a(EnumHand.MAIN_HAND, this.currentBakingProduct.getEndProduct());
        ItemStack newItem = this.currentBakingProduct.getEndProduct();
        this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.getOwnBuilding().getLocation());
        if (this.progress >= this.getRequiredProgressForKneading()) {
            this.worker.func_184611_a(EnumHand.MAIN_HAND, ItemStackUtils.EMPTY);
            this.getOwnBuilding().removeFromTasks(ProductState.BAKED, this.currentBakingProduct);
            if (newItem != null) {
                InventoryUtils.addItemStackToItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), newItem);
            }
            this.worker.getCitizenExperienceHandler().addExperience(10.0);
            this.incrementActionsDoneAndDecSaturation();
            this.progress = 0;
            this.currentBakingProduct = null;
            return AIWorkerState.PREPARING;
        }
        ++this.progress;
        this.setDelay(20);
        return this.getState();
    }

    @Override
    public BuildingBaker getOwnBuilding() {
        return (BuildingBaker)this.worker.getCitizenColonyHandler().getWorkBuilding();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 3;
    }

    private int getRequiredProgressForKneading() {
        return 50 / Math.min(this.worker.getCitizenExperienceHandler().getLevel() + 1, 50) * 5;
    }

    private IAIState takeFromOven() {
        if (this.currentFurnace == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.currentFurnace)) {
            return this.getState();
        }
        BakingProduct bakingProduct = this.getOwnBuilding().getFurnacesWithProduct().get(this.currentFurnace);
        this.getOwnBuilding().removeProductFromFurnace(this.currentFurnace);
        this.worker.decreaseSaturationForAction();
        if (bakingProduct != null) {
            this.getOwnBuilding().addToTasks(bakingProduct.getState(), bakingProduct);
        }
        this.currentFurnace = null;
        return AIWorkerState.START_WORKING;
    }

    private IAIState kneadTheDough() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        if (this.currentBakingProduct == null) {
            return this.createNewProduct();
        }
        if (this.currentBakingProduct != null) {
            IRecipeStorage storage = BakerRecipes.getRecipes().get(this.currentBakingProduct.getRecipeId());
            if (this.currentBakingProduct.getState() == ProductState.UNCRAFTED) {
                return this.craftNewProduct(storage);
            }
            if (this.currentBakingProduct.getState() != ProductState.RAW) {
                return AIWorkerState.PREPARING;
            }
            this.worker.func_184611_a(EnumHand.MAIN_HAND, storage.getInput().get(this.worker.getRandom().nextInt(storage.getInput().size())).func_77946_l());
            this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.getOwnBuilding().getLocation());
            if (this.progress >= this.getRequiredProgressForKneading()) {
                this.worker.func_184611_a(EnumHand.MAIN_HAND, ItemStackUtils.EMPTY);
                this.worker.decreaseSaturationForAction();
                this.progress = 0;
                this.currentBakingProduct.nextState();
                this.getOwnBuilding().removeFromTasks(ProductState.RAW, this.currentBakingProduct);
                this.getOwnBuilding().addToTasks(ProductState.PREPARED, this.currentBakingProduct);
                this.currentBakingProduct = null;
                return AIWorkerState.PREPARING;
            }
            ++this.progress;
            this.setDelay(20);
        }
        return this.getState();
    }

    private IAIState createNewProduct() {
        this.progress = 0;
        BuildingBaker building = this.getOwnBuilding();
        ++this.currentRecipe;
        if (this.currentRecipe >= building.getCopyOfAllowedItems().size()) {
            this.currentRecipe = 0;
        }
        ItemStorage itemStorage = building.getCopyOfAllowedItems().get("recipes").get(this.currentRecipe);
        IRecipeStorage recipeStorage = BakerRecipes.getRecipes().stream().filter(recipe -> recipe.getPrimaryOutput().func_77969_a(itemStorage.getItemStack())).findFirst().orElse(null);
        if (recipeStorage == null) {
            this.setDelay(100);
            return AIWorkerState.IDLE;
        }
        BakingProduct bakingProduct = new BakingProduct(recipeStorage.getPrimaryOutput().func_77946_l(), BakerRecipes.getRecipes().indexOf(recipeStorage));
        building.addToTasks(bakingProduct.getState(), bakingProduct);
        this.currentBakingProduct = bakingProduct;
        return this.getState();
    }

    private IAIState craftNewProduct(IRecipeStorage storage) {
        ArrayList<ItemStack> list;
        ItemStack copy;
        ArrayList<ItemStack> requestList = new ArrayList<ItemStack>();
        for (ItemStorage stack : storage.getCleanedInput()) {
            if (stack.getItem() != Items.field_151015_O) {
                requestList.add(stack.getItemStack());
                continue;
            }
            copy = stack.getItemStack();
            copy.func_190920_e(copy.func_77976_d());
            requestList.add(copy);
        }
        this.checkIfRequestForItemExistOrCreateAsynch(requestList.toArray(new ItemStack[0]));
        List<IItemHandler> handlers = this.getOwnBuilding().getHandlers();
        if (storage.canFullFillRecipe(handlers.toArray(new IItemHandler[0]))) {
            list = new ArrayList<ItemStack>();
            copy = null;
            for (ItemStorage stack : storage.getCleanedInput()) {
                if (stack.getItem() != Items.field_151015_O) {
                    list.add(stack.getItemStack());
                    continue;
                }
                copy = stack.getItemStack().func_77946_l();
            }
            if (copy != null) {
                int form = this.getOwnBuilding().getMaxBuildingLevel() + 1 - (this.getOwnBuilding().getBuildingLevel() + ItemStackUtils.getSize(copy));
                int req = 0;
                if (form != 0) {
                    req = form < 0 ? -this.worker.getRandom().nextInt(Math.abs(form)) : this.worker.getRandom().nextInt(form);
                }
                ItemStackUtils.changeSize(copy, req);
                list.add(copy);
            }
        } else {
            this.setDelay(100);
            return AIWorkerState.NEEDS_ITEM;
        }
        InventoryUtils.removeStacksFromItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), list);
        this.currentBakingProduct.nextState();
        this.getOwnBuilding().removeFromTasks(ProductState.UNCRAFTED, this.currentBakingProduct);
        this.getOwnBuilding().addToTasks(ProductState.RAW, this.currentBakingProduct);
        return this.getState();
    }

    private IAIState bake() {
        BuildingBaker building = this.getOwnBuilding();
        if (this.currentFurnace == null || building.getFurnacesWithProduct().get(this.currentFurnace) != null) {
            return AIWorkerState.PREPARING;
        }
        if (this.walkToBlock(this.currentFurnace)) {
            return AIWorkerState.BAKER_BAKING;
        }
        IBlockState furnace = this.world.func_180495_p(this.currentFurnace);
        List<BakingProduct> bakingProducts = building.getTasks().get((Object)ProductState.PREPARED);
        if (!(furnace.func_177230_c() instanceof BlockFurnace)) {
            if (bakingProducts.isEmpty()) {
                building.removeFromTasks(ProductState.PREPARED, null);
            } else {
                building.removeFromFurnaces(this.currentFurnace);
            }
            return AIWorkerState.START_WORKING;
        }
        if (bakingProducts.isEmpty()) {
            return AIWorkerState.START_WORKING;
        }
        BakingProduct bakingProduct = bakingProducts.get(0);
        building.removeFromTasks(ProductState.PREPARED, bakingProduct);
        if (bakingProduct != null && bakingProduct.getState() == ProductState.PREPARED) {
            building.putInFurnace(this.currentFurnace, bakingProduct);
            bakingProduct.nextState();
            this.world.func_175656_a(this.currentFurnace, Blocks.field_150470_am.func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, furnace.func_177229_b((IProperty)BlockFurnace.field_176447_a)));
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForBaking() {
        if (this.getOwnBuilding().getFurnaces().isEmpty()) {
            this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.baker.noFurnace", new Object[0]);
            return this.getState();
        }
        if (this.getOwnBuilding().getCopyOfAllowedItems().isEmpty()) {
            this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.baker.noRecipe", new Object[0]);
            return this.getState();
        }
        boolean emptyFurnace = false;
        for (Map.Entry<BlockPos, BakingProduct> entry : this.getOwnBuilding().getFurnacesWithProduct().entrySet()) {
            if (entry.getValue() == null) {
                emptyFurnace = true;
                this.currentFurnace = entry.getKey();
                continue;
            }
            if (entry.getValue().getState() != ProductState.BAKED) continue;
            this.currentFurnace = entry.getKey();
            return AIWorkerState.BAKER_TAKE_OUT_OF_OVEN;
        }
        Map<ProductState, List<BakingProduct>> map = this.getOwnBuilding().getTasks();
        if (map.isEmpty()) {
            return AIWorkerState.BAKER_KNEADING;
        }
        if (map.containsKey((Object)ProductState.BAKED)) {
            return AIWorkerState.BAKER_FINISHING;
        }
        if (emptyFurnace) {
            return EntityAIWorkBaker.handleEmptyFurnace(map);
        }
        return AIWorkerState.BAKER_KNEADING;
    }

    private static IAIState handleEmptyFurnace(Map<ProductState, List<BakingProduct>> map) {
        if (map.containsKey((Object)ProductState.PREPARED) && !map.get((Object)ProductState.PREPARED).isEmpty()) {
            return AIWorkerState.BAKER_BAKING;
        }
        return AIWorkerState.BAKER_KNEADING;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    @Nullable
    public EntityCitizen getCitizen() {
        return this.worker;
    }
}

