/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.ldtteam.structurize.blocks.schematic.BlockSolidSubstitution;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.StructurePlacementUtils;
import com.minecolonies.api.compatibility.candb.ChiselAndBitsCheck;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.entity.ai.util.StructureIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructureWithWorkOrder<J extends AbstractJobStructure>
extends AbstractEntityAIStructure<J> {
    public AbstractEntityAIStructureWithWorkOrder(@NotNull J job) {
        super(job);
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return AbstractBuildingStructureBuilder.class;
    }

    @Override
    public void storeProgressPos(BlockPos blockPos, StructureIterator.Stage stage) {
        this.getOwnBuilding(AbstractBuildingStructureBuilder.class).setProgressPos(blockPos, stage);
    }

    @Override
    public Tuple<BlockPos, StructureIterator.Stage> getProgressPos() {
        return this.getOwnBuilding(AbstractBuildingStructureBuilder.class).getProgress();
    }

    public void initiate() {
        if (!((AbstractJobStructure)this.job).hasStructure()) {
            this.loadStructure();
            WorkOrderBuildDecoration wo = ((AbstractJobStructure)this.job).getWorkOrder();
            if (wo == null) {
                Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing work order(%d)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()));
                return;
            }
            if (wo instanceof WorkOrderBuildBuilding) {
                AbstractBuilding building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), wo.getBuildingLocation()));
                    return;
                }
                this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messageBuildStart", ((AbstractJobStructure)this.job).getStructure().getBluePrint().getName());
                if (building.getBuildingLevel() > 0) {
                    wo.setCleared(true);
                }
            } else if (!(wo instanceof WorkOrderBuildMiner)) {
                this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messageBuildStart", wo.getName());
            }
        }
    }

    private void loadStructure() {
        WorkOrderBuildDecoration workOrder = ((AbstractJobStructure)this.job).getWorkOrder();
        if (workOrder == null) {
            return;
        }
        BlockPos pos = workOrder.getBuildingLocation();
        if (workOrder instanceof WorkOrderBuildBuilding && this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(pos) == null) {
            Log.getLogger().warn("AbstractBuilding does not exist - removing build request");
            this.worker.getCitizenColonyHandler().getColony().getWorkManager().removeWorkOrder(workOrder);
            return;
        }
        int tempRotation = workOrder.getRotation(this.world);
        boolean removal = workOrder instanceof WorkOrderBuildRemoval;
        super.loadStructure(workOrder.getStructureName(), tempRotation, pos, workOrder.isMirrored(), removal);
        workOrder.setCleared(false);
        workOrder.setRequested(false);
        this.requestMaterialsState();
        if (this.getProgressPos() != null) {
            ((AbstractJobStructure)this.job).getStructure().setLocalPosition((BlockPos)this.getProgressPos().func_76341_a());
        }
    }

    private void requestMaterialsState() {
        if (Configurations.gameplay.builderInfiniteResources || ((AbstractJobStructure)this.job).getWorkOrder().isRequested() || ((AbstractJobStructure)this.job).getWorkOrder() instanceof WorkOrderBuildRemoval) {
            return;
        }
        this.requestMaterials();
        AbstractBuildingStructureBuilder buildingWorker = this.getOwnBuilding(AbstractBuildingStructureBuilder.class);
        ((AbstractJobStructure)this.job).getWorkOrder().setRequested(true);
        if (((AbstractJobStructure)this.job).getWorkOrder().getAmountOfRes() == 0) {
            ((AbstractJobStructure)this.job).getWorkOrder().setAmountOfRes(buildingWorker.getNeededResources().values().stream().mapToInt(ItemStorage::getAmount).sum());
        }
    }

    private void requestMaterials() {
        AbstractBuildingStructureBuilder buildingWorker = this.getOwnBuilding(AbstractBuildingStructureBuilder.class);
        buildingWorker.resetNeededResources();
        for (BlockInfo blockInfo : ((AbstractJobStructure)this.job).getStructure().getBluePrint().getBlockInfoAsList()) {
            IBlockState downState;
            if (blockInfo == null) continue;
            BlockPos worldPos = blockInfo.getPos().func_177971_a((Vec3i)((AbstractJobStructure)this.job).getStructure().getOffsetPosition());
            IBlockState blockState = blockInfo.getState();
            Block block = blockState.func_177230_c();
            if (StructurePlacementUtils.isStructureBlockEqualWorldBlock((World)this.world, (BlockPos)worldPos, (IBlockState)blockState) || blockState.func_177230_c() instanceof BlockBed && ((BlockBed.EnumPartType)blockState.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.FOOT) || blockState.func_177230_c() instanceof BlockDoor && ((BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.UPPER) || blockState.func_177230_c() == Blocks.field_150350_a) continue;
            if (block instanceof BlockSolidSubstitution) {
                blockState = this.getSolidSubstitution(worldPos);
                block = blockState.func_177230_c();
            }
            if (block == Blocks.field_150349_c) {
                block = Blocks.field_150346_d;
            }
            Block worldBlock = BlockPosUtil.getBlock(this.world, ((AbstractJobStructure)this.job).getStructure().getBlockPosition());
            if (block instanceof BlockFalling && !(downState = BlockPosUtil.getBlockState(this.world, worldPos.func_177977_b())).func_185904_a().func_76220_a()) {
                this.requestBlockToBuildingIfRequired(buildingWorker, this.getSolidSubstitution(worldPos), blockInfo);
            }
            if (block == null || block == Blocks.field_150350_a || worldBlock == Blocks.field_150357_h || worldBlock instanceof AbstractBlockHut || AbstractEntityAIStructureWithWorkOrder.isBlockFree(block, 0)) continue;
            this.requestBlockToBuildingIfRequired(buildingWorker, blockState, blockInfo);
        }
        for (NBTTagCompound entityInfo : ((AbstractJobStructure)this.job).getStructure().getEntityData()) {
            if (entityInfo == null) continue;
            for (ItemStorage stack : ItemStackUtils.getListOfStackForEntityInfo(entityInfo, this.world, (Entity)this.worker)) {
                if (ItemStackUtils.isEmpty(stack.getItemStack()).booleanValue()) continue;
                buildingWorker.addNeededResource(stack.getItemStack(), 1);
            }
        }
    }

    private void requestBlockToBuildingIfRequired(AbstractBuildingStructureBuilder building, IBlockState blockState, BlockInfo blockInfo) {
        if (blockInfo.getTileEntityData() != null) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(this.getItemsFromTileEntity());
            for (ItemStack stack : itemList) {
                building.addNeededResource(stack, stack.func_190916_E());
            }
        }
        if (!ChiselAndBitsCheck.isChiselAndBitsBlock(blockState) && blockState.func_177230_c() != Blocks.field_150324_C && blockState.func_177230_c() != Blocks.field_180393_cK && blockState.func_177230_c() != Blocks.field_180394_cL) {
            building.addNeededResource(BlockUtils.getItemStackFromBlockState(blockState), 1);
        }
    }

    @Override
    public void registerBlockAsNeeded(ItemStack stack) {
        int hashCode;
        int n = hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        if (this.getOwnBuilding(AbstractBuildingStructureBuilder.class).getNeededResources().get(stack.func_77977_a() + ":" + stack.func_77952_i() + "-" + hashCode) == null) {
            this.getOwnBuilding(AbstractBuildingStructureBuilder.class).addNeededResource(stack, 1);
        }
    }

    @Override
    public int getTotalRequiredAmount(ItemStack deliveredItemStack) {
        if (ItemStackUtils.isEmpty(deliveredItemStack).booleanValue()) {
            return 0;
        }
        int hashCode = deliveredItemStack.func_77942_o() ? deliveredItemStack.func_77978_p().hashCode() : 0;
        BuildingBuilderResource resource = this.getOwnBuilding(AbstractBuildingStructureBuilder.class).getNeededResources().get(deliveredItemStack.func_77977_a() + ":" + deliveredItemStack.func_77952_i() + "-" + hashCode);
        if (resource != null) {
            return resource.getAmount();
        }
        return super.getTotalRequiredAmount(deliveredItemStack);
    }

    @Override
    public void executeSpecificCompleteActions() {
        if (((AbstractJobStructure)this.job).getStructure() == null && ((AbstractJobStructure)this.job).hasWorkOrder()) {
            ((AbstractJobStructure)this.job).complete();
        }
        if (((AbstractJobStructure)this.job).getStructure() == null) {
            return;
        }
        String structureName = ((AbstractJobStructure)this.job).getStructure().getBluePrint().getName();
        WorkOrderBuildDecoration wo = ((AbstractJobStructure)this.job).getWorkOrder();
        if (wo instanceof WorkOrderBuildBuilding) {
            this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messageBuildComplete", structureName);
        }
        if (wo == null) {
            Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Finished, but missing work order(%d)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()));
        } else {
            WorkOrderBuildBuilding woh;
            ((AbstractJobStructure)this.job).complete();
            WorkOrderBuildBuilding workOrderBuildBuilding = woh = wo instanceof WorkOrderBuildBuilding ? (WorkOrderBuildBuilding)wo : null;
            if (woh != null) {
                AbstractBuilding building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), woh.getBuildingLocation()));
                } else {
                    building.setBuildingLevel(woh.getUpgradeLevel());
                }
            }
        }
        this.getOwnBuilding(AbstractBuildingStructureBuilder.class).resetNeededResources();
        this.func_75251_c();
    }

    @Override
    public List<ItemStack> getItemsFromTileEntity() {
        if (((AbstractJobStructure)this.job).getStructure() != null && ((AbstractJobStructure)this.job).getStructure().getBlockInfo() != null && ((AbstractJobStructure)this.job).getStructure().getBlockInfo().getTileEntityData() != null) {
            return ItemStackUtils.getItemStacksOfTileEntity(((AbstractJobStructure)this.job).getStructure().getBlockInfo().getTileEntityData(), this.world);
        }
        return Collections.emptyList();
    }

    @Override
    public void reduceNeededResources(ItemStack stack) {
        this.getOwnBuilding(AbstractBuildingStructureBuilder.class).reduceNeededResource(stack, 1);
    }

    @Override
    protected boolean checkIfCanceled() {
        if (((AbstractJobStructure)this.job).getWorkOrder() == null && ((AbstractJobStructure)this.job).getStructure() != null) {
            super.func_75251_c();
            ((AbstractJobStructure)this.job).setStructure(null);
            ((AbstractJobStructure)this.job).setWorkOrder(null);
            this.resetCurrentStructure();
            this.getOwnBuilding(AbstractBuildingStructureBuilder.class).setProgressPos(null, StructureIterator.Stage.CLEAR);
            return true;
        }
        return ((AbstractJobStructure)this.job).getWorkOrder() != null && (!this.world.func_175726_f(((AbstractJobStructure)this.job).getWorkOrder().getBuildingLocation()).func_177410_o() || this.currentStructure != null && !this.world.func_175726_f(AbstractEntityAIStructureWithWorkOrder.incrementBlock(this.currentStructure.getCurrentBlockPosition(), new BlockPos(this.currentStructure.getWidth(), this.currentStructure.getLength(), this.currentStructure.getHeight()))).func_177410_o());
    }

    private static BlockPos incrementBlock(BlockPos pos, BlockPos size) {
        BlockPos.MutableBlockPos progressPos = new BlockPos.MutableBlockPos(pos);
        progressPos.func_181079_c(progressPos.func_177958_n() + 1, progressPos.func_177956_o(), progressPos.func_177952_p());
        if (progressPos.func_177958_n() == size.func_177958_n()) {
            progressPos.func_181079_c(0, progressPos.func_177956_o(), progressPos.func_177952_p() + 1);
            if (progressPos.func_177952_p() == size.func_177952_p()) {
                progressPos.func_181079_c(progressPos.func_177958_n(), progressPos.func_177956_o() + 1, 0);
                if (progressPos.func_177956_o() == size.func_177956_o()) {
                    return pos;
                }
            }
        }
        return progressPos;
    }

    @Override
    protected boolean isAlreadyCleared() {
        return ((AbstractJobStructure)this.job).getWorkOrder() != null && ((AbstractJobStructure)this.job).getWorkOrder().isCleared();
    }

    @Override
    protected void onStartWithoutStructure() {
        if (((AbstractJobStructure)this.job).getWorkOrder() != null) {
            this.loadStructure();
        }
    }

    @Override
    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return null;
        }
        int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        AbstractBuildingStructureBuilder buildingWorker = this.getOwnBuilding(AbstractBuildingStructureBuilder.class);
        BuildingBuilderResource resource = buildingWorker.getNeededResources().get(stack.func_77977_a() + ":" + stack.func_77952_i() + "-" + hashCode);
        if (resource == null) {
            this.requestMaterials();
            resource = buildingWorker.getNeededResources().get(stack.func_77977_a() + ":" + stack.func_77952_i() + "-" + hashCode);
        }
        if (resource == null) {
            return stack;
        }
        ItemStack resStack = new ItemStack(resource.getItem(), Math.min(64, resource.getAmount()), resource.getDamageValue());
        resStack.func_77982_d(resource.getItemStack().func_77978_p());
        return resStack;
    }

    @Override
    public void handleSpecificCancelActions() {
        ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getWorkManager().removeWorkOrder(((AbstractJobStructure)this.job).getWorkOrderId());
        ((AbstractJobStructure)this.job).setWorkOrder(null);
    }
}

