/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ChangeColonyOwnerCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "ownerchange";
    private static final String ADD_OFFICER_COLONY_COMMAND_SUGGESTED = "/mc colony addofficer colony: %d player: %s";

    public ChangeColonyOwnerCommand() {
        super(new String[0]);
    }

    public ChangeColonyOwnerCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <(Optional)Player>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        Colony colony = actionMenuState.getColonyForArgument("colony");
        EntityPlayerMP player = actionMenuState.getPlayerForArgument("player");
        this.executeShared(server, sender, colony, (EntityPlayer)player);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        Colony colony;
        String playerName;
        if (args.length < 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Please define a colony or player"));
            return;
        }
        int colonyId = ChangeColonyOwnerCommand.getIthArgument(args, 0, -1);
        if (colonyId == -1) {
            playerName = args[0];
            EntityPlayer player = sender.func_130014_f_().func_72924_a(playerName);
            Entity senderEntity = sender.func_174793_f();
            if (senderEntity == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Please define a colony or player"));
                return;
            }
            if (playerName == null || playerName.isEmpty() || player == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Can't find player to add"));
                return;
            }
            IColony colony2 = ColonyManager.getIColonyByOwner(sender.func_130014_f_(), player.func_110124_au());
            if (colony2 == null) {
                return;
            }
            colonyId = colony2.getID();
        }
        playerName = null;
        if (args.length >= 2) {
            playerName = args[1];
        }
        if ((colony = ColonyManager.getColonyByWorld(colonyId, (World)server.func_71218_a(sender.func_130014_f_().field_73011_w.getDimension()))) == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Couldn't find colony %d.", colonyId)));
            return;
        }
        if (playerName == null || playerName.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Can't find player to add"));
            return;
        }
        EntityPlayer player = sender.func_130014_f_().func_72924_a(playerName);
        this.executeShared(server, sender, colony, player);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, Colony colony, EntityPlayer player) throws CommandException {
        if (player == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Can't find player to add"));
            return;
        }
        if (!ChangeColonyOwnerCommand.isPlayerOpped(sender)) {
            return;
        }
        if (ColonyManager.getIColonyByOwner(sender.func_130014_f_(), player) != null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Player %s has a colony already.", player.func_70005_c_())));
            return;
        }
        colony.getPermissions().setOwner(player);
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Successfully switched Owner %s to colony %d", player.func_70005_c_(), colony.getID())));
        if (player.func_70005_c_().equals("[abandoned]")) {
            ITextComponent abandonButton = new TextComponentTranslation("tile.blockHutTownHall.addOfficerMessageLink", new Object[0]).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(ADD_OFFICER_COLONY_COMMAND_SUGGESTED, colony.getID(), sender.func_70005_c_()))));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("tile.blockHutTownHall.abandonAddOfficer", new Object[0]));
            sender.func_145747_a(abandonButton);
        }
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 || index == 1;
    }
}

