/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.Delivery;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeliveryRequestResolver
extends AbstractRequestResolver<Delivery> {
    public DeliveryRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public TypeToken<? extends Delivery> getRequestType() {
        return TypeToken.of(Delivery.class);
    }

    @Override
    public boolean canResolve(@NotNull IRequestManager manager, IRequest<? extends Delivery> requestToCheck) {
        if (manager.getColony().getWorld().field_72995_K) {
            return false;
        }
        Colony colony = (Colony)manager.getColony();
        CitizenData freeDeliveryMan = colony.getCitizenManager().getCitizens().stream().filter(citizenData -> citizenData.getCitizenEntity().map(entityCitizen -> ((Delivery)requestToCheck.getRequest()).getTarget().isReachableFromLocation(entityCitizen.getLocation())).orElse(false)).filter(c -> c.getJob() instanceof JobDeliveryman).findFirst().orElse(null);
        return freeDeliveryMan != null;
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends Delivery> request) {
        if (manager.getColony().getWorld().field_72995_K) {
            return null;
        }
        Colony colony = (Colony)manager.getColony();
        CitizenData freeDeliveryMan = colony.getCitizenManager().getCitizens().stream().filter(citizenData -> citizenData.getCitizenEntity().map(entityCitizen -> ((Delivery)request.getRequest()).getTarget().isReachableFromLocation(entityCitizen.getLocation())).orElse(false)).filter(c -> c.getJob() instanceof JobDeliveryman).min(Comparator.comparing(c -> ((JobDeliveryman)c.getJob()).getTaskQueue().size()).thenComparing(Comparator.comparing(c -> {
            BlockPos targetPos = ((Delivery)request.getRequest()).getTarget().getInDimensionLocation();
            BlockPos entityLocation = c.getCitizenEntity().get().getLocation().getInDimensionLocation();
            return BlockPosUtil.getDistanceSquared(targetPos, entityLocation);
        }))).orElse(null);
        if (freeDeliveryMan == null) {
            return null;
        }
        JobDeliveryman job = (JobDeliveryman)freeDeliveryMan.getJob();
        job.addRequest((IToken<?>)request.getToken());
        return Lists.newArrayList();
    }

    @Override
    public void resolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends Delivery> request) throws RuntimeException {
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends Delivery> completedRequest) {
        return null;
    }

    @Override
    @Nullable
    public IRequest<?> onRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends Delivery> request) {
        if (!manager.getColony().getWorld().field_72995_K) {
            Colony colony = (Colony)manager.getColony();
            CitizenData freeDeliveryMan = colony.getCitizenManager().getCitizens().stream().filter(c -> c.getJob() instanceof JobDeliveryman && ((JobDeliveryman)c.getJob()).getTaskQueue().contains(request.getToken())).findFirst().orElse(null);
            if (freeDeliveryMan == null) {
                MineColonies.getLogger().error("Parent cancellation of delivery request failed! Unknown request: " + request.getToken());
            } else {
                JobDeliveryman job = (JobDeliveryman)freeDeliveryMan.getJob();
                job.onTaskDeletion((IToken<?>)request.getToken());
            }
        }
        return null;
    }

    @Override
    public void onRequestBeingOverruled(@NotNull IRequestManager manager, @NotNull IRequest<? extends Delivery> request) {
        this.onRequestCancelled(manager, request);
    }

    @Override
    public void onRequestComplete(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
    }

    @Override
    public void onRequestCancelled(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        Log.getLogger().error("cancelled");
    }
}

