/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobArcherTraining;
import com.minecolonies.coremod.colony.jobs.JobBaker;
import com.minecolonies.coremod.colony.jobs.JobBlacksmith;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.jobs.JobChickenHerder;
import com.minecolonies.coremod.colony.jobs.JobCombatTraining;
import com.minecolonies.coremod.colony.jobs.JobComposter;
import com.minecolonies.coremod.colony.jobs.JobCook;
import com.minecolonies.coremod.colony.jobs.JobCowboy;
import com.minecolonies.coremod.colony.jobs.JobCrusher;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.colony.jobs.JobFisherman;
import com.minecolonies.coremod.colony.jobs.JobKnight;
import com.minecolonies.coremod.colony.jobs.JobLumberjack;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.jobs.JobPlaceholder;
import com.minecolonies.coremod.colony.jobs.JobRanger;
import com.minecolonies.coremod.colony.jobs.JobSawmill;
import com.minecolonies.coremod.colony.jobs.JobShepherd;
import com.minecolonies.coremod.colony.jobs.JobSifter;
import com.minecolonies.coremod.colony.jobs.JobSmelter;
import com.minecolonies.coremod.colony.jobs.JobStoneSmeltery;
import com.minecolonies.coremod.colony.jobs.JobStonemason;
import com.minecolonies.coremod.colony.jobs.JobStudent;
import com.minecolonies.coremod.colony.jobs.JobSwineHerder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobRegistry {
    public static final String TAG_TYPE = "type";
    private static final String MAPPING_PLACEHOLDER = "Placeholder";
    private static final String MAPPING_BUILDER = "Builder";
    private static final String MAPPING_DELIVERY = "Deliveryman";
    private static final String MAPPING_MINER = "Miner";
    private static final String MAPPING_LUMBERJACK = "Lumberjack";
    private static final String MAPPING_FARMER = "Farmer";
    private static final String MAPPING_FISHERMAN = "Fisherman";
    private static final String MAPPING_BAKER = "Baker";
    private static final String MAPPING_COOK = "Cook";
    private static final String MAPPING_SHEPHERD = "Shepherd";
    private static final String MAPPING_COWBOY = "Cowboy";
    private static final String MAPPING_SWINE_HERDER = "SwineHerder";
    private static final String MAPPING_CHICKEN_HERDER = "ChickenHerder";
    private static final String MAPPING_SMELTER = "Smelter";
    private static final String MAPPING_RANGER = "Ranger";
    private static final String MAPPING_KNIGHT = "Knight";
    private static final String MAPPING_COMPOSTER = "Composter";
    private static final String MAPPING_STUDENT = "Student";
    private static final String MAPPING_ARCHER = "ArcherTraining";
    private static final String MAPPING_COMBAT = "CombatTraining";
    private static final String MAPPING_SAWMILL = "Sawmill";
    private static final String MAPPING_BLACKSMITH = "Blacksmith";
    private static final String MAPPING_STONEMASON = "Stonemason";
    private static final String MAPPING_STONE_SMELTERY = "StoneSmeltery";
    private static final String MAPPING_CRUSHER = "Crusher";
    private static final String MAPPING_SIFTER = "Sifter";
    @NotNull
    private static final BiMap<String, Class<? extends AbstractJob>> nameToClassMap = HashBiMap.create();

    private JobRegistry() {
    }

    private static void addMapping(String name, @NotNull Class<? extends AbstractJob> jobClass) {
        if (nameToClassMap.containsKey((Object)name)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding Job class mapping");
        }
        try {
            if (jobClass.getDeclaredConstructor(CitizenData.class) != null) {
                nameToClassMap.put((Object)name, jobClass);
                nameToClassMap.inverse().put(jobClass, (Object)name);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding Job class mapping", exception);
        }
    }

    @Nullable
    public static AbstractJob createFromNBT(CitizenData citizen, @NotNull NBTTagCompound compound) {
        AbstractJob job = null;
        Class oclass = null;
        try {
            oclass = (Class)nameToClassMap.get((Object)compound.func_74779_i(TAG_TYPE));
            if (oclass != null) {
                Constructor constructor = oclass.getDeclaredConstructor(CitizenData.class);
                job = (AbstractJob)constructor.newInstance(citizen);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.getLogger().trace((Object)e);
        }
        if (job != null) {
            try {
                job.readFromNBT(compound);
            }
            catch (RuntimeException ex) {
                Log.getLogger().error(String.format("A Job %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.func_74779_i(TAG_TYPE), oclass.getName()), (Throwable)ex);
                job = null;
            }
        } else {
            Log.getLogger().warn(String.format("Unknown Job type '%s' or missing constructor of proper format.", compound.func_74779_i(TAG_TYPE)));
        }
        return job;
    }

    @NotNull
    public static Map<Class<? extends AbstractJob>, String> getClassToNameMap() {
        return nameToClassMap.inverse();
    }

    static {
        JobRegistry.addMapping(MAPPING_PLACEHOLDER, JobPlaceholder.class);
        JobRegistry.addMapping(MAPPING_BUILDER, JobBuilder.class);
        JobRegistry.addMapping(MAPPING_DELIVERY, JobDeliveryman.class);
        JobRegistry.addMapping(MAPPING_MINER, JobMiner.class);
        JobRegistry.addMapping(MAPPING_LUMBERJACK, JobLumberjack.class);
        JobRegistry.addMapping(MAPPING_FARMER, JobFarmer.class);
        JobRegistry.addMapping(MAPPING_FISHERMAN, JobFisherman.class);
        JobRegistry.addMapping(MAPPING_BAKER, JobBaker.class);
        JobRegistry.addMapping(MAPPING_COOK, JobCook.class);
        JobRegistry.addMapping(MAPPING_SHEPHERD, JobShepherd.class);
        JobRegistry.addMapping(MAPPING_COWBOY, JobCowboy.class);
        JobRegistry.addMapping(MAPPING_SWINE_HERDER, JobSwineHerder.class);
        JobRegistry.addMapping(MAPPING_CHICKEN_HERDER, JobChickenHerder.class);
        JobRegistry.addMapping(MAPPING_SMELTER, JobSmelter.class);
        JobRegistry.addMapping(MAPPING_RANGER, JobRanger.class);
        JobRegistry.addMapping(MAPPING_KNIGHT, JobKnight.class);
        JobRegistry.addMapping(MAPPING_COMPOSTER, JobComposter.class);
        JobRegistry.addMapping(MAPPING_STUDENT, JobStudent.class);
        JobRegistry.addMapping(MAPPING_ARCHER, JobArcherTraining.class);
        JobRegistry.addMapping(MAPPING_COMBAT, JobCombatTraining.class);
        JobRegistry.addMapping(MAPPING_SAWMILL, JobSawmill.class);
        JobRegistry.addMapping(MAPPING_BLACKSMITH, JobBlacksmith.class);
        JobRegistry.addMapping(MAPPING_STONEMASON, JobStonemason.class);
        JobRegistry.addMapping(MAPPING_STONE_SMELTERY, JobStoneSmeltery.class);
        JobRegistry.addMapping(MAPPING_CRUSHER, JobCrusher.class);
        JobRegistry.addMapping(MAPPING_SIFTER, JobSifter.class);
    }
}

