/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowTownHall;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.permissions.PermissionEvent;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingTownHall
extends AbstractBuilding {
    private static final String TOWN_HALL = "TownHall";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final LinkedList<PermissionEvent> permissionEvents = new LinkedList();

    public BuildingTownHall(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return TOWN_HALL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingTownhall);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeTownhallMax);
        }
    }

    public void addPermissionEvent(PermissionEvent event) {
        if (this.getBuildingLevel() >= 1 && !this.permissionEvents.contains(event)) {
            if (this.permissionEvents.size() >= 100) {
                this.permissionEvents.removeFirst();
            }
            this.permissionEvents.add(event);
            this.markDirty();
        }
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(Configurations.gameplay.canPlayerUseColonyTPCommand);
        buf.writeInt(this.permissionEvents.size());
        for (PermissionEvent event : this.permissionEvents) {
            event.serialize(buf);
        }
    }

    @Override
    public int getClaimRadius(int newLevel) {
        if (newLevel + 1 < Configurations.gameplay.minTownHallPadding) {
            return Configurations.gameplay.minTownHallPadding;
        }
        return newLevel + 1;
    }

    @Override
    public boolean canBeGathered() {
        return false;
    }

    public static class View
    extends AbstractBuildingView {
        private final List<PermissionEvent> permissionEvents = new LinkedList<PermissionEvent>();
        private boolean canPlayerUseTP = false;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowTownHall(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.canPlayerUseTP = buf.readBoolean();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.permissionEvents.add(new PermissionEvent(buf));
            }
        }

        public List<PermissionEvent> getPermissionEvents() {
            return new LinkedList<PermissionEvent>(this.permissionEvents);
        }

        public boolean canCanPlayerUseTP() {
            return this.canPlayerUseTP;
        }
    }
}

