/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.structurize.blocks.decorative.BlockShingle;
import com.ldtteam.structurize.blocks.decorative.BlockShingleSlab;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobSawmill;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class BuildingSawmill
extends AbstractBuildingCrafter {
    private static final String SAWMILL = "Sawmill";
    private static final double MIN_PERCENTAGE_TO_CRAFT = 0.75;

    public BuildingSawmill(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SAWMILL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobSawmill(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return SAWMILL;
    }

    @Override
    public boolean canRecipeBeAdded(IToken token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
        if (storage == null) {
            return false;
        }
        Item item = storage.getPrimaryOutput().func_77973_b();
        if (item instanceof ItemBlock && (((ItemBlock)item).func_179223_d() instanceof BlockShingle || ((ItemBlock)item).func_179223_d() instanceof BlockShingleSlab)) {
            return true;
        }
        double amountOfValidBlocks = 0.0;
        double blocks = 0.0;
        for (ItemStack stack : storage.getInput()) {
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                String name = OreDictionary.getOreName((int)id);
                if (name.contains("Wood")) {
                    amountOfValidBlocks += 1.0;
                    break;
                }
                if (!name.contains("ingot") && !name.contains("stone") && !name.contains("redstone") && !name.contains("string")) continue;
                return false;
            }
            blocks += 1.0;
        }
        return amountOfValidBlocks > 0.0 && amountOfValidBlocks / blocks > 0.75;
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingSawmill.SAWMILL);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.INTELLIGENCE;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.ENDURANCE;
        }
    }
}

