/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.client.gui.WindowHutComposter;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobComposter;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingComposter
extends AbstractFilterableListBuilding {
    private static final String COMPOSTER = "Composter";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_POS = "pos";
    private static final String TAG_BARRELS = "barrels";
    private static final String TAG_DIRT = "dirt";
    private boolean retrieveDirtFromCompostBin = false;
    private final List<BlockPos> barrels = new ArrayList<BlockPos>();

    public BuildingComposter(@NotNull Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> this.isAllowedItem("compostables", new ItemStorage((ItemStack)stack)), new Tuple((Object)Integer.MAX_VALUE, (Object)true));
    }

    public List<BlockPos> getBarrels() {
        return ImmutableList.copyOf(this.barrels);
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobComposter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return COMPOSTER;
    }

    @Override
    public String getSchematicName() {
        return COMPOSTER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block == ModBlocks.blockBarrel && !this.barrels.contains(pos)) {
            this.barrels.add(pos);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList compostBinTagList = new NBTTagList();
        for (BlockPos entry : this.barrels) {
            NBTTagCompound compostBinCompound = new NBTTagCompound();
            compostBinCompound.func_74782_a(TAG_POS, (NBTBase)NBTUtil.func_186859_a((BlockPos)entry));
            compostBinTagList.func_74742_a((NBTBase)compostBinCompound);
        }
        compound.func_74782_a(TAG_BARRELS, (NBTBase)compostBinTagList);
        compound.func_74757_a(TAG_DIRT, this.retrieveDirtFromCompostBin);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList compostBinTagList = compound.func_150295_c(TAG_BARRELS, 10);
        for (int i = 0; i < compostBinTagList.func_74745_c(); ++i) {
            this.barrels.add(NBTUtil.func_186861_c((NBTTagCompound)compostBinTagList.func_150305_b(i).func_74775_l(TAG_POS)));
        }
        if (compound.func_74764_b(TAG_DIRT)) {
            this.retrieveDirtFromCompostBin = compound.func_74767_n(TAG_DIRT);
        }
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.retrieveDirtFromCompostBin);
    }

    public boolean shouldRetrieveDirtFromCompostBin() {
        return this.retrieveDirtFromCompostBin;
    }

    public void setShouldRetrieveDirtFromCompostBin(boolean shouldRetrieveDirt) {
        this.retrieveDirtFromCompostBin = shouldRetrieveDirt;
        this.markDirty();
    }

    public static class View
    extends AbstractFilterableListsView {
        public boolean retrieveDirtFromCompostBin = false;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.retrieveDirtFromCompostBin = buf.readBoolean();
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutComposter(this);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.DEXTERITY;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }
    }
}

