/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutGuardTower;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.MobEntryView;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobKnight;
import com.minecolonies.coremod.colony.jobs.JobRanger;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.network.messages.GuardMobAttackListMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingGuards
extends AbstractBuildingWorker {
    private static final String NBT_TASK = "TASK";
    private static final String NBT_JOB = "job";
    private static final String NBT_ASSIGN = "assign";
    private static final String NBT_RETRIEVE = "retrieve";
    private static final String NBT_PATROL = "patrol";
    private static final String NBT_TIGHT_GROUPING = "tightGrouping";
    private static final String NBT_PATROL_TARGETS = "patrol targets";
    private static final String NBT_TARGET = "target";
    private static final String NBT_GUARD = "guard";
    private static final String NBT_MOBS = "mobs";
    private static final String NBT_MOB_VIEW = "mobview";
    public static final int PATROL_DISTANCE = 40;
    private static final int BONUS_HEALTH_PER_LEVEL = 2;
    private final AttributeModifier healthModConfig;
    private static final int VISION_RANGE_PER_LEVEL = 5;
    private boolean assignManually;
    private boolean retrieveOnLowHealth;
    private static final int ACHIEVEMENT_LEVEL = 1;
    private boolean patrolManually;
    private GuardTask task;
    private BlockPos guardPos;
    private GuardJob job;
    private List<BlockPos> patrolTargets;
    private List<MobEntryView> mobsToAttack;
    private EntityPlayer followPlayer;
    private boolean tightGrouping;

    public AbstractBuildingGuards(@NotNull Colony c, BlockPos l) {
        super(c, l);
        this.healthModConfig = new AttributeModifier("MinecoloniesGuardConfigHP", Configurations.gameplay.guardHealthMult - 1.0, 1);
        this.assignManually = false;
        this.retrieveOnLowHealth = false;
        this.patrolManually = false;
        this.task = GuardTask.GUARD;
        this.guardPos = this.getID();
        this.job = null;
        this.patrolTargets = new ArrayList<BlockPos>();
        this.mobsToAttack = new ArrayList<MobEntryView>();
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.BOW, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.doesItemServeAsWeapon(itemStack), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.CHEST, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.HEAD, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.LEGS, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.FEET, new Tuple((Object)1, (Object)true));
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.task = GuardTask.values()[compound.func_74762_e(NBT_TASK)];
        int jobId = compound.func_74762_e(NBT_JOB);
        this.job = jobId == -1 ? null : GuardJob.values()[jobId];
        this.assignManually = compound.func_74767_n(NBT_ASSIGN);
        this.retrieveOnLowHealth = compound.func_74767_n(NBT_RETRIEVE);
        this.patrolManually = compound.func_74767_n(NBT_PATROL);
        this.tightGrouping = compound.func_74764_b(NBT_TIGHT_GROUPING) ? compound.func_74767_n(NBT_TIGHT_GROUPING) : true;
        NBTTagList wayPointTagList = compound.func_150295_c(NBT_PATROL_TARGETS, 10);
        for (int i = 0; i < wayPointTagList.func_74745_c(); ++i) {
            NBTTagCompound blockAtPos = wayPointTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.readFromNBT(blockAtPos, NBT_TARGET);
            this.patrolTargets.add(pos);
        }
        NBTTagList mobsTagList = compound.func_150295_c(NBT_MOBS, 10);
        for (int i = 0; i < mobsTagList.func_74745_c(); ++i) {
            NBTTagCompound mobCompound = mobsTagList.func_150305_b(i);
            MobEntryView mobEntry = MobEntryView.readFromNBT(mobCompound, NBT_MOB_VIEW);
            if (mobEntry.getEntityEntry() == null) continue;
            this.mobsToAttack.add(mobEntry);
        }
        this.guardPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(NBT_GUARD));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a(NBT_TASK, this.task.ordinal());
        compound.func_74768_a(NBT_JOB, this.job == null ? -1 : this.job.ordinal());
        compound.func_74757_a(NBT_ASSIGN, this.assignManually);
        compound.func_74757_a(NBT_RETRIEVE, this.retrieveOnLowHealth);
        compound.func_74757_a(NBT_PATROL, this.patrolManually);
        compound.func_74757_a(NBT_TIGHT_GROUPING, this.tightGrouping);
        NBTTagList wayPointTagList = new NBTTagList();
        for (BlockPos pos : this.patrolTargets) {
            NBTTagCompound wayPointCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(wayPointCompound, NBT_TARGET, pos);
            wayPointTagList.func_74742_a((NBTBase)wayPointCompound);
        }
        compound.func_74782_a(NBT_PATROL_TARGETS, (NBTBase)wayPointTagList);
        NBTTagList mobsTagList = new NBTTagList();
        for (MobEntryView entry : this.mobsToAttack) {
            NBTTagCompound mobCompound = new NBTTagCompound();
            MobEntryView.writeToNBT(mobCompound, NBT_MOB_VIEW, entry);
            mobsTagList.func_74742_a((NBTBase)mobCompound);
        }
        compound.func_74782_a(NBT_MOBS, (NBTBase)mobsTagList);
        compound.func_74782_a(NBT_GUARD, (NBTBase)NBTUtil.func_186859_a((BlockPos)this.guardPos));
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.assignManually);
        buf.writeBoolean(this.retrieveOnLowHealth);
        buf.writeBoolean(this.patrolManually);
        buf.writeBoolean(this.tightGrouping);
        buf.writeInt(this.task.ordinal());
        buf.writeInt(this.job == null ? -1 : this.job.ordinal());
        buf.writeInt(this.patrolTargets.size());
        for (BlockPos pos : this.patrolTargets) {
            BlockPosUtil.writeToByteBuf(buf, pos);
        }
        if (this.mobsToAttack.isEmpty()) {
            this.mobsToAttack.addAll(this.calculateMobs());
        }
        buf.writeInt(this.mobsToAttack.size());
        for (MobEntryView entry : this.mobsToAttack) {
            MobEntryView.writeToByteBuf(buf, entry);
        }
        BlockPosUtil.writeToByteBuf(buf, this.guardPos);
        buf.writeInt(this.getAssignedCitizen().size());
        for (CitizenData citizen : this.getAssignedCitizen()) {
            buf.writeInt(citizen.getId());
        }
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return this.getJob().getGuardJob(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return this.getJob().jobName;
    }

    @Nullable
    public BlockPos getNextPatrolTarget(BlockPos currentPatrolTarget) {
        if (!this.patrolManually) {
            if (currentPatrolTarget == null) {
                return this.getLocation();
            }
            BlockPos pos = BlockPosUtil.getRandomPosition(this.getColony().getWorld(), currentPatrolTarget, this.getLocation());
            if (BlockPosUtil.getDistance2D(pos, this.getLocation()) > (long)this.getPatrolDistance()) {
                return this.getLocation();
            }
            return pos;
        }
        if (this.patrolTargets == null || this.patrolTargets.isEmpty()) {
            return null;
        }
        if (currentPatrolTarget == null) {
            return this.patrolTargets.get(0);
        }
        if (this.patrolTargets.contains(currentPatrolTarget)) {
            int index = this.patrolTargets.indexOf(currentPatrolTarget) + 1;
            if (index >= this.patrolTargets.size()) {
                index = 0;
            }
            return this.patrolTargets.get(index);
        }
        return this.patrolTargets.get(0);
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        this.getJob();
        if (this.getAssignedEntities() != null) {
            for (Optional<EntityCitizen> optCitizen : this.getAssignedEntities()) {
                if (!optCitizen.isPresent()) continue;
                optCitizen.get().removeHealthModifier("MinecoloniesGuardBuildingHP");
                AttributeModifier healthModBuildingHP = new AttributeModifier("MinecoloniesGuardBuildingHP", (double)this.getBonusHealth(), 0);
                optCitizen.get().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(healthModBuildingHP);
            }
        }
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingGuard);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeGuardMax);
        }
    }

    @Override
    public void removeCitizen(CitizenData citizen) {
        Optional<EntityCitizen> optCitizen;
        if (citizen != null && (optCitizen = citizen.getCitizenEntity()).isPresent()) {
            optCitizen.get().removeAllHealthModifiers();
            optCitizen.get().func_184201_a(EntityEquipmentSlot.CHEST, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EntityEquipmentSlot.FEET, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EntityEquipmentSlot.HEAD, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EntityEquipmentSlot.LEGS, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStackUtils.EMPTY);
        }
        this.colony.getCitizenManager().calculateMaxCitizens();
        super.removeCitizen(citizen);
    }

    @Override
    public boolean assignCitizen(CitizenData citizen) {
        if (super.assignCitizen(citizen) && citizen != null) {
            Optional<EntityCitizen> optCitizen = citizen.getCitizenEntity();
            if (optCitizen.isPresent()) {
                AttributeModifier healthModBuildingHP = new AttributeModifier("MinecoloniesGuardBuildingHP", (double)this.getBonusHealth(), 0);
                optCitizen.get().increaseHPForGuards();
                optCitizen.get().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(healthModBuildingHP);
                optCitizen.get().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.healthModConfig);
                optCitizen.get().func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(SharedMonsterAttributes.field_188791_g.func_111110_b() + (double)this.getDefenceBonus());
            }
            this.colony.getCitizenManager().calculateMaxCitizens();
            AbstractBuilding building = citizen.getHomeBuilding();
            if (building != null && !building.getID().equals((Object)this.getID())) {
                building.removeCitizen(citizen);
            }
            citizen.setHomeBuilding(this);
            return true;
        }
        return false;
    }

    public abstract int getDefenceBonus();

    public abstract int getOffenceBonus();

    public int getPatrolDistance() {
        return this.getBuildingLevel() * 40;
    }

    public GuardJob getJob() {
        if (this.job == null) {
            this.job = new Random().nextBoolean() ? GuardJob.KNIGHT : GuardJob.RANGER;
        }
        return this.job;
    }

    public void setJob(GuardJob job) {
        this.job = job;
        for (CitizenData citizen : this.getAssignedCitizen()) {
            citizen.setJob(this.createJob(citizen));
        }
        this.markDirty();
    }

    public GuardTask getTask() {
        return this.task;
    }

    public void setTask(GuardTask task) {
        this.task = task;
        this.markDirty();
    }

    public List<BlockPos> getPatrolTargets() {
        return new ArrayList<BlockPos>(this.patrolTargets);
    }

    public boolean shallRetrieveOnLowHealth() {
        return this.retrieveOnLowHealth;
    }

    public void setRetrieveOnLowHealth(boolean retrieve) {
        this.retrieveOnLowHealth = retrieve;
    }

    public boolean shallPatrolManually() {
        return this.patrolManually;
    }

    public void setPatrolManually(boolean patrolManually) {
        this.patrolManually = patrolManually;
    }

    public boolean shallAssignManually() {
        return this.assignManually;
    }

    public void setAssignManually(boolean assignManually) {
        this.assignManually = assignManually;
    }

    public boolean isTightGrouping() {
        return this.tightGrouping;
    }

    public void setTightGrouping(boolean tightGrouping) {
        this.tightGrouping = tightGrouping;
    }

    public BlockPos getGuardPos() {
        return this.guardPos;
    }

    public void setGuardPos(BlockPos guardPos) {
        this.guardPos = guardPos;
    }

    public List<MobEntryView> getMobsToAttack() {
        this.mobsToAttack.sort(Comparator.comparing(MobEntryView::getPriority, Comparator.reverseOrder()));
        return new ArrayList<MobEntryView>(this.mobsToAttack);
    }

    public void setMobsToAttack(List<MobEntryView> list) {
        this.mobsToAttack.clear();
        this.mobsToAttack = new ArrayList<MobEntryView>(list);
    }

    public EntityPlayer getFollowPlayer() {
        return this.followPlayer;
    }

    public BlockPos getPlayerToFollow() {
        if (this.task.equals((Object)GuardTask.FOLLOW) && this.followPlayer != null) {
            return this.followPlayer.func_180425_c();
        }
        this.task = GuardTask.GUARD;
        this.markDirty();
        return this.getLocation();
    }

    public void setPlayerToFollow(EntityPlayer player) {
        if (this.getColony().getWorld() != null) {
            this.getColony().getWorld().func_96441_U().func_151392_a(player.func_70005_c_(), "teamcolony" + this.getColony().getID());
            player.func_70690_d(new PotionEffect(Constants.GLOW_EFFECT, 12000, 20));
            if (this.followPlayer != null) {
                try {
                    this.getColony().getWorld().func_96441_U().func_96512_b(this.followPlayer.func_70005_c_(), this.getColony().getWorld().func_96441_U().func_96508_e("teamcolony" + this.getColony().getID()));
                    player.func_184589_d(Constants.GLOW_EFFECT);
                }
                catch (Exception e) {
                    Log.getLogger().warn("Unable to remove player " + this.followPlayer.func_70005_c_() + " from team " + "teamcolony" + this.getColony().getID());
                }
            }
        }
        this.followPlayer = player;
    }

    private int getBonusHealth() {
        return this.getBuildingLevel() * 2;
    }

    public void addPatrolTargets(BlockPos target) {
        this.patrolTargets.add(target);
        this.markDirty();
    }

    public void resetPatrolTargets() {
        this.patrolTargets = new ArrayList<BlockPos>();
        this.markDirty();
    }

    public int getBonusVision() {
        return this.getBuildingLevel() * 5;
    }

    public List<MobEntryView> calculateMobs() {
        ArrayList<MobEntryView> mobs = new ArrayList<MobEntryView>();
        int i = 0;
        for (EntityEntry entry : ForgeRegistries.ENTITIES.getValuesCollection()) {
            if (EntityMob.class.isAssignableFrom(entry.getEntityClass())) {
                mobs.add(new MobEntryView(entry.getRegistryName(), true, ++i));
                continue;
            }
            for (String location : Configurations.gameplay.guardResourceLocations) {
                if (entry.getRegistryName() == null || !entry.getRegistryName().toString().equals(location)) continue;
                mobs.add(new MobEntryView(entry.getRegistryName(), true, ++i));
            }
        }
        this.getColony().getPackageManager().getSubscribers().forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new GuardMobAttackListMessage(this.getColony().getID(), this.getID(), this.mobsToAttack), player));
        return mobs;
    }

    public static boolean checkIfGuardShouldTakeDamage(EntityCitizen citizen, EntityPlayer player) {
        AbstractBuildingWorker buildingWorker = citizen.getCitizenColonyHandler().getWorkBuilding();
        return !(buildingWorker instanceof AbstractBuildingGuards) || ((AbstractBuildingGuards)buildingWorker).task != GuardTask.FOLLOW || !player.equals((Object)((AbstractBuildingGuards)buildingWorker).followPlayer);
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private boolean assignManually = false;
        private boolean retrieveOnLowHealth = false;
        private boolean patrolManually = false;
        private GuardTask task = GuardTask.GUARD;
        private BlockPos guardPos = this.getID();
        private GuardJob job = null;
        private boolean tightGrouping = true;
        private List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
        private List<MobEntryView> mobsToAttack = new ArrayList<MobEntryView>();
        @NotNull
        private final List<Integer> guards = new ArrayList<Integer>();

        public View(ColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutGuardTower(this);
        }

        @NotNull
        public List<Integer> getGuards() {
            return Collections.unmodifiableList(this.guards);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.assignManually = buf.readBoolean();
            this.retrieveOnLowHealth = buf.readBoolean();
            this.patrolManually = buf.readBoolean();
            this.tightGrouping = buf.readBoolean();
            this.task = GuardTask.values()[buf.readInt()];
            int jobId = buf.readInt();
            this.job = jobId == -1 ? null : GuardJob.values()[jobId];
            int targetSize = buf.readInt();
            this.patrolTargets = new ArrayList<BlockPos>();
            for (int i = 0; i < targetSize; ++i) {
                this.patrolTargets.add(BlockPosUtil.readFromByteBuf(buf));
            }
            int mobSize = buf.readInt();
            for (int i = 0; i < mobSize; ++i) {
                MobEntryView mobEntry = MobEntryView.readFromByteBuf(buf);
                this.mobsToAttack.add(mobEntry);
            }
            this.guardPos = BlockPosUtil.readFromByteBuf(buf);
            int numResidents = buf.readInt();
            for (int i = 0; i < numResidents; ++i) {
                this.guards.add(buf.readInt());
            }
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            if (GuardJob.KNIGHT.equals((Object)this.job)) {
                return AbstractBuildingWorker.Skill.STRENGTH;
            }
            return AbstractBuildingWorker.Skill.INTELLIGENCE;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            if (GuardJob.KNIGHT.equals((Object)this.job)) {
                return AbstractBuildingWorker.Skill.ENDURANCE;
            }
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        public void setAssignManually(boolean assignManually) {
            this.assignManually = assignManually;
        }

        public boolean isAssignManually() {
            return this.assignManually;
        }

        public void setRetrieveOnLowHealth(boolean retrieveOnLowHealth) {
            this.retrieveOnLowHealth = retrieveOnLowHealth;
        }

        public boolean isRetrieveOnLowHealth() {
            return this.retrieveOnLowHealth;
        }

        public void setTightGrouping(boolean tightGrouping) {
            this.tightGrouping = tightGrouping;
        }

        public boolean isTightGrouping() {
            return this.tightGrouping;
        }

        public void setPatrolManually(boolean patrolManually) {
            this.patrolManually = patrolManually;
        }

        public void setMobsToAttack(List<MobEntryView> mobsToAttack) {
            this.mobsToAttack = new ArrayList<MobEntryView>(mobsToAttack);
        }

        public boolean isPatrolManually() {
            return this.patrolManually;
        }

        public void setTask(GuardTask task) {
            this.task = task;
            this.getColony().markDirty();
        }

        public GuardTask getTask() {
            return this.task;
        }

        public BlockPos getGuardPos() {
            return this.guardPos;
        }

        public void setJob(GuardJob job) {
            this.job = job;
        }

        public GuardJob getJob() {
            return this.job;
        }

        public List<BlockPos> getPatrolTargets() {
            return new ArrayList<BlockPos>(this.patrolTargets);
        }

        public List<MobEntryView> getMobsToAttack() {
            return new ArrayList<MobEntryView>(this.mobsToAttack);
        }
    }

    public static enum GuardJob {
        RANGER("com.minecolonies.coremod.job.Ranger", "com.minecolonies.coremod.gui.workerHuts.ranger"),
        KNIGHT("com.minecolonies.coremod.job.Knight", "com.minecolonies.coremod.gui.workerHuts.knight");

        public final String jobName;
        public final String buttonName;

        private GuardJob(String name, String buttonName) {
            this.jobName = name;
            this.buttonName = buttonName;
        }

        public AbstractJobGuard getGuardJob(CitizenData citizen) {
            if (this == RANGER) {
                return new JobRanger(citizen);
            }
            if (this == KNIGHT) {
                return new JobKnight(citizen);
            }
            return new JobRanger(citizen);
        }
    }
}

