/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.FireworkUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.registry.BuildingRegistry;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.ProviderHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.RequestHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.ResolverHandler;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.util.ChunkDataHelper;
import com.minecolonies.coremod.util.ColonyUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuilding
extends AbstractBuildingContainer
implements IRequestResolverProvider,
IRequester {
    @NotNull
    private IToken<?> rsDataStoreToken;
    private IRequester requester = (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
    private boolean beingGathered = false;
    private boolean isBuilt = false;
    private String customName = "";

    protected AbstractBuilding(@NotNull Colony colony, BlockPos pos) {
        super(pos, colony);
        this.setupRsDataStore();
    }

    @NotNull
    public String getCustomBuildingName() {
        return this.customName;
    }

    public void onWakeUp() {
    }

    public void onCleanUp(CitizenData citizen) {
    }

    public void onRestart(CitizenData citizen) {
        citizen.setPaused(false);
    }

    public void onPlacement() {
        if (Configurations.gameplay.enableDynamicColonySizes) {
            ChunkDataHelper.claimColonyChunks(this.colony.getWorld(), true, this.colony.getID(), this.getLocation(), this.colony.getDimension(), this.getClaimRadius(this.getBuildingLevel()));
        }
    }

    public boolean isMatchingBlock(@NotNull Block block) {
        Class<?> c = BuildingRegistry.getBlockClassToBuildingClassMap().get(block.getClass());
        return this.getClass().equals(c);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.loadRequestSystemFromNBT(compound);
        if (compound.func_74764_b("isBuilt")) {
            this.isBuilt = compound.func_74767_n("isBuilt");
        } else if (this.getBuildingLevel() > 0) {
            this.isBuilt = true;
        }
        if (compound.func_74764_b("customName")) {
            this.customName = compound.func_74779_i("customName");
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        this.writeRequestSystemToNBT(compound);
        compound.func_74757_a("isBuilt", this.isBuilt);
        compound.func_74778_a("customName", this.customName);
    }

    public final void destroy() {
        this.onDestroyed();
        this.colony.getBuildingManager().removeBuilding(this, this.colony.getPackageManager().getSubscribers());
    }

    @Override
    public void onDestroyed() {
        TileEntityColonyBuilding tileEntityNew = this.getTileEntity();
        World world = this.colony.getWorld();
        Block block = world.func_180495_p(this.getLocation()).func_177230_c();
        if (tileEntityNew != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)this.getLocation(), (IInventory)tileEntityNew);
            world.func_175666_e(this.getLocation(), block);
        }
        if (Configurations.gameplay.enableDynamicColonySizes) {
            ChunkDataHelper.claimColonyChunks(world, false, this.colony.getID(), this.getID(), this.colony.getDimension(), this.getClaimRadius(this.getBuildingLevel()));
        }
        ConstructionTapeHelper.removeConstructionTape(this.getCorners(), world);
    }

    public void secondsWorldTick(@NotNull TickEvent.WorldTickEvent event) {
    }

    protected void requestWorkOrder(int level, BlockPos builder) {
        for (WorkOrderBuildBuilding o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildBuilding.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            return;
        }
        WorkOrderBuildBuilding workOrderBuildBuilding = new WorkOrderBuildBuilding(this, level);
        if (!this.canBeBuiltByBuilder(level) && !workOrderBuildBuilding.canBeResolved(this.colony, level)) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "entity.builder.messageBuilderNecessary", Integer.toString(level));
            return;
        }
        if (workOrderBuildBuilding.tooFarFromAnyBuilder(this.colony, level) && builder.equals((Object)BlockPos.field_177992_a)) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "entity.builder.messageBuildersTooFar", new Object[0]);
            return;
        }
        if (this.getLocation().func_177956_o() + this.getHeight() >= 256) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "entity.builder.messageBuildTooHigh", new Object[0]);
            return;
        }
        if (this.getLocation().func_177956_o() <= 1) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "entity.builder.messageBuildTooLow", new Object[0]);
            return;
        }
        if (!builder.equals((Object)BlockPos.field_177992_a)) {
            AbstractBuilding building = this.colony.getBuildingManager().getBuilding(builder);
            if (building instanceof AbstractBuildingStructureBuilder && (building.getBuildingLevel() >= level || this.canBeBuiltByBuilder(level))) {
                workOrderBuildBuilding.setClaimedBy(builder);
            } else {
                LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "entity.builder.messageBuilderNecessary", Integer.toString(level));
                return;
            }
        }
        this.colony.getWorkManager().addWorkOrder(workOrderBuildBuilding, false);
        this.colony.getProgressManager().progressWorkOrderPlacement(workOrderBuildBuilding);
        LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.workOrderAdded", new Object[0]);
        this.markDirty();
    }

    public boolean canBeBuiltByBuilder(int newLevel) {
        return false;
    }

    @Override
    public final void markDirty() {
        super.markDirty();
        if (this.colony != null) {
            this.colony.getBuildingManager().markBuildingsDirty();
        }
    }

    public boolean hasWorkOrder() {
        return this.getCurrentWorkOrderLevel() != 0;
    }

    private int getCurrentWorkOrderLevel() {
        for (WorkOrderBuildBuilding o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildBuilding.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            return o.getUpgradeLevel();
        }
        return 0;
    }

    public void removeWorkOrder() {
        for (WorkOrderBuildBuilding o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildBuilding.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            this.colony.getWorkManager().removeWorkOrder(o.getID());
            this.markDirty();
            BlockPos buildingPos = o.getClaimedBy();
            AbstractBuilding building = this.colony.getBuildingManager().getBuilding(buildingPos);
            if (building != null && building.getMainCitizen() != null) {
                building.cancelAllRequestsOfCitizen(building.getMainCitizen());
            }
            return;
        }
    }

    public int getClaimRadius(int newLevel) {
        switch (newLevel) {
            case 3: {
                return 1;
            }
            case 5: {
                return 2;
            }
        }
        return 0;
    }

    public void serializeToView(@NotNull ByteBuf buf) {
        buf.writeInt(this.getClass().getName().hashCode());
        buf.writeInt(this.getBuildingLevel());
        buf.writeInt(this.getMaxBuildingLevel());
        buf.writeInt(this.getPickUpPriority());
        buf.writeBoolean(this.isPriorityStatic());
        buf.writeInt(this.getCurrentWorkOrderLevel());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getStyle());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getSchematicName());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getCustomBuildingName());
        buf.writeInt(this.getRotation());
        buf.writeBoolean(this.isMirrored());
        buf.writeInt(this.getClaimRadius(this.getBuildingLevel()));
        NBTTagCompound requestSystemCompound = new NBTTagCompound();
        this.writeRequestSystemToNBT(requestSystemCompound);
        ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
        buf.writeInt(resolvers.size());
        for (IRequestResolver resolver : resolvers) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)StandardFactoryController.getInstance().serialize(resolver.getRequesterId()));
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)StandardFactoryController.getInstance().serialize(this.getRequesterId()));
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)requestSystemCompound);
    }

    public boolean isBeingGathered() {
        return this.beingGathered;
    }

    public void setCustomBuildingName(String name) {
        this.customName = name;
        this.markDirty();
    }

    public boolean canBeGathered() {
        return true;
    }

    public void setBeingGathered(boolean gathering) {
        this.beingGathered = gathering;
    }

    public void requestUpgrade(EntityPlayer player, BlockPos builder) {
        if (this.getBuildingLevel() < this.getMaxBuildingLevel()) {
            this.requestWorkOrder(this.getBuildingLevel() + 1, builder);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.worker.noUpgrade", new Object[0]));
        }
    }

    public void requestRepair(BlockPos builder) {
        if (this.getBuildingLevel() > 0) {
            this.requestWorkOrder(this.getBuildingLevel(), builder);
        }
    }

    public boolean isBuilt() {
        return this.isBuilt;
    }

    public void deconstruct() {
        Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> tuple = this.getCorners();
        for (int x = ((Integer)((Tuple)tuple.func_76341_a()).func_76341_a()).intValue(); x < (Integer)((Tuple)tuple.func_76341_a()).func_76340_b(); ++x) {
            for (int z = ((Integer)((Tuple)tuple.func_76340_b()).func_76341_a()).intValue(); z < (Integer)((Tuple)tuple.func_76340_b()).func_76340_b(); ++z) {
                for (int y = this.getLocation().func_177956_o() - 1; y < this.getLocation().func_177956_o() + this.getHeight(); ++y) {
                    this.getColony().getWorld().func_175655_b(new BlockPos(x, y, z), false);
                }
            }
        }
    }

    public void onUpgradeComplete(int newLevel) {
        if (Configurations.gameplay.enableDynamicColonySizes) {
            ChunkDataHelper.claimColonyChunks(this.colony.getWorld(), true, this.colony.getID(), this.getID(), this.colony.getDimension(), this.getClaimRadius(newLevel));
        }
        ConstructionTapeHelper.removeConstructionTape(this.getCorners(), this.colony.getWorld());
        this.colony.getProgressManager().progressBuildBuilding(this, this.colony.getBuildingManager().getBuildings().values().stream().filter(building -> building instanceof AbstractBuildingWorker).mapToInt(AbstractSchematicProvider::getBuildingLevel).sum(), this.colony.getBuildingManager().getBuildings().values().stream().filter(building -> building instanceof BuildingHome).mapToInt(AbstractSchematicProvider::getBuildingLevel).sum());
        WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(this, newLevel);
        Structure wrapper = new Structure(this.colony.getWorld(), workOrder.getStructureName(), new PlacementSettings());
        Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(this.getLocation(), this.colony.getWorld(), wrapper, workOrder.getRotation(this.colony.getWorld()), workOrder.isMirrored());
        this.setHeight(wrapper.getHeight());
        this.setCorners((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
        this.isBuilt = true;
        if (newLevel > this.getBuildingLevel()) {
            FireworkUtils.spawnFireworksAtAABBCorners(this.getTargetableArea(this.colony.getWorld()), this.colony.getWorld(), newLevel);
        }
    }

    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory) {
        for (Map.Entry<Predicate<ItemStack>, Tuple<Integer, Boolean>> entry : this.getRequiredItemsAndAmount().entrySet()) {
            if (inventory && !((Boolean)entry.getValue().func_76340_b()).booleanValue() || !entry.getKey().test(stack)) continue;
            ItemStorage kept = ItemStorage.getItemStackOfListMatchingPredicate(localAlreadyKept, entry.getKey());
            int toKeep = (Integer)entry.getValue().func_76341_a();
            int rest = stack.func_190916_E() - toKeep;
            if (kept != null) {
                if (kept.getAmount() >= toKeep) {
                    return stack.func_190916_E();
                }
                rest = kept.getAmount() + stack.func_190916_E() - toKeep;
                localAlreadyKept.remove(kept);
                kept.setAmount(kept.getAmount() + ItemStackUtils.getSize(stack) - Math.max(0, rest));
                localAlreadyKept.add(kept);
            } else {
                ItemStorage newStorage = new ItemStorage(stack);
                newStorage.setAmount(ItemStackUtils.getSize(stack) - Math.max(0, rest));
                localAlreadyKept.add(newStorage);
            }
            if (rest <= 0) {
                return 0;
            }
            return Math.min(rest, ItemStackUtils.getSize(stack));
        }
        return stack.func_190916_E();
    }

    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(this.keepX);
        IRequestManager manager = this.colony.getRequestManager();
        toKeep.put(stack -> this.getOpenRequestsByCitizen().values().stream().anyMatch(list -> list.stream().filter(token -> manager.getRequestForToken((IToken<?>)token) != null).anyMatch(token -> manager.getRequestForToken((IToken<?>)token).getRequest() instanceof IDeliverable && ((IDeliverable)manager.getRequestForToken((IToken<?>)token).getRequest()).matches((ItemStack)stack))), new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        return toKeep;
    }

    @Nullable
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        if (this.getTileEntity() == null) {
            for (BlockPos pos : this.containerList) {
                TileEntity tempTileEntity = world.func_175625_s(pos);
                if (!(tempTileEntity instanceof TileEntityChest) || InventoryUtils.isProviderFull((ICapabilityProvider)tempTileEntity)) continue;
                return this.forceItemStackToProvider((ICapabilityProvider)tempTileEntity, stack);
            }
        } else {
            return this.forceItemStackToProvider((ICapabilityProvider)this.getTileEntity(), stack);
        }
        return stack;
    }

    @Nullable
    private ItemStack forceItemStackToProvider(@NotNull ICapabilityProvider provider, @NotNull ItemStack itemStack) {
        ArrayList localAlreadyKept = new ArrayList();
        return InventoryUtils.forceItemStackToProvider(provider, itemStack, stack -> EntityAIWorkDeliveryman.workerRequiresItem(this, stack, localAlreadyKept) != stack.func_190916_E());
    }

    protected void writeRequestSystemToNBT(NBTTagCompound compound) {
        compound.func_74782_a("DataStoreToken", (NBTBase)StandardFactoryController.getInstance().serialize(this.rsDataStoreToken));
    }

    protected void setupRsDataStore() {
        this.rsDataStoreToken = this.colony.getRequestManager().getDataStoreManager().get(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE).getId();
    }

    private void loadRequestSystemFromNBT(NBTTagCompound compound) {
        this.requester = compound.func_74764_b("Requestor") ? (IRequester)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("Requestor")) : (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
        if (compound.func_74764_b("DataStoreToken")) {
            this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
        } else {
            this.setupRsDataStore();
        }
    }

    private IRequestSystemBuildingDataStore getDataStore() {
        return this.colony.getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE);
    }

    private Map<TypeToken<?>, Collection<IToken<?>>> getOpenRequestsByRequestableType() {
        return this.getDataStore().getOpenRequestsByRequestableType();
    }

    protected Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.getDataStore().getOpenRequestsByCitizen();
    }

    private Map<Integer, Collection<IToken<?>>> getCompletedRequestsByCitizen() {
        return this.getDataStore().getCompletedRequestsByCitizen();
    }

    private Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.getDataStore().getCitizensByRequest();
    }

    public <R extends IRequestable> IToken<?> createRequest(@NotNull CitizenData citizenData, @NotNull R requested, boolean async) {
        IToken<?> requestToken = this.colony.getRequestManager().createRequest(this.requester, requested);
        if (async) {
            citizenData.getJob().getAsyncRequests().add(requestToken);
        }
        this.addRequestToMaps(citizenData.getId(), requestToken, TypeToken.of(requested.getClass()));
        this.colony.getRequestManager().assignRequest(requestToken);
        this.markDirty();
        return requestToken;
    }

    public <R extends IRequestable> IToken<?> createRequest(@NotNull R requested, boolean async) {
        IToken<?> requestToken = this.colony.getRequestManager().createRequest(this.requester, requested);
        this.addRequestToMaps(-1, requestToken, TypeToken.of(requested.getClass()));
        this.colony.getRequestManager().assignRequest(requestToken);
        this.markDirty();
        return requestToken;
    }

    private void addRequestToMaps(@NotNull Integer citizenId, @NotNull IToken requestToken, @NotNull TypeToken requested) {
        if (!this.getOpenRequestsByRequestableType().containsKey(requested)) {
            this.getOpenRequestsByRequestableType().put(requested, new ArrayList());
        }
        this.getOpenRequestsByRequestableType().get(requested).add(requestToken);
        this.getCitizensByRequest().put(requestToken, citizenId);
        if (!this.getOpenRequestsByCitizen().containsKey(citizenId)) {
            this.getOpenRequestsByCitizen().put(citizenId, new ArrayList());
        }
        this.getOpenRequestsByCitizen().get(citizenId).add(requestToken);
    }

    public boolean hasWorkerOpenRequests(@NotNull CitizenData citizen) {
        return !this.getOpenRequests(citizen).isEmpty();
    }

    public ImmutableList<IRequest> getOpenRequests(@NotNull CitizenData data) {
        if (!this.getOpenRequestsByCitizen().containsKey(data.getId())) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.getOpenRequestsByCitizen().get(data.getId()).stream().map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    public boolean hasWorkerOpenRequestsFiltered(@NotNull CitizenData citizen, @NotNull Predicate<IRequest> selectionPredicate) {
        return this.getOpenRequests(citizen).stream().anyMatch(selectionPredicate);
    }

    public <R> boolean hasWorkerOpenRequestsOfType(@NotNull CitizenData citizenData, TypeToken<R> requestType) {
        return !this.getOpenRequestsOfType(citizenData, requestType).isEmpty();
    }

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull CitizenData citizenData, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(requestType);
        }).map(request -> request).iterator());
    }

    public boolean hasCitizenCompletedRequests(@NotNull CitizenData data) {
        return !this.getCompletedRequests(data).isEmpty();
    }

    public ImmutableList<IRequest> getCompletedRequests(@NotNull CitizenData data) {
        if (!this.getCompletedRequestsByCitizen().containsKey(data.getId())) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.getCompletedRequestsByCitizen().get(data.getId()).stream().map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfType(@NotNull CitizenData citizenData, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(requestType);
        }).map(request -> request).iterator());
    }

    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfTypeFiltered(@NotNull CitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(requestType);
        }).map(request -> request).filter(filter).iterator());
    }

    public void markRequestAsAccepted(@NotNull CitizenData data, @NotNull IToken<?> token) {
        if (!this.getCompletedRequestsByCitizen().containsKey(data.getId()) || !this.getCompletedRequestsByCitizen().get(data.getId()).contains(token)) {
            throw new IllegalArgumentException("The given token " + token + " is not known as a completed request waiting for acceptance by the citizen.");
        }
        this.getCompletedRequestsByCitizen().get(data.getId()).remove(token);
        if (this.getCompletedRequestsByCitizen().get(data.getId()).isEmpty()) {
            this.getCompletedRequestsByCitizen().remove(data.getId());
        }
        this.getColony().getRequestManager().updateRequestState(token, RequestState.RECEIVED);
        this.markDirty();
    }

    public void cancelAllRequestsOfCitizen(@NotNull CitizenData data) {
        this.getOpenRequests(data).forEach(request -> {
            this.getColony().getRequestManager().updateRequestState((IToken<?>)request.getToken(), RequestState.CANCELLED);
            if (this.getOpenRequestsByRequestableType().containsKey(TypeToken.of(request.getRequest().getClass()))) {
                this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getToken());
                if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
                    this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
                }
            }
            this.getCitizensByRequest().remove(request.getToken());
        });
        this.getCompletedRequests(data).forEach(request -> this.getColony().getRequestManager().updateRequestState((IToken<?>)request.getToken(), RequestState.RECEIVED));
        if (this.getOpenRequestsByCitizen().containsKey(data.getId())) {
            this.getOpenRequestsByCitizen().remove(data.getId());
        }
        if (this.getCompletedRequestsByCitizen().containsKey(data.getId())) {
            this.getCompletedRequestsByCitizen().remove(data.getId());
        }
        this.markDirty();
    }

    public void overruleNextOpenRequestWithStack(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return;
        }
        Set<Integer> citizenIdsWithRequests = this.getOpenRequestsByCitizen().keySet();
        if (citizenIdsWithRequests.isEmpty()) {
            ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
            for (IRequestResolver resolver : resolvers) {
                List<IRequest<? extends IDeliverable>> deliverableRequests = RequestHandler.getRequestsMadeByRequester((IStandardRequestManager)this.getColony().getRequestManager(), resolver).stream().filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).map(iRequest -> iRequest).collect(Collectors.toList());
                IRequest<? extends IDeliverable> target = this.getFirstOverullingRequestFromInputList(deliverableRequests, stack);
                if (target == null) continue;
                this.getColony().getRequestManager().overruleRequest((IToken<?>)target.getToken(), stack.func_77946_l());
                return;
            }
            return;
        }
        for (int citizenId : citizenIdsWithRequests) {
            IRequest<? extends IDeliverable> target;
            CitizenData data = this.getColony().getCitizenManager().getCitizen(citizenId);
            if (data == null || (target = this.getFirstOverullingRequestFromInputList((Collection<IRequest<? extends IDeliverable>>)this.getOpenRequestsOfType(data, TypeConstants.DELIVERABLE), stack)) == null) continue;
            this.getColony().getRequestManager().overruleRequest((IToken<?>)target.getToken(), stack.func_77946_l());
            return;
        }
    }

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull CitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(requestType);
        }).map(request -> request).filter(filter).iterator());
    }

    public boolean overruleNextOpenRequestOfCitizenWithStack(@NotNull CitizenData citizenData, @NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        IRequest<? extends IDeliverable> target = this.getFirstOverullingRequestFromInputList((Collection<IRequest<? extends IDeliverable>>)this.getOpenRequestsOfType(citizenData, TypeConstants.DELIVERABLE), stack);
        if (target == null) {
            AbstractJobCrafter crafterJob;
            if (citizenData.getJob() instanceof AbstractJobCrafter && !(crafterJob = citizenData.getJob(AbstractJobCrafter.class)).getAssignedTasks().isEmpty()) {
                IRequest deliverableChildRequest = crafterJob.getAssignedTasks().stream().map(this.getColony().getRequestManager()::getRequestForToken).map(IRequest::getChildren).flatMap(Collection::stream).map(this.getColony().getRequestManager()::getRequestForToken).filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).filter(iRequest -> ((IDeliverable)iRequest.getRequest()).matches(stack)).findFirst().map(iRequest -> iRequest).orElse(null);
                if (deliverableChildRequest != null) {
                    deliverableChildRequest.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.of((Object)stack));
                    this.getColony().getRequestManager().overruleRequest((IToken<?>)deliverableChildRequest.getToken(), stack.func_77946_l());
                    return true;
                }
            }
            return false;
        }
        target.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.of((Object)stack));
        this.getColony().getRequestManager().overruleRequest((IToken<?>)target.getToken(), stack.func_77946_l());
        return true;
    }

    private IRequest<? extends IDeliverable> getFirstOverullingRequestFromInputList(@NotNull Collection<IRequest<? extends IDeliverable>> queue, @NotNull ItemStack stack) {
        if (queue.isEmpty()) {
            return null;
        }
        ArrayList validRequesterTokens = Lists.newArrayList();
        validRequesterTokens.add(this.getRequesterId());
        this.getResolvers().forEach(iRequestResolver -> validRequesterTokens.add(iRequestResolver.getRequesterId()));
        return queue.stream().filter(request -> validRequesterTokens.contains(request.getRequester().getRequesterId()) && ((IDeliverable)request.getRequest()).matches(stack)).findFirst().orElse(null);
    }

    private Collection<IRequest<? extends IDeliverable>> flattenDeliverableChildRequests(@NotNull IRequest<? extends IDeliverable> request) {
        if (!request.hasChildren()) {
            return ImmutableList.of();
        }
        return request.getChildren().stream().map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).filter(request1 -> request1.getRequest() instanceof IDeliverable).map(request1 -> request1).collect(Collectors.toList());
    }

    @Override
    public IToken<?> getRequesterId() {
        return this.getToken();
    }

    @Override
    public IToken<?> getToken() {
        return this.requester.getRequesterId();
    }

    @Override
    public final ImmutableCollection<IRequestResolver<?>> getResolvers() {
        if (this.getColony() != null && this.getColony().getRequestManager() != null && this.getColony().getRequestManager() instanceof IStandardRequestManager && !ProviderHandler.getRegisteredResolvers((IStandardRequestManager)this.getColony().getRequestManager(), this).isEmpty()) {
            return ImmutableList.copyOf((Collection)ProviderHandler.getRegisteredResolvers((IStandardRequestManager)this.getColony().getRequestManager(), this).stream().map(token -> ResolverHandler.getResolver((IStandardRequestManager)this.getColony().getRequestManager(), token)).collect(Collectors.toList()));
        }
        return this.createResolvers();
    }

    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        return ImmutableList.of((Object)new BuildingRequestResolver(this.getRequester().getRequesterLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
    }

    public IRequester getRequester() {
        return this.requester;
    }

    @Override
    @NotNull
    public ILocation getRequesterLocation() {
        return this.getRequester().getRequesterLocation();
    }

    @Override
    public void onRequestComplete(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        Integer citizenThatRequested = this.getCitizensByRequest().remove(token);
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(token);
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
        IRequest<?> requestThatCompleted = this.getColony().getRequestManager().getRequestForToken(token);
        this.getOpenRequestsByRequestableType().get(TypeToken.of(requestThatCompleted.getRequest().getClass())).remove(token);
        if (this.getOpenRequestsByRequestableType().get(TypeToken.of(requestThatCompleted.getRequest().getClass())).isEmpty()) {
            this.getOpenRequestsByRequestableType().remove(TypeToken.of(requestThatCompleted.getRequest().getClass()));
        }
        if (!this.getCompletedRequestsByCitizen().containsKey(citizenThatRequested)) {
            this.getCompletedRequestsByCitizen().put(citizenThatRequested, new ArrayList());
        }
        this.getCompletedRequestsByCitizen().get(citizenThatRequested).add(token);
        this.markDirty();
    }

    public void onRequestCancelled(@NotNull IRequestManager manager, @NotNull IToken token) {
        IRequest<?> requestThatCompleted;
        int citizenThatRequested = this.getCitizensByRequest().remove(token);
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(token);
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
        if ((requestThatCompleted = this.getColony().getRequestManager().getRequestForToken(token)) != null && this.getOpenRequestsByRequestableType().containsKey(TypeToken.of(requestThatCompleted.getRequest().getClass()))) {
            this.getOpenRequestsByRequestableType().get(TypeToken.of(requestThatCompleted.getRequest().getClass())).remove(token);
            if (this.getOpenRequestsByRequestableType().get(TypeToken.of(requestThatCompleted.getRequest().getClass())).isEmpty()) {
                this.getOpenRequestsByRequestableType().remove(TypeToken.of(requestThatCompleted.getRequest().getClass()));
            }
        }
        if (this.getColony().getCitizenManager().getCitizen(citizenThatRequested) != null) {
            this.getColony().getCitizenManager().getCitizen(citizenThatRequested).onRequestCancelled(token);
        }
        this.markDirty();
    }

    @Override
    @NotNull
    public ITextComponent getDisplayName(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        if (!this.getCitizensByRequest().containsKey(token)) {
            return new TextComponentString("<UNKNOWN>");
        }
        Integer citizenData = this.getCitizensByRequest().get(token);
        return new TextComponentString(this.getSchematicName() + " " + this.getColony().getCitizenManager().getCitizen(citizenData).getName());
    }

    public Optional<CitizenData> getCitizenForRequest(@NotNull IToken token) {
        if (!this.getCitizensByRequest().containsKey(token) || this.getColony() == null) {
            return Optional.empty();
        }
        int citizenID = this.getCitizensByRequest().get(token);
        if (this.getColony().getCitizenManager().getCitizen(citizenID) == null) {
            return Optional.empty();
        }
        return Optional.of(this.getColony().getCitizenManager().getCitizen(citizenID));
    }
}

