/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.controls.TextField;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.colony.workorders.WorkOrderView;
import com.minecolonies.coremod.network.messages.DecorationBuildRequestMessage;
import com.minecolonies.coremod.network.messages.DecorationControllUpdateMessage;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WindowDecorationController
extends AbstractWindowSkeleton
implements ButtonHandler {
    private static final int MAX_NAME_LENGTH = 100;
    private static final String HUT_NAME_RESOURCE_SUFFIX = ":gui/windowdecorationcontroller.xml";
    private static final String INPUT_LEVEL = "level";
    private final TileEntityDecorationController controller;
    private final World world;
    private boolean isCreative;

    public WindowDecorationController(BlockPos b) {
        super("minecolonies:gui/windowdecorationcontroller.xml");
        Optional<WorkOrderView> wo;
        this.world = Minecraft.func_71410_x().field_71441_e;
        this.isCreative = Minecraft.func_71410_x().field_71439_g.func_184812_l_();
        this.controller = (TileEntityDecorationController)this.world.func_175625_s(b);
        this.registerButton("build", this::confirmClicked);
        this.registerButton("repair", this::repairClicked);
        this.registerButton("done", this::doneClicked);
        this.registerButton("cancel", this::cancelClicked);
        TextField textFieldName = this.findPaneOfTypeByID("name", TextField.class);
        textFieldName.setText(this.controller.getSchematicName());
        TextField textFieldLevel = this.findPaneOfTypeByID(INPUT_LEVEL, TextField.class);
        textFieldLevel.setText(String.valueOf(this.controller.getLevel()));
        ColonyView view = ColonyManager.getClosestColonyView(this.world, this.controller.func_174877_v());
        Button buttonBuild = this.findPaneOfTypeByID("build", Button.class);
        if (view != null && (wo = view.getWorkOrders().stream().filter(w -> w.getPos().equals((Object)this.controller.func_174877_v())).findFirst()).isPresent()) {
            if (wo.get().getType() == AbstractWorkOrder.WorkOrderType.BUILD) {
                if (this.controller.getLevel() == 0) {
                    buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelBuild", new Object[0]));
                } else {
                    buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelUpgrade", new Object[0]));
                }
                this.findPaneByID("repair").hide();
            } else if (wo.get().getType() == AbstractWorkOrder.WorkOrderType.BUILD) {
                buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelRepair", new Object[0]));
                this.findPaneByID("repair").hide();
            }
        }
        if (this.controller.getLevel() == 0) {
            this.findPaneByID("repair").hide();
        }
        Structure structure = null;
        try {
            structure = new Structure(this.world, this.controller.getSchematicName() + (this.controller.getLevel() + 1), new PlacementSettings());
        }
        catch (Exception e) {
            Log.getLogger().info("Unable to load structure: " + this.controller.getSchematicName() + " for decoration controller!");
        }
        if (structure == null || structure.isBluePrintMissing()) {
            this.findPaneByID("build").hide();
        }
        if (!this.isCreative) {
            textFieldName.disable();
            textFieldLevel.disable();
            this.findPaneByID("done").hide();
        } else {
            this.findPaneOfTypeByID("nameLabel", Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.deco.namescan", new Object[0]));
        }
    }

    private void cancelClicked() {
        this.close();
    }

    private void doneClicked() {
        if (this.isCreative) {
            String name = this.findPaneOfTypeByID("name", TextField.class).getText();
            if (name.length() > 100) {
                name = name.substring(0, 100);
                LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "com.minecolonies.coremod.gui.name.tooLong", name);
            }
            String levelString = this.findPaneOfTypeByID(INPUT_LEVEL, TextField.class).getText();
            try {
                int level = Integer.parseInt(levelString);
                MineColonies.getNetwork().sendToServer((IMessage)new DecorationControllUpdateMessage(this.controller.func_174877_v(), name, level));
                this.controller.setSchematicName(name);
                this.controller.setLevel(level);
                this.close();
            }
            catch (NumberFormatException ex) {
                Log.getLogger().warn("Error parsing number: " + levelString, (Throwable)ex);
            }
        }
    }

    private void confirmClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new DecorationBuildRequestMessage(this.controller.func_174877_v(), this.controller.getSchematicName(), this.controller.getLevel() + 1, this.world.field_73011_w.getDimension()));
        this.close();
    }

    private void repairClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new DecorationBuildRequestMessage(this.controller.func_174877_v(), this.controller.getSchematicName(), this.controller.getLevel(), this.world.field_73011_w.getDimension()));
        this.close();
    }
}

