/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowBuildBuilding;
import com.minecolonies.coremod.client.gui.WindowHutNameEntry;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.BuildRequestMessage;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class AbstractWindowBuilding<B extends AbstractBuildingView>
extends AbstractWindowSkeleton {
    protected final B building;
    private final Label title;
    private final Button buttonBuild;

    public AbstractWindowBuilding(B building, String resource) {
        super(resource);
        this.building = building;
        this.registerButton("build", this::buildClicked);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("editName", this::editName);
        this.title = this.findPaneOfTypeByID("name", Label.class);
        this.buttonBuild = this.findPaneOfTypeByID("build", Button.class);
    }

    private void editName() {
        WindowHutNameEntry window = new WindowHutNameEntry((AbstractBuildingView)this.building);
        window.open();
    }

    private void buildClicked() {
        String buttonLabel = this.buttonBuild.getLabel();
        if (buttonLabel.equalsIgnoreCase(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelBuild", new Object[0])) || buttonLabel.equalsIgnoreCase(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelUpgrade", new Object[0]))) {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuildingView)this.building, 0, BlockPos.field_177992_a));
        } else if (buttonLabel.equalsIgnoreCase(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelRepair", new Object[0]))) {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuildingView)this.building, 1, BlockPos.field_177992_a));
        } else {
            WindowBuildBuilding window = new WindowBuildBuilding(((AbstractBuildingView)this.building).getColony(), (AbstractBuildingView)this.building);
            window.open();
        }
    }

    private void inventoryClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(((AbstractBuildingView)this.building).getID()));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.switchView.getCurrentView().getID().equals("pageActions")) {
            B buildingView = this.building;
            if (this.title != null && buildingView != null) {
                String name;
                String string = name = ((AbstractBuildingView)this.building).getCustomName().isEmpty() ? LanguageHandler.format(this.getBuildingName(), new Object[0]) : ((AbstractBuildingView)this.building).getCustomName();
                if (this.switchView.getID().equals("switchpageActions")) {
                    this.title.setLabelText(name);
                    this.findPaneOfTypeByID("level", Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.buildingLevel", new Object[0]) + ": " + ((AbstractBuildingView)buildingView).getBuildingLevel());
                } else {
                    this.title.setLabelText(name + " " + ((AbstractBuildingView)buildingView).getBuildingLevel());
                }
            }
            this.updateButtonBuild((AbstractBuildingView)buildingView);
        }
    }

    public abstract String getBuildingName();

    private void updateButtonBuild(AbstractBuildingView buildingView) {
        if (this.buttonBuild == null) {
            return;
        }
        if (buildingView.isBuilding()) {
            if (buildingView.getBuildingLevel() == 0) {
                this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelBuild", new Object[0]));
            } else {
                this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelUpgrade", new Object[0]));
            }
        } else if (buildingView.isRepairing()) {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelRepair", new Object[0]));
        } else {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.buildRepair", new Object[0]));
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.setPage("");
    }
}

