/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks.huts;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockHutTownHall
extends AbstractBlockHut<BlockHutTownHall> {
    public static final float PVP_MODE_HARDNESS = 200.0f;

    public BlockHutTownHall() {
        if (Configurations.gameplay.pvp_mode) {
            this.func_149711_c(200.0f);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "blockHutTownHall";
    }

    @Override
    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K) {
            return;
        }
        if (placer.func_184600_cs().equals((Object)EnumHand.MAIN_HAND) && placer instanceof EntityPlayer) {
            Colony colony = ColonyManager.getClosestColony(worldIn, pos);
            String style = "wooden";
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TileEntityColonyBuilding && !((TileEntityColonyBuilding)tileEntity).getStyle().isEmpty()) {
                style = ((TileEntityColonyBuilding)tileEntity).getStyle();
            }
            if (colony == null || !ColonyManager.isTooCloseToColony(worldIn, pos)) {
                if (Configurations.gameplay.enableDynamicColonySizes) {
                    IColony ownedColony = ColonyManager.getIColonyByOwner(worldIn, (EntityPlayer)placer);
                    if (ownedColony == null) {
                        ColonyManager.createColony(worldIn, pos, (EntityPlayer)placer, style);
                    } else {
                        colony.getBuildingManager().addNewBuilding((TileEntityColonyBuilding)tileEntity, worldIn);
                    }
                } else {
                    ColonyManager.createColony(worldIn, pos, (EntityPlayer)placer, style);
                }
            } else {
                colony.setStyle(style);
                colony.getBuildingManager().addNewBuilding((TileEntityColonyBuilding)tileEntity, worldIn);
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }
}

