/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public interface IColonyTagCapability {
    public void removeColony(int var1);

    public void addColony(int var1);

    @NotNull
    public List<Integer> getAllCloseColonies();

    public void setOwningColony(int var1);

    public int getOwningColony();

    public void reset();

    public void addBuildingClaim(int var1, BlockPos var2);

    public void removeBuildingClaim(int var1, BlockPos var2);

    @NotNull
    public Map<Integer, Set<BlockPos>> getAllClaimingBuildings();

    public static class Storage
    implements Capability.IStorage<IColonyTagCapability> {
        public NBTBase writeNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("id", instance.getOwningColony());
            compound.func_74782_a("colonies", (NBTBase)instance.getAllCloseColonies().stream().map(Storage::write).collect(NBTUtils.toNBTTagList()));
            compound.func_74782_a("buildingsClaim", (NBTBase)instance.getAllClaimingBuildings().entrySet().stream().map(Storage::writeClaims).collect(NBTUtils.toNBTTagList()));
            return compound;
        }

        public void readNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable EnumFacing side, @NotNull NBTBase nbt) {
            if (nbt instanceof NBTTagCompound && ((NBTTagCompound)nbt).func_74764_b("id")) {
                instance.setOwningColony(((NBTTagCompound)nbt).func_74762_e("id"));
                NBTUtils.streamCompound(((NBTTagCompound)nbt).func_150295_c("colonies", 10)).map(compound -> compound.func_74762_e("id")).forEach(instance::addColony);
                NBTUtils.streamCompound(((NBTTagCompound)nbt).func_150295_c("buildingsClaim", 10)).forEach(tagCompound -> Storage.readClaims(tagCompound, instance));
            }
        }

        private static NBTTagCompound write(int id) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("id", id);
            return compound;
        }

        private static NBTTagCompound writeClaims(@NotNull Map.Entry<Integer, Set<BlockPos>> entry) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("id", entry.getKey().intValue());
            compound.func_74782_a("buildings", (NBTBase)entry.getValue().stream().map(pos -> BlockPosUtil.writeToNBT(new NBTTagCompound(), "building", pos)).collect(NBTUtils.toNBTTagList()));
            return compound;
        }

        private static void readClaims(@NotNull NBTTagCompound compound, @NotNull IColonyTagCapability instance) {
            int id = compound.func_74762_e("id");
            NBTUtils.streamCompound(compound.func_150295_c("buildings", 10)).forEach(tagCompound -> instance.addBuildingClaim(id, BlockPosUtil.readFromNBT(tagCompound, "building")));
        }
    }

    public static class Impl
    implements IColonyTagCapability {
        private final Set<Integer> colonies = new HashSet<Integer>();
        private int owningColony = 0;
        private final Map<Integer, Set<BlockPos>> claimingBuildings = new HashMap<Integer, Set<BlockPos>>();

        @Override
        public void addColony(int id) {
            this.colonies.add(id);
        }

        @Override
        public void removeColony(int id) {
            this.colonies.remove(id);
            if (this.owningColony == id) {
                this.owningColony = 0;
            }
        }

        @Override
        public void reset() {
            this.colonies.clear();
            this.owningColony = 0;
            this.claimingBuildings.clear();
        }

        @Override
        public void addBuildingClaim(int colonyId, BlockPos pos) {
            if (this.owningColony == 0) {
                this.setOwningColony(colonyId);
            }
            if (this.claimingBuildings.containsKey(colonyId)) {
                this.claimingBuildings.get(colonyId).add(pos);
            } else {
                HashSet<BlockPos> newList = new HashSet<BlockPos>();
                newList.add(pos);
                this.claimingBuildings.put(colonyId, newList);
            }
        }

        @Override
        public void removeBuildingClaim(int colonyId, BlockPos pos) {
            if (this.claimingBuildings.containsKey(colonyId)) {
                Set<BlockPos> buildings = this.claimingBuildings.get(colonyId);
                buildings.remove(pos);
                if (buildings.isEmpty()) {
                    this.claimingBuildings.remove(colonyId);
                }
                if (this.owningColony == colonyId) {
                    if (this.claimingBuildings.isEmpty()) {
                        this.reset();
                    } else if (this.claimingBuildings.size() == 1) {
                        this.setOwningColony(this.claimingBuildings.keySet().iterator().next());
                    } else {
                        this.setOwningColony(this.claimingBuildings.keySet().toArray(new Integer[0])[new Random().nextInt(this.claimingBuildings.size())]);
                    }
                }
            }
        }

        @Override
        public void setOwningColony(int id) {
            this.owningColony = id;
        }

        @Override
        public int getOwningColony() {
            return this.owningColony;
        }

        @Override
        @NotNull
        public List<Integer> getAllCloseColonies() {
            return new ArrayList<Integer>(this.colonies);
        }

        @Override
        @NotNull
        public Map<Integer, Set<BlockPos>> getAllClaimingBuildings() {
            return this.claimingBuildings;
        }
    }
}

