/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.energy;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.WorldTools;
import mcjty.xnet.api.channels.IChannelSettings;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.DefaultChannelSettings;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.apiimpl.energy.EnergyConnectorSettings;
import mcjty.xnet.blocks.cables.ConnectorBlock;
import mcjty.xnet.blocks.cables.ConnectorTileEntity;
import mcjty.xnet.config.ConfigSetup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.tuple.Pair;

public class EnergyChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    private List<Pair<SidedConsumer, EnergyConnectorSettings>> energyExtractors = null;
    private List<Pair<SidedConsumer, EnergyConnectorSettings>> energyConsumers = null;

    @Override
    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        return object;
    }

    @Override
    public void readFromJson(JsonObject data) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public int getColors() {
        return 0;
    }

    @Override
    public void tick(int channel, IControllerContext context) {
        this.updateCache(channel, context);
        World world = context.getControllerWorld();
        int totalToDistribute = 0;
        HashMap<BlockPos, Integer> alreadyHandled = new HashMap<BlockPos, Integer>();
        ArrayList<Pair> energyProducers = new ArrayList<Pair>();
        for (Pair<SidedConsumer, EnergyConnectorSettings> entry : this.energyExtractors) {
            int level;
            Integer count;
            TileEntity te;
            EnumFacing side;
            BlockPos energyPos;
            BlockPos connectorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId());
            if (connectorPos == null || !WorldTools.chunkLoaded((World)world, (BlockPos)(energyPos = connectorPos.func_177972_a(side = ((SidedConsumer)entry.getKey()).getSide()))) || !EnergyChannelSettings.isEnergyTE(te = world.func_175625_s(energyPos), side.func_176734_d())) continue;
            EnergyConnectorSettings settings = (EnergyConnectorSettings)entry.getValue();
            ConnectorTileEntity connectorTE = (ConnectorTileEntity)world.func_175625_s(connectorPos);
            if (this.checkRedstone(world, settings, connectorPos) || !context.matchColor(settings.getColorsMask()) || (count = settings.getMinmax()) != null && (level = EnergyChannelSettings.getEnergyLevel(te, side.func_176734_d())) < count) continue;
            Integer rate = settings.getRate();
            if (rate == null) {
                boolean advanced = ConnectorBlock.isAdvancedConnector(world, connectorPos);
                rate = advanced ? ConfigSetup.maxRfRateAdvanced.get() : ConfigSetup.maxRfRateNormal.get();
            }
            connectorTE.setEnergyInputFrom(side, rate);
            if (!alreadyHandled.containsKey(connectorPos)) {
                alreadyHandled.put(connectorPos, connectorTE.getEnergy());
            }
            int connectorEnergy = (Integer)alreadyHandled.get(connectorPos);
            int tosend = Math.min(rate, connectorEnergy);
            if (tosend <= 0) continue;
            alreadyHandled.put(connectorPos, connectorEnergy - tosend);
            totalToDistribute += tosend;
            energyProducers.add(Pair.of((Object)connectorTE, (Object)tosend));
        }
        if (totalToDistribute <= 0) {
            return;
        }
        if (!context.checkAndConsumeRF(ConfigSetup.controllerOperationRFT.get())) {
            return;
        }
        int actuallyConsumed = this.insertEnergy(context, totalToDistribute);
        if (actuallyConsumed <= 0) {
            return;
        }
        for (Pair entry : energyProducers) {
            ConnectorTileEntity connectorTE = (ConnectorTileEntity)entry.getKey();
            int amount = (Integer)entry.getValue();
            int actuallySpent = Math.min(amount, actuallyConsumed);
            connectorTE.setEnergy(connectorTE.getEnergy() - actuallySpent);
            if ((actuallyConsumed -= actuallySpent) > 0) continue;
            break;
        }
    }

    private int insertEnergy(@Nonnull IControllerContext context, int energy) {
        int total = 0;
        World world = context.getControllerWorld();
        for (Pair<SidedConsumer, EnergyConnectorSettings> entry : this.energyConsumers) {
            int level;
            Integer count;
            TileEntity te;
            EnumFacing side;
            BlockPos pos;
            EnergyConnectorSettings settings = (EnergyConnectorSettings)entry.getValue();
            BlockPos extractorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId());
            if (extractorPos == null || !WorldTools.chunkLoaded((World)world, (BlockPos)(pos = extractorPos.func_177972_a(side = ((SidedConsumer)entry.getKey()).getSide()))) || !EnergyChannelSettings.isEnergyTE(te = world.func_175625_s(pos), settings.getFacing()) || this.checkRedstone(world, settings, extractorPos) || !context.matchColor(settings.getColorsMask()) || (count = settings.getMinmax()) != null && (level = EnergyChannelSettings.getEnergyLevel(te, settings.getFacing())) >= count) continue;
            Integer rate = settings.getRate();
            if (rate == null) {
                boolean advanced = ConnectorBlock.isAdvancedConnector(world, extractorPos);
                rate = advanced ? ConfigSetup.maxRfRateAdvanced.get() : ConfigSetup.maxRfRateNormal.get();
            }
            int totransfer = Math.min(rate, energy);
            long e = EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)settings.getFacing(), (long)totransfer);
            energy = (int)((long)energy - e);
            total = (int)((long)total + e);
            if (energy > 0) continue;
            return total;
        }
        return total;
    }

    public static boolean isEnergyTE(@Nullable TileEntity te, @Nonnull EnumFacing side) {
        if (te == null) {
            return false;
        }
        return te.hasCapability(CapabilityEnergy.ENERGY, side);
    }

    public static int getEnergyLevel(TileEntity tileEntity, @Nonnull EnumFacing side) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, side)) {
            IEnergyStorage energy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, side);
            return energy.getEnergyStored();
        }
        return 0;
    }

    @Override
    public void cleanCache() {
        this.energyExtractors = null;
        this.energyConsumers = null;
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.energyExtractors == null) {
            EnergyConnectorSettings con;
            this.energyExtractors = new ArrayList<Pair<SidedConsumer, EnergyConnectorSettings>>();
            this.energyConsumers = new ArrayList<Pair<SidedConsumer, EnergyConnectorSettings>>();
            Map<SidedConsumer, IConnectorSettings> connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (EnergyConnectorSettings)entry.getValue();
                if (con.getEnergyMode() == EnergyConnectorSettings.EnergyMode.EXT) {
                    this.energyExtractors.add((Pair<SidedConsumer, EnergyConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
                    continue;
                }
                this.energyConsumers.add((Pair<SidedConsumer, EnergyConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (EnergyConnectorSettings)entry.getValue();
                if (con.getEnergyMode() != EnergyConnectorSettings.EnergyMode.INS) continue;
                this.energyConsumers.add((Pair<SidedConsumer, EnergyConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
            }
            this.energyExtractors.sort((o1, o2) -> ((EnergyConnectorSettings)o2.getRight()).getPriority().compareTo(((EnergyConnectorSettings)o1.getRight()).getPriority()));
            this.energyConsumers.sort((o1, o2) -> ((EnergyConnectorSettings)o2.getRight()).getPriority().compareTo(((EnergyConnectorSettings)o1.getRight()).getPriority()));
        }
    }

    @Override
    public boolean isEnabled(String tag) {
        return true;
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 11, 80, 11, 10);
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public void createGui(IEditorGui gui) {
    }

    @Override
    public void update(Map<String, Object> data) {
    }
}

