/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.packager.TileEntityPackager;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class UtilItemStack {
    public static ItemStack tryDepositToHandler(World world, BlockPos posSide, EnumFacing sideOpp, ItemStack stackToExport) {
        TileEntity tileTarget = world.func_175625_s(posSide);
        if (tileTarget == null || !tileTarget.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, sideOpp)) {
            return stackToExport;
        }
        try {
            IItemHandler itemHandlerDeposit = (IItemHandler)tileTarget.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, sideOpp);
            for (int i = 0; i < itemHandlerDeposit.getSlots(); ++i) {
                ItemStack leftBehindAfterInsert = itemHandlerDeposit.insertItem(i, stackToExport, false);
                if (leftBehindAfterInsert == null || leftBehindAfterInsert.func_190916_E() >= stackToExport.func_190916_E()) continue;
                return leftBehindAfterInsert.func_77946_l();
            }
        }
        catch (Exception e) {
            ModCyclic.logger.error("Error inserting item into capability handler ", e);
        }
        return stackToExport;
    }

    public static boolean canMerge(ItemStack chestItem, ItemStack bagItem) {
        if (chestItem.func_190926_b() || bagItem.func_190926_b()) {
            return false;
        }
        return bagItem.func_77973_b().equals(chestItem.func_77973_b()) && bagItem.func_77952_i() == chestItem.func_77952_i() && ItemStack.func_77970_a((ItemStack)bagItem, (ItemStack)chestItem);
    }

    public static int mergeItemsBetweenStacks(ItemStack takeFrom, ItemStack moveTo) {
        int room = moveTo.func_77976_d() - moveTo.func_190916_E();
        int moveover = 0;
        if (room > 0) {
            moveover = Math.min(takeFrom.func_190916_E(), room);
            moveTo.func_190917_f(moveover);
            takeFrom.func_190918_g(moveover);
        }
        return moveover;
    }

    public static boolean isEmpty(ItemStack is) {
        return is == null || is.func_190926_b() || is == ItemStack.field_190927_a;
    }

    public static void damageItem(EntityLivingBase p, ItemStack s) {
        if (p instanceof EntityPlayer) {
            UtilItemStack.damageItem((EntityPlayer)p, s);
        } else {
            s.func_77972_a(1, p);
        }
    }

    public static void damageItem(EntityPlayer p, ItemStack s) {
        UtilItemStack.damageItem(p, s, 1);
    }

    public static void repairItem(EntityPlayer p, ItemStack s) {
        s.func_77964_b(s.func_77952_i() - 1);
    }

    public static void damageItem(EntityPlayer p, ItemStack s, int num) {
        if (!p.field_71075_bZ.field_75098_d && !p.field_70170_p.field_72995_K) {
            s.func_77972_a(num, (EntityLivingBase)p);
        }
    }

    public static IBlockState getStateFromMeta(Block b, int meta) {
        return b.func_176203_a(meta);
    }

    public static float getPlayerRelativeBlockHardness(Block b, IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        return b.func_180647_a(state, player, worldIn, pos);
    }

    public static float getBlockHardness(IBlockState state, World worldIn, BlockPos pos) {
        return state.func_177230_c().func_176195_g(state, worldIn, pos);
    }

    public static EntityItem dropItemStackInWorld(World worldObj, BlockPos pos, Block block) {
        return UtilItemStack.dropItemStackInWorld(worldObj, pos, new ItemStack(block));
    }

    public static EntityItem dropItemStackInWorld(World worldObj, BlockPos pos, Item item) {
        return UtilItemStack.dropItemStackInWorld(worldObj, pos, new ItemStack(item));
    }

    public static EntityItem dropItemStackInWorld(World world, BlockPos pos, ItemStack stack) {
        if (pos == null || world == null || stack.func_190926_b()) {
            return null;
        }
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)entityItem);
        }
        return entityItem;
    }

    public static void dropItemStackMotionless(World world, BlockPos pos, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        if (!world.field_72995_K) {
            entityItem.field_70179_y = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70159_w = 0.0;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static void dropItemStacksInWorld(World world, BlockPos pos, List<ItemStack> stacks) {
        for (ItemStack s : stacks) {
            UtilItemStack.dropItemStackInWorld(world, pos, s);
        }
    }

    @Nonnull
    public static String getStringForItemStack(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return item.getRegistryName().func_110624_b() + ":" + item.getRegistryName().func_110623_a() + "/" + itemStack.func_77960_j();
    }

    public static String getStringForItem(Item item) {
        if (item == null || item.getRegistryName() == null) {
            return "";
        }
        return item.getRegistryName().func_110624_b() + ":" + item.getRegistryName().func_110623_a();
    }

    public static String getStringForBlock(Block b) {
        return b.getRegistryName().func_110624_b() + ":" + b.getRegistryName().func_110623_a();
    }

    public static void dropBlockState(World world, BlockPos position, IBlockState current) {
        if (!world.field_72995_K && current.func_177230_c() != Blocks.field_150350_a) {
            UtilItemStack.dropItemStackInWorld(world, position, UtilItemStack.getSilkTouchDrop(current));
        }
    }

    public static IBlockState getStateFromStack(ItemStack stack) {
        Block stuff = Block.func_149634_a((Item)stack.func_77973_b());
        return UtilItemStack.getStateFromMeta(stuff, stack.func_77960_j());
    }

    public static ItemStack getSilkTouchDrop(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        int i = 0;
        if (item.func_77614_k()) {
            i = state.func_177230_c().func_176201_c(state);
        }
        return new ItemStack(item, 1, i);
    }

    public static boolean doesTileHaveRoom(TileEntityPackager tileEntityPackager, int inputSize, ItemStack recipeOutput) {
        return false;
    }

    public static boolean isItemStackEqualIgnoreCount(ItemStack tthis, ItemStack other) {
        if (tthis.func_77973_b() != other.func_77973_b()) {
            return false;
        }
        if (tthis.func_77952_i() != other.func_77952_i()) {
            return false;
        }
        if (tthis.func_77978_p() == null && other.func_77978_p() != null) {
            return false;
        }
        return (tthis.func_77978_p() == null || tthis.func_77978_p().equals((Object)other.func_77978_p())) && tthis.areCapsCompatible(other);
    }
}

