/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.sound;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.block.password.IPlayerClaimed;
import com.lothrazar.cyclicmagic.block.sound.BlockSoundPlayer;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class TileEntitySoundPlayer
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable,
IPlayerClaimed {
    private static final int TIMER_MAX = 100;
    private int soundIndex = -1;
    private String userHash = "";
    private String userName = "";

    public TileEntitySoundPlayer() {
        super(0);
    }

    public static List<ResourceLocation> getSoundList() {
        ArrayList<ResourceLocation> allSounds = new ArrayList<ResourceLocation>();
        for (ResourceLocation r : SoundEvent.field_187505_a.func_148742_b()) {
            if (r.toString().contains("minecraft:record")) continue;
            allSounds.add(r);
        }
        allSounds.sort(Comparator.comparing(ResourceLocation::toString));
        return allSounds;
    }

    public void func_73660_a() {
        List<ResourceLocation> allSounds;
        ResourceLocation sound;
        if (!this.isPowered() && this.onlyRunIfPowered()) {
            this.timer = 0;
        }
        if (!this.isRunning()) {
            return;
        }
        if (this.updateTimerIsZero() && this.soundIndex >= 0 && this.soundIndex < SoundEvent.field_187505_a.func_148742_b().size() && (sound = (allSounds = TileEntitySoundPlayer.getSoundList()).get(this.soundIndex)) != null && SoundEvent.field_187505_a.func_82594_a((Object)sound) != null) {
            this.playSound(sound);
        }
    }

    private void playSound(ResourceLocation sound) {
        this.timer = 100;
        if (BlockSoundPlayer.playToEverybody) {
            UtilSound.playSound(this.field_145850_b, this.field_174879_c, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)sound), SoundCategory.BLOCKS);
            return;
        }
        try {
            if (this.getClaimedHash() != null) {
                EntityPlayer playerTarget = this.field_145850_b.func_152378_a(UUID.fromString(this.getClaimedHash()));
                UtilSound.playSound(playerTarget, this.field_174879_c, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)sound));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case SOUNDINDEX: {
                return this.soundIndex;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case SOUNDINDEX: {
                this.soundIndex = value;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.needsRedstone = tags.func_74762_e("redstone");
        this.soundIndex = tags.func_74762_e("soundIndex");
        this.userHash = tags.func_74779_i("uhash");
        this.userName = tags.func_74779_i("uname");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a("redstone", this.needsRedstone);
        tags.func_74768_a("soundIndex", this.soundIndex);
        tags.func_74778_a("uhash", this.userHash);
        tags.func_74778_a("uname", this.userName);
        return super.func_189515_b(tags);
    }

    @Override
    public boolean isClaimedBy(EntityPlayer p) {
        return p.func_110124_au().toString().equals(this.userHash);
    }

    @Override
    public boolean isClaimedBySomeone() {
        return this.userHash != null && !this.userHash.isEmpty();
    }

    @Override
    public String getClaimedHash() {
        return this.userHash;
    }

    @Override
    public void toggleClaimedHash(EntityPlayer player) {
        if (this.isClaimedBySomeone()) {
            this.userHash = "";
            this.userName = "";
        } else {
            this.userHash = player.func_110124_au().toString();
            this.userName = player.getDisplayNameString();
        }
    }

    @Override
    public String getClaimedName() {
        return this.userName;
    }

    public static enum Fields {
        REDSTONE,
        TIMER,
        SOUNDINDEX;

    }
}

