/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.core;

import com.lothrazar.cyclicmagic.block.cable.TileEntityCableBase;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachine;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.InvWrapperRestricted;
import com.lothrazar.cyclicmagic.data.StackWrapper;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityBaseMachineInvo
extends TileEntityBaseMachine
implements IInventory,
ISidedInventory {
    protected static final int SPEED_FUELED = 8;
    private static final int MAX_SPEED = 10;
    public static final int MENERGY = 64000;
    private static final String NBT_INV = "Inventory";
    private static final String NBT_SLOT = "Slot";
    public static final String NBT_TIMER = "Timer";
    public static final String NBT_REDST = "redstone";
    public static final String NBT_SIZE = "size";
    public static final String NBTPLAYERID = "uuid";
    public static final String NBT_SPEED = "speed";
    public static final String NBT_RENDER = "render";
    public static final String NBT_TANK = "tankwater";
    private static final String NBT_ENERGY = "ENERGY";
    public static final String NBT_UHASH = "uhash";
    public static final String NBT_UNAME = "uname";
    protected NonNullList<ItemStack> inv;
    private int energyCost = 0;
    protected int speed = 1;
    protected int timer;
    protected int renderParticles = 0;
    protected int needsRedstone = 0;
    InvWrapperRestricted invHandler;
    protected EnergyStore energyStorage;
    private boolean setRenderGlobally;
    private boolean hasEnergy;

    public TileEntityBaseMachineInvo(int invoSize) {
        this.inv = NonNullList.func_191197_a((int)invoSize, (Object)ItemStack.field_190927_a);
        this.invHandler = new InvWrapperRestricted(this);
    }

    protected void setSlotsForExtract(int slot) {
        this.setSlotsForExtract(Arrays.asList(slot));
    }

    protected void setSlotsForInsert(int slot) {
        this.setSlotsForInsert(Arrays.asList(slot));
    }

    protected void setSlotsForExtract(List<Integer> slots) {
        this.invHandler.setSlotsExtract(slots);
    }

    protected void setSlotsForExtract(int startInclusive, int endInclusive) {
        this.setSlotsForExtract(IntStream.rangeClosed(startInclusive, endInclusive).boxed().collect(Collectors.toList()));
    }

    protected void setSlotsForInsert(int startInclusive, int endInclusive) {
        this.setSlotsForInsert(IntStream.rangeClosed(startInclusive, endInclusive).boxed().collect(Collectors.toList()));
    }

    protected void setSlotsForInsert(List<Integer> slots) {
        this.invHandler.setSlotsInsert(slots);
    }

    protected void setSlotsForBoth(List<Integer> slots) {
        this.invHandler.setSlotsInsert(slots);
        this.invHandler.setSlotsExtract(slots);
    }

    protected void setSlotsForBoth() {
        this.setSlotsForBoth(IntStream.rangeClosed(0, this.func_70302_i_()).boxed().collect(Collectors.toList()));
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn) && this.invHandler.canInsert(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index != this.getEnergyCost() && this.invHandler.canExtract(index);
    }

    protected void initEnergy(EnergyStore store, int energyCost) {
        this.energyStorage = store;
        this.hasEnergy = true;
        this.setEnergyCost(energyCost);
    }

    public int getEnergyMax() {
        if (this.energyStorage == null) {
            return 0;
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergyCurrent() {
        if (this.energyStorage == null) {
            return 0;
        }
        return this.energyStorage.getEnergyStored();
    }

    public void setEnergyCurrent(int f) {
        this.energyStorage.setEnergyStored(f);
    }

    public int getEnergyCost() {
        return this.energyCost;
    }

    public void consumeEnergy() {
        if (!this.field_145850_b.field_72995_K && this.getEnergyCost() > 0 && this.getEnergyCurrent() >= this.getEnergyCost()) {
            this.energyStorage.extractEnergy(this.getEnergyCost(), false);
            this.func_70296_d();
        }
    }

    public int[] getFieldArray(int length) {
        return IntStream.rangeClosed(0, length - 1).toArray();
    }

    public boolean isDoingWork() {
        return super.isRunning() && this.hasEnoughEnergy();
    }

    public boolean updateEnergyIsBurning() {
        if (this.getEnergyCost() > 0) {
            if (this.hasEnoughEnergy()) {
                this.consumeEnergy();
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean hasEnoughEnergy() {
        if (this.getEnergyCost() == 0) {
            return true;
        }
        return this.getEnergyCurrent() >= this.getEnergyCost();
    }

    protected boolean updateTimerIsZero() {
        this.timer -= this.getSpeed();
        if (this.timer < 0) {
            this.timer = 0;
        }
        return this.timer == 0;
    }

    public String func_70005_c_() {
        if (this.func_145838_q() == null) {
            return "";
        }
        return this.func_145838_q().func_149739_a() + ".name";
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inv.size(); ++i) {
            this.inv.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    protected void shiftAllUp() {
        this.shiftAllUp(0);
    }

    protected void shiftAllUp(int endOffset) {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < this.func_70302_i_() - endOffset - 1; ++i) {
                this.shiftPairUp(i, i + 1);
            }
        }
    }

    protected void shiftPairUp(int low, int high) {
        ItemStack main = this.func_70301_a(low);
        ItemStack second = this.func_70301_a(high);
        if (main.func_190926_b() && !second.func_190926_b()) {
            this.func_70299_a(high, ItemStack.field_190927_a);
            this.func_70299_a(low, second);
        } else if (!main.func_190926_b() && !second.func_190926_b() && ItemStack.func_179545_c((ItemStack)main, (ItemStack)second) && UtilNBT.stacksTagsEqual(main, second)) {
            ItemStack test = main.func_77946_l();
            test.func_190920_e(second.func_190916_E() + main.func_190916_E());
            if (this.func_94041_b(low, test) && main.func_190916_E() + second.func_190916_E() < 64) {
                main.func_190920_e(second.func_190916_E() + main.func_190916_E());
                second.func_190920_e(0);
            }
        }
    }

    public int func_70302_i_() {
        return this.inv.size();
    }

    public ItemStack func_70301_a(int index) {
        if (index < 0 || index >= this.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.inv.get(index);
    }

    public ItemStack decrStackSize(int index) {
        return this.func_70298_a(index, 1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (!stack.func_190926_b()) {
            if (stack.func_77976_d() <= count) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            } else if ((stack = stack.func_77979_a(count)).func_77976_d() == 0) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        if (!stack.func_190926_b() && stack.func_77976_d() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.inv.set(index, (Object)stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        return IntStream.range(0, this.func_70302_i_()).toArray();
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    private void readInvoFromNBT(NBTTagCompound tagCompound) {
        NBTTagList tagList = tagCompound.func_150295_c(NBT_INV, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c(NBT_SLOT);
            if (slot < 0 || slot >= this.inv.size()) continue;
            this.inv.set((int)slot, (Object)UtilNBT.itemFromNBT(tag));
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.readInvoFromNBT(compound);
        this.renderParticles = compound.func_74762_e(NBT_RENDER);
        this.speed = compound.func_74762_e(NBT_SPEED);
        this.needsRedstone = compound.func_74762_e(NBT_REDST);
        this.timer = compound.func_74762_e(NBT_TIMER);
        if (this.hasEnergy && compound.func_74764_b(NBT_ENERGY)) {
            CapabilityEnergy.ENERGY.readNBT((Object)this.energyStorage, null, compound.func_74781_a(NBT_ENERGY));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeInvoToNBT(compound);
        compound.func_74768_a(NBT_RENDER, this.renderParticles);
        compound.func_74768_a(NBT_SPEED, this.speed);
        compound.func_74768_a(NBT_TIMER, this.timer);
        compound.func_74768_a(NBT_REDST, this.needsRedstone);
        if (this.hasEnergy && this.energyStorage != null) {
            compound.func_74782_a(NBT_ENERGY, CapabilityEnergy.ENERGY.writeNBT((Object)this.energyStorage, null));
        }
        return super.func_189515_b(compound);
    }

    private void writeInvoToNBT(NBTTagCompound compound) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.size(); ++i) {
            ItemStack stack = (ItemStack)this.inv.get(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a(NBT_SLOT, (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a(NBT_INV, (NBTBase)itemList);
    }

    public boolean func_145842_c(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            this.func_174885_b(id, value);
            return true;
        }
        return super.func_145842_c(id, value);
    }

    public ItemStack tryMergeStackIntoSlot(ItemStack held, int furnaceSlot) {
        ItemStack current = this.func_70301_a(furnaceSlot);
        boolean success = false;
        if (current.func_190926_b()) {
            this.func_70299_a(furnaceSlot, held);
            held = ItemStack.field_190927_a;
            success = true;
        } else if (held.func_77969_a(current)) {
            success = true;
            UtilItemStack.mergeItemsBetweenStacks(held, current);
        }
        if (success) {
            if (held != ItemStack.field_190927_a && held.func_77976_d() == 0) {
                held = ItemStack.field_190927_a;
            }
            this.func_70296_d();
        }
        return held;
    }

    public int[] getFieldOrdinals() {
        return new int[0];
    }

    public int getSpeed() {
        if (this.getEnergyCost() == 0) {
            return this.speed;
        }
        if (this.getEnergyCurrent() == 0) {
            return 0;
        }
        return Math.max(this.speed, 1);
    }

    public void setSpeed(int value) {
        if (value < 0) {
            value = 0;
        }
        this.speed = Math.min(value, 10);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.func_70302_i_() > 0) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY && this.energyStorage != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.invHandler);
        }
        if (this.hasEnergy && capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected boolean isInventoryFull() {
        return this.isInventoryFull(0);
    }

    protected boolean isInventoryFull(int start) {
        for (int i = start; i < this.inv.size(); ++i) {
            if (!((ItemStack)this.inv.get(i)).func_190926_b() && ((ItemStack)this.inv.get(i)).func_190916_E() >= ((ItemStack)this.inv.get(i)).func_77976_d()) continue;
            return false;
        }
        return true;
    }

    protected boolean inventoryHasRoom(int start, ItemStack wouldInsert) {
        int emptySlots = 0;
        for (int i = start; i < this.inv.size(); ++i) {
            ItemStack invStack = (ItemStack)this.inv.get(i);
            if (invStack.func_190926_b()) {
                return true;
            }
            if (!ItemStack.func_179545_c((ItemStack)invStack, (ItemStack)wouldInsert)) continue;
            emptySlots += invStack.func_77976_d() - invStack.func_190916_E();
        }
        return emptySlots >= wouldInsert.func_190916_E();
    }

    protected boolean isInventoryEmpty() {
        for (int i = 0; i < this.inv.size(); ++i) {
            if (((ItemStack)this.inv.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean isSetRenderGlobally() {
        return this.setRenderGlobally;
    }

    public void setSetRenderGlobally(boolean setRenderGlobally) {
        this.setRenderGlobally = setRenderGlobally;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        if (this.isSetRenderGlobally()) {
            return 65536.0;
        }
        return super.func_145833_n();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isSetRenderGlobally()) {
            return TileEntity.INFINITE_EXTENT_AABB;
        }
        return super.getRenderBoundingBox();
    }

    public void readStackWrappers(NonNullList<StackWrapper> stacksWrapped, NBTTagCompound compound) {
        NBTTagList invList = compound.func_150295_c("ghostSlots", 10);
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = invList.func_150305_b(i);
            byte slot = stackTag.func_74771_c(NBT_SLOT);
            stacksWrapped.set((int)slot, (Object)StackWrapper.loadStackWrapperFromNBT(stackTag));
        }
    }

    public void writeStackWrappers(NonNullList<StackWrapper> stacksWrapped, NBTTagCompound compound) {
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < stacksWrapped.size(); ++i) {
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a(NBT_SLOT, (byte)i);
            ((StackWrapper)stacksWrapped.get(i)).writeToNBT(stackTag);
            invList.func_74742_a((NBTBase)stackTag);
        }
        compound.func_74782_a("ghostSlots", (NBTBase)invList);
    }

    protected void tryOutputPower(int TRANSFER_ENERGY_PER_TICK) {
        List<EnumFacing> targetFaces = Arrays.asList(EnumFacing.values());
        Collections.shuffle(targetFaces);
        for (EnumFacing myFacingDir : targetFaces) {
            TileEntityCableBase cable;
            int drain;
            BlockPos posTarget = this.field_174879_c.func_177972_a(myFacingDir);
            if (!this.hasCapability(CapabilityEnergy.ENERGY, myFacingDir)) continue;
            IEnergyStorage handlerHere = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, myFacingDir);
            TileEntity tileTarget = this.field_145850_b.func_175625_s(posTarget);
            if (tileTarget == null) continue;
            IEnergyStorage handlerOutput = (IEnergyStorage)tileTarget.getCapability(CapabilityEnergy.ENERGY, myFacingDir.func_176734_d());
            if (handlerHere == null || handlerOutput == null || !handlerHere.canExtract() || !handlerOutput.canReceive() || (drain = handlerHere.extractEnergy(TRANSFER_ENERGY_PER_TICK, true)) <= 0) continue;
            int filled = handlerOutput.receiveEnergy(drain, false);
            handlerHere.extractEnergy(filled, false);
            if (!(tileTarget instanceof TileEntityCableBase) || !(cable = (TileEntityCableBase)tileTarget).isEnergyPipe()) continue;
            cable.updateIncomingEnergyFace(myFacingDir.func_176734_d());
        }
    }

    protected List<EnumFacing> getSidesNotFacing() {
        EnumFacing in = this.getCurrentFacing();
        ArrayList<EnumFacing> sidesOut = new ArrayList<EnumFacing>();
        for (EnumFacing s : EnumFacing.values()) {
            if (s == in) continue;
            sidesOut.add(s);
        }
        Collections.shuffle(sidesOut);
        return sidesOut;
    }

    public void setEnergyCost(int energyCost) {
        this.energyCost = energyCost;
    }

    @Override
    public boolean isRunning() {
        this.getEnergyCost();
        this.hasEnoughEnergy();
        return super.isRunning();
    }
}

