/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.crafttweaker;

import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.machines.EnderTableRecipeHandler;
import shetiphian.terraqueous.modintegration.crafttweaker.EnderTableButtonOption;
import shetiphian.terraqueous.modintegration.crafttweaker.EnderTableRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terraqueous.EnderTable")
@ZenRegister
@ModOnly(value="terraqueous")
public class EnderTable {
    @ZenMethod
    public static EnderTableButtonOption buttonOption(IItemStack result, int experienceCost, float enchantPower, String tooltip, @Optional IIngredient inputMaterial) {
        return EnderTable.buttonOption(result, experienceCost, enchantPower, tooltip, true, inputMaterial);
    }

    @ZenMethod
    public static EnderTableButtonOption buttonOption(IItemStack result, int experienceCost, float enchantPower, String tooltip, boolean obfuscateTooltip, @Optional IIngredient inputMaterial) {
        if (result == null || result.getAmount() == 0) {
            Values.logTerraqueous.error("Skipping invalid EnderTable.buttonOption from CraftTweaker with tooltip: '" + tooltip + "' -- 'result' is null");
            return null;
        }
        return EnderTableButtonOption.create(result, inputMaterial, experienceCost, enchantPower, tooltip, obfuscateTooltip);
    }

    @ZenMethod
    public static void addRecipe(IItemStack result, IIngredient inputItem, int experienceCost, float enchantPower, String tooltip, @Optional IIngredient inputMaterial) {
        EnderTable.addRecipe(result, inputItem, experienceCost, enchantPower, tooltip, true, inputMaterial);
    }

    @ZenMethod
    public static void addRecipe(IItemStack result, IIngredient inputItem, int experienceCost, float enchantPower, String tooltip, boolean obfuscateTooltip, @Optional IIngredient inputMaterial) {
        if (result == null || result.getAmount() == 0) {
            Values.logTerraqueous.error("Skipping invalid EnderTable.addRecipe from CraftTweaker with tooltip: '" + tooltip + "' -- 'result' is null");
            return;
        }
        if (inputItem == null || inputItem.getAmount() == 0) {
            Values.logTerraqueous.error("Skipping invalid EnderTable.addRecipe from CraftTweaker with tooltip: '" + tooltip + "' -- 'inputItem' is null");
            return;
        }
        EnderTableRecipe recipe = EnderTableRecipe.create(result, inputItem, experienceCost, enchantPower, tooltip, obfuscateTooltip, inputMaterial);
        if (recipe != null) {
            EnderTableRecipeHandler.INSTANCE.addEnderTableRecipe(recipe);
        }
    }

    @ZenMethod
    public static void addRecipe(IIngredient inputItem, EnderTableButtonOption first, @Optional EnderTableButtonOption second, @Optional EnderTableButtonOption third) {
        if (inputItem == null || inputItem.getAmount() == 0) {
            Values.logTerraqueous.error("Skipping invalid EnderTableRecipe from CraftTweaker: inputItem can not be null");
            return;
        }
        if (first == null && second == null && third == null) {
            Values.logTerraqueous.error("Skipping invalid EnderTableRecipe from CraftTweaker: all button options are null");
            return;
        }
        EnderTableRecipe recipe = EnderTableRecipe.create(inputItem, first, second, third);
        if (recipe != null) {
            EnderTableRecipeHandler.INSTANCE.addEnderTableRecipe(recipe);
        }
    }
}

