/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration;

import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.modintegration.bc.BC_Comms;
import shetiphian.terraqueous.modintegration.forestry.Forestry_Comms;
import shetiphian.terraqueous.modintegration.pixelpowers.PixPow_Comms;

public class ModIntegration {
    private static String base = "shetiphian.terraqueous.modintegration.";

    public void preInit() {
        ClassLoader classLoader = Terraqueous.class.getClassLoader();
        if (Configuration.INTEGRATION.enableIndustrialForegoing) {
            this.loadAPI(classLoader, "mfr.MFR_Active", "preInit");
        }
    }

    public void load() {
        this.loadAPIs();
        this.sendComms();
    }

    private void loadAPIs() {
        ClassLoader classLoader = Terraqueous.class.getClassLoader();
        if (Configuration.INTEGRATION.enableBaubles) {
            this.loadAPI(classLoader, "baubles.Baubles_Active", "init");
        }
        if (Configuration.INTEGRATION.enableForestry) {
            this.loadAPI(classLoader, "forestry.Forestry_Active", "init");
        }
        if (Configuration.INTEGRATION.enableIndustrialForegoing) {
            this.loadAPI(classLoader, "mfr.MFR_Active", "init");
        }
        if (Configuration.INTEGRATION.enableOpenComputers) {
            this.loadAPI(classLoader, "opencomputers.OpenComputer_Active", "init");
        }
        this.loadAPI(classLoader, "power.EnergyUnits", "init");
        this.loadAPI(classLoader, "power.ForgeUnits", "init");
        this.loadAPI(classLoader, "power.ImmersiveFlux", "init");
        this.loadAPI(classLoader, "power.Joules", "init");
        this.loadAPI(classLoader, "power.RedstoneFlux", "init");
        this.loadAPI(classLoader, "power.Tesla", "init");
        this.loadAPI(classLoader, "repair.Basic", "init");
        this.loadAPI(classLoader, "repair.TiC", "init");
    }

    private void loadAPI(ClassLoader classLoader, String name, String method) {
        try {
            classLoader.loadClass(base + name).getMethod(method, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendComms() {
        FMLInterModComms.sendMessage((String)"shetiphiancore", (String)"loadGuideFile", (String)"Terraqueous:terraqueous.json");
        if (Loader.isModLoaded((String)"pixelpowers")) {
            PixPow_Comms.sendComms();
        }
        if (Configuration.INTEGRATION.enableBuildCraft && Loader.isModLoaded((String)"buildCraft|transport")) {
            BC_Comms.sendComms();
        }
        if (Configuration.INTEGRATION.enableForestry && Loader.isModLoaded((String)"forestry")) {
            Forestry_Comms.sendComms();
        }
        if (Configuration.INTEGRATION.enableWAILA && Loader.isModLoaded((String)"waila")) {
            FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)(base + "waila.WailaDataProvider.callbackRegister"));
        }
    }
}

