/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockFlowers;
import shetiphian.terraqueous.common.worldgen.GenBase;

public class GenFlowers
extends GenBase {
    private static List<Integer> forestFlowers = Arrays.asList(2, 4, 5, 6, 7, 8, 13);
    private static List<Integer> plainsFlowers = Arrays.asList(0, 1, 5, 9, 11, 13, 14, 15);
    private static List<Integer> mountainFlowers = Arrays.asList(3, 5, 9);
    private static List<Integer> waterFlowers = Arrays.asList(3, 6, 10, 12);
    private static List<Integer> jungleFlowers = Arrays.asList(2, 5, 6, 7, 8, 13);
    private static List<Integer> magicFlowers = Arrays.asList(4);
    private static List<Integer> allFlowers = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);

    @Override
    public void generate(Random random, World world, BlockPos pos, ChunkPos chunkPos) {
        if (Values.blockFlowerSingle == null && Values.blockFlowerCluster == null || !Configuration.GENERATOR.generateFlowers) {
            return;
        }
        if (!this.canGenerateType(world, chunkPos, random, DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            return;
        }
        Configuration.Menu_Generator.SubMenu_Flowers config = Configuration.GENERATOR.FLOWERS;
        int value = random.nextInt(100);
        if (this.ignoreBiome && value >= config.chunkChance) {
            return;
        }
        List<Integer> flowers = this.getFlowersForBiome(world.func_175726_f(pos = this.getRandomXZ(random, pos)).func_177411_a(pos, world.func_72959_q()), value);
        if (!flowers.isEmpty()) {
            IBlockState state;
            if (this.nearWater(world, pos = this.getTopBlock(world, pos))) {
                flowers.addAll(waterFlowers);
            }
            if ((state = this.getFlowerForMeta(flowers.get(random.nextInt(flowers.size())), random.nextBoolean())) != null && ((BlockFlowers)state.func_177230_c()).func_180671_f(world, pos, state)) {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)false);
            }
        }
    }

    private List<Integer> getFlowersForBiome(Biome biome, int value) {
        if (this.ignoreBiome) {
            return allFlowers;
        }
        Configuration.Menu_Generator.SubMenu_Flowers config = Configuration.GENERATOR.FLOWERS;
        ArrayList<Integer> flowerList = new ArrayList<Integer>();
        if (BiomeDictionary.hasAnyType((Biome)biome)) {
            Set types = BiomeDictionary.getTypes((Biome)biome);
            for (BiomeDictionary.Type type : types) {
                if (type == BiomeDictionary.Type.FOREST && value < config.biomeChance_Forest) {
                    flowerList.addAll(forestFlowers);
                }
                if (type == BiomeDictionary.Type.PLAINS && value < config.biomeChance_Plains) {
                    flowerList.addAll(plainsFlowers);
                }
                if (type == BiomeDictionary.Type.MOUNTAIN && value < config.biomeChance_Mountain) {
                    flowerList.addAll(mountainFlowers);
                }
                if (type == BiomeDictionary.Type.WATER && value < config.biomeChance_Water) {
                    flowerList.addAll(waterFlowers);
                }
                if (type == BiomeDictionary.Type.JUNGLE && value < config.biomeChance_Jungle) {
                    flowerList.addAll(jungleFlowers);
                }
                if (type != BiomeDictionary.Type.MAGICAL || value >= config.biomeChance_Magical) continue;
                flowerList.addAll(magicFlowers);
            }
        }
        return flowerList;
    }

    private boolean nearWater(World world, BlockPos pos) {
        BlockPos.PooledMutableBlockPos sPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int sX = pos.func_177958_n() - 4; sX < pos.func_177958_n() + 4; ++sX) {
            for (int sY = pos.func_177956_o() - 4; sY < pos.func_177956_o() + 1; ++sY) {
                for (int sZ = pos.func_177952_p() - 4; sZ < pos.func_177952_p() + 4; ++sZ) {
                    IBlockState state = world.func_180495_p((BlockPos)sPos.func_181079_c(sX, sY, sZ));
                    if (!(state.func_185904_a() instanceof MaterialLiquid)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private IBlockState getFlowerForMeta(int meta, boolean single) {
        Block flower;
        if (Values.blockFlowerSingle != null && Values.blockFlowerCluster != null) {
            flower = single ? Values.blockFlowerSingle : Values.blockFlowerCluster;
        } else {
            Block block = flower = Values.blockFlowerCluster != null ? Values.blockFlowerCluster : Values.blockFlowerSingle;
        }
        if (flower instanceof BlockFlowers) {
            return flower.func_176203_a(meta);
        }
        return null;
    }

    public void registerForBonemeal() {
        for (Biome biome : Biome.field_185377_q) {
            List<Integer> flowers = this.getFlowersForBiome(biome, -1);
            if (flowers.isEmpty()) continue;
            for (int meta : flowers) {
                IBlockState state = this.getFlowerForMeta(meta, true);
                if (state == null) continue;
                biome.addFlower(state, 5);
            }
        }
    }
}

