/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.api.plant.PlantAPI;

public class PlantFunctions {
    private static Table<PlantAPI.PlantType, PlantAPI.PlantEvent, int[]> plantChanceTable = HashBasedTable.create();
    private static int[] saplingGrow = new int[10];
    private static int[] fruitFlower = new int[10];
    private static int[] fruitGrow = new int[10];
    private static int[] fruitFall = new int[10];
    private static int[] saplingDrop = new int[10];

    private static Table<PlantAPI.PlantType, PlantAPI.PlantEvent, int[]> buildPlantChanceTable() {
        Configuration.Menu_Tweaks.SubMenu_Plants cfg = Configuration.TWEAKS.PLANTS;
        HashBasedTable table = HashBasedTable.create();
        table.put((Object)PlantAPI.PlantType.FLOWER, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)PlantFunctions.arrayOf(cfg.flower_Grow_normal, cfg.flower_Grow_rain));
        table.put((Object)PlantAPI.PlantType.FLOWER, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)PlantFunctions.arrayOf(cfg.flower_Spread_normal, cfg.flower_Spread_rain));
        table.put((Object)PlantAPI.PlantType.GRASS, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)PlantFunctions.arrayOf(cfg.grass_Grow_normal, cfg.grass_Grow_rain));
        table.put((Object)PlantAPI.PlantType.GRASS, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)PlantFunctions.arrayOf(cfg.grass_Spread_normal, cfg.grass_Spread_rain));
        table.put((Object)PlantAPI.PlantType.PINEAPPLE, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)PlantFunctions.arrayOf(cfg.pineapple_PlantGrow_normal, cfg.pineapple_PlantGrow_rain));
        table.put((Object)PlantAPI.PlantType.PINEAPPLE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)PlantFunctions.arrayOf(cfg.pineapple_FruitGrow_normal, cfg.pineapple_FruitGrow_rain));
        table.put((Object)PlantAPI.PlantType.CACTUS, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)PlantFunctions.arrayOf(cfg.cactus_PlantGrow_day, cfg.cactus_PlantGrow_night));
        table.put((Object)PlantAPI.PlantType.CACTUS, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)PlantFunctions.arrayOf(cfg.cactus_FruitGrow_day, cfg.cactus_FruitGrow_night));
        table.put((Object)PlantAPI.PlantType.GRAPEVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)PlantFunctions.arrayOf(cfg.grapevine_Spread_normal, cfg.grapevine_Spread_rain));
        table.put((Object)PlantAPI.PlantType.GRAPEVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)PlantFunctions.arrayOf(cfg.grapevine_FruitGrow_normal, cfg.grapevine_FruitGrow_rain));
        table.put((Object)PlantAPI.PlantType.LIFEVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)PlantFunctions.arrayOf(cfg.lifevine_Spread_normal, cfg.lifevine_Spread_rain));
        table.put((Object)PlantAPI.PlantType.LIFEVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)PlantFunctions.arrayOf(cfg.lifevine_FruitGrow_normal, cfg.lifevine_FruitGrow_rain));
        table.put((Object)PlantAPI.PlantType.DEATHVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)PlantFunctions.arrayOf(cfg.deathvine_Spread_normal, cfg.deathvine_Spread_rain));
        table.put((Object)PlantAPI.PlantType.DEATHVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)PlantFunctions.arrayOf(cfg.deathvine_FruitGrow_normal, cfg.deathvine_FruitGrow_rain));
        return table;
    }

    public static void load() {
        plantChanceTable = PlantFunctions.buildPlantChanceTable();
        Configuration.Menu_Tweaks.SubMenu_Trees.ITreeConfig tree = Configuration.TWEAKS.TREES.SAPLING_GROW;
        saplingGrow = PlantFunctions.arrayOf(tree.apple, tree.cherry, tree.orange, tree.pear, tree.peach, tree.mango, tree.lemon, tree.plum, tree.coconut, tree.banana);
        tree = Configuration.TWEAKS.TREES.FLOWER_GROW;
        int[] nArray = new int[10];
        nArray[0] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FlowerGrow)tree).apple;
        nArray[1] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FlowerGrow)tree).cherry;
        nArray[2] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FlowerGrow)tree).orange;
        nArray[3] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FlowerGrow)tree).pear;
        nArray[4] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FlowerGrow)tree).peach;
        nArray[5] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FlowerGrow)tree).mango;
        nArray[6] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FlowerGrow)tree).lemon;
        nArray[7] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FlowerGrow)tree).plum;
        nArray[8] = 0;
        nArray[9] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FlowerGrow)tree).banana;
        fruitFlower = PlantFunctions.arrayOf(nArray);
        tree = Configuration.TWEAKS.TREES.FRUIT_GROW;
        fruitGrow = PlantFunctions.arrayOf(((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitGrow)tree).apple, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitGrow)tree).cherry, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitGrow)tree).orange, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitGrow)tree).pear, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitGrow)tree).peach, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitGrow)tree).mango, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitGrow)tree).lemon, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitGrow)tree).plum, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitGrow)tree).coconut, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitGrow)tree).banana);
        tree = Configuration.TWEAKS.TREES.FRUIT_FALL;
        int[] nArray2 = new int[10];
        nArray2[0] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitFall)tree).apple;
        nArray2[1] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitFall)tree).cherry;
        nArray2[2] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitFall)tree).orange;
        nArray2[3] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitFall)tree).pear;
        nArray2[4] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitFall)tree).peach;
        nArray2[5] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitFall)tree).mango;
        nArray2[6] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitFall)tree).lemon;
        nArray2[7] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitFall)tree).plum;
        nArray2[8] = ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_FruitFall)tree).coconut;
        nArray2[9] = 0;
        fruitFall = PlantFunctions.arrayOf(nArray2);
        tree = Configuration.TWEAKS.TREES.SAPLING_DROP;
        saplingDrop = PlantFunctions.arrayOf(((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_SaplingDrop)tree).apple, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_SaplingDrop)tree).cherry, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_SaplingDrop)tree).orange, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_SaplingDrop)tree).pear, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_SaplingDrop)tree).peach, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_SaplingDrop)tree).mango, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_SaplingDrop)tree).lemon, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_SaplingDrop)tree).plum, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_SaplingDrop)tree).coconut, ((Configuration.Menu_Tweaks.SubMenu_Trees.SubMenu_SaplingDrop)tree).banana);
    }

    private static int[] arrayOf(int ... input) {
        for (int index = 0; index < input.length; ++index) {
            if (input[index] >= 0) continue;
            input[index] = 0;
        }
        return input;
    }

    public static boolean canGrow(World world, BlockPos pos, PlantAPI.PlantType plant) {
        if (!plantChanceTable.contains((Object)plant, (Object)PlantAPI.PlantEvent.PlantGrow)) {
            return false;
        }
        int[] chances = (int[])plantChanceTable.get((Object)plant, (Object)PlantAPI.PlantEvent.PlantGrow);
        int index = plant == PlantAPI.PlantType.CACTUS ? (world.func_72935_r() ? 0 : 1) : (world.func_72867_j(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.PlantGrow, plant, (IBlockAccess)world, pos, chances[index]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean canSpread(World world, BlockPos pos, PlantAPI.PlantType plant) {
        if (!plantChanceTable.contains((Object)plant, (Object)PlantAPI.PlantEvent.PlantSpread)) {
            return false;
        }
        int[] chances = (int[])plantChanceTable.get((Object)plant, (Object)PlantAPI.PlantEvent.PlantSpread);
        int index = plant == PlantAPI.PlantType.CACTUS ? (world.func_72935_r() ? 0 : 1) : (world.func_72867_j(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.PlantSpread, plant, (IBlockAccess)world, pos, chances[index]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean canGrowFruit(World world, BlockPos pos, PlantAPI.PlantType plant) {
        if (!plantChanceTable.contains((Object)plant, (Object)PlantAPI.PlantEvent.FruitGrow)) {
            return false;
        }
        int[] chances = (int[])plantChanceTable.get((Object)plant, (Object)PlantAPI.PlantEvent.FruitGrow);
        int index = plant == PlantAPI.PlantType.CACTUS ? (world.func_72935_r() ? 0 : 1) : (world.func_72867_j(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.FruitGrow, plant, (IBlockAccess)world, pos, chances[index]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static byte getMaxPlacementAttempts(IBlockAccess world, BlockPos pos, PlantAPI.PlantType plant) {
        switch (plant) {
            case FLOWER: {
                return PlantAPI.getPlacementValue(PlantAPI.PlacementValue.FlowerMaxAttempts, world, pos, 5);
            }
            case GRASS: {
                return PlantAPI.getPlacementValue(PlantAPI.PlacementValue.GrassMaxAttempts, world, pos, 5);
            }
        }
        return 0;
    }

    public static byte[] getSpreadRadius(IBlockAccess world, BlockPos pos, PlantAPI.PlantType plant) {
        byte radius;
        switch (plant) {
            case FLOWER: {
                radius = PlantAPI.getPlacementValue(PlantAPI.PlacementValue.FlowerSpreadRadius, world, pos, 3);
                break;
            }
            case GRASS: {
                radius = PlantAPI.getPlacementValue(PlantAPI.PlacementValue.GrassSpreadRadius, world, pos, 3);
                break;
            }
            default: {
                radius = 0;
            }
        }
        byte[] spreadRadius = new byte[]{radius > 0 ? radius : (byte)1, (byte)(radius / 3 * 2) > 0 ? (byte)(radius / 3 * 2) : (byte)1};
        return spreadRadius;
    }

    public static boolean canSaplingGrow(IBlockAccess world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.SaplingGrow, tree, world, pos, saplingGrow[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean growFruitFlower(IBlockAccess world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitFlower, tree, world, pos, fruitFlower[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean growFruit(IBlockAccess world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitGrow, tree, world, pos, fruitGrow[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean dropFruit(IBlockAccess world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = Configuration.TWEAKS.TREES.fruitStaysOnTrees ? 0 : PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitFall, tree, world, pos, fruitFall[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean dropSapling(IBlockAccess world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.SaplingDrop, tree, world, pos, saplingDrop[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }
}

