/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.misc.InfiniteTank;
import shetiphian.terraqueous.modintegration.baubles.Baubles_Base;

public class ItemWaterPearl
extends Item {
    public ItemWaterPearl() {
        this.func_77637_a((CreativeTabs)Values.tabTerraqueous);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (Configuration.TWEAKS.WATER_PEARL.enableWorldPlacement) {
            BlockPos offsetPos;
            RayTraceResult raytraceresult = this.func_77621_a(world, player, false);
            if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            BlockPos hitPos = raytraceresult.func_178782_a();
            if (!world.func_175660_a(player, hitPos)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            boolean replaceable = world.func_180495_p(hitPos).func_177230_c().func_176200_f((IBlockAccess)world, hitPos);
            BlockPos blockPos = offsetPos = replaceable && raytraceresult.field_178784_b == EnumFacing.UP ? hitPos : hitPos.func_177972_a(raytraceresult.field_178784_b);
            if (!player.func_175151_a(offsetPos, raytraceresult.field_178784_b, stack)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            if (this.tryPlaceContainedLiquid(player, world, offsetPos)) {
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, offsetPos, stack);
                }
                player.func_71029_a(StatList.func_188057_b((Item)this));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private boolean tryPlaceContainedLiquid(@Nullable EntityPlayer player, World world, BlockPos pos) {
        if (Configuration.TWEAKS.WATER_PEARL.enableWorldPlacement) {
            IBlockState state = world.func_180495_p(pos);
            Material material = state.func_185904_a();
            boolean solid = !material.func_76220_a();
            boolean replaceable = state.func_177230_c().func_176200_f((IBlockAccess)world, pos);
            if (!(world.func_175623_d(pos) || solid || replaceable)) {
                return false;
            }
            if (world.field_73011_w.func_177500_n()) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                for (int counter = 0; counter < 8; ++counter) {
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                if (!world.field_72995_K && (solid || replaceable) && !material.func_76224_d()) {
                    world.func_175655_b(pos, true);
                }
                world.func_184133_a(player, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_180501_a(pos, Blocks.field_150358_i.func_176223_P(), 11);
            }
            return true;
        }
        return false;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return new ItemStack(Values.itemWaterPearl);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (itemSlot >= 0 && itemSlot <= 8) {
            ItemWaterPearl.resetAir(entity);
        }
    }

    public static void resetAir(Entity entity) {
        if (Configuration.TWEAKS.WATER_PEARL.enableWaterBreathing && entity instanceof EntityPlayer && entity.func_70090_H()) {
            entity.func_70050_g(Math.min(300, entity.func_70086_ai() + 2));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return stack.func_190926_b() ? null : new CapabilityProvider(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advancedTooltips) {
        String text = "";
        if (Configuration.TWEAKS.WATER_PEARL.enableInfiniteWaterBucket) {
            text = text + Localization.get((String)"info.terraqueous.waterpearl.bucket.txt");
        }
        if (Configuration.TWEAKS.WATER_PEARL.enableInfiniteWaterTank) {
            text = text + (text.isEmpty() ? "" : ", ");
            text = text + Localization.get((String)"info.terraqueous.waterpearl.tank.txt");
        }
        if (Configuration.TWEAKS.WATER_PEARL.enableWorldPlacement) {
            text = text + (text.isEmpty() ? "" : ", ");
            text = text + Localization.get((String)"info.terraqueous.waterpearl.placement.txt");
        }
        if (!text.isEmpty()) {
            tooltip.add(Localization.get((String)"info.terraqueous.waterpearl.water.txt") + " " + text);
        }
        if (Configuration.TWEAKS.WATER_PEARL.enableWaterBreathing) {
            tooltip.add(Localization.get((String)"info.terraqueous.waterpearl.breath.txt"));
        }
    }

    private static class CapabilityProvider
    implements ICapabilityProvider {
        private final InfiniteTank tank;

        CapabilityProvider(ItemStack stack) {
            this.tank = new InfiniteTank(FluidRegistry.WATER, 1000).setContainer(stack);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return this.getCapability(capability, facing) != null;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            Object bauble = Baubles_Base.INSTANCE.getCapability(capability, "water_pearl");
            if (bauble != null) {
                return (T)bauble;
            }
            if (Configuration.TWEAKS.WATER_PEARL.enableInfiniteWaterTank && (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                return (T)((Object)this.tank);
            }
            return null;
        }
    }
}

