/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.item.ItemToolWithDamageSource;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.item.IToolMode;

public class ItemScythe
extends ItemToolWithDamageSource
implements IToolMode {
    public ItemScythe() {
        super(3.0f, -1.0f, Item.ToolMaterial.IRON, Values.damageScythe);
        this.func_77637_a((CreativeTabs)Values.tabTerraqueous);
        this.field_77777_bU = 1;
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{CreativeTabs.field_78040_i, Values.tabTerraqueous};
    }

    public void getSubItems(NonNullList<ItemStack> list) {
        list.add((Object)ItemScythe.newScythe(true));
        list.add((Object)ItemScythe.newScythe(false));
    }

    public static ItemStack newScythe(boolean sickle) {
        ItemStack itemStack = new ItemStack(Values.itemScythe);
        itemStack.func_77982_d(new NBTTagCompound());
        itemStack.func_77978_p().func_74757_a("sickle", sickle);
        return itemStack;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        return block instanceof IPlantable || block instanceof IShearable ? this.field_77864_a : 1.0f;
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + (ItemScythe.isSickle(stack) ? "small" : "large");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advancedTooltips) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            Localization.multiLine((String)"msg.terraqueous.scythe.shift.txt", tooltip);
            tooltip.add(Localization.get((String)"info.terraqueous.scythe.mode.txt"));
            Localization.multiLine((String)("msg.terraqueous.scythe.mode." + ItemScythe.getMode(stack) + ".txt"), tooltip);
        } else {
            if (ItemScythe.isSickle(stack)) {
                tooltip.add(Localization.get((String)"info.terraqueous.scythe.small.txt"));
            } else {
                tooltip.add(Localization.get((String)"info.terraqueous.scythe.large.txt"));
            }
            tooltip.add(Localization.get((String)"info.shetiphian.holdshift.txt"));
        }
        if (!EnchantmentHelper.func_82781_a((ItemStack)stack).isEmpty()) {
            tooltip.add("");
        }
    }

    public static boolean isSickle(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74757_a("sickle", false);
        }
        return stack.func_77978_p().func_74767_n("sickle");
    }

    private static byte getMode(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74774_a("mode", (byte)0);
        }
        return stack.func_77978_p().func_74771_c("mode");
    }

    @Override
    public boolean changeMode(EntityPlayer player, ItemStack stack, boolean next) {
        if (stack != null && stack.func_77973_b() instanceof ItemScythe) {
            int mode = ItemScythe.getMode(stack) + (next ? 1 : -1);
            mode = mode < 0 ? 3 : (mode > 3 ? 0 : mode);
            stack.func_77978_p().func_74774_a("mode", (byte)mode);
            if (player != null) {
                String message = Localization.get((String)"info.terraqueous.scythe.modechanged.txt") + Localization.get((String)("msg.terraqueous.scythe.mode." + mode + ".txt")).replace("<br>", " ");
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketChat((ITextComponent)new TextComponentString(message), ChatType.GAME_INFO));
                } else {
                    Localization.addChat((EntityPlayer)player, (String)message);
                }
            }
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!player.func_70093_af()) {
                stack.func_77978_p().func_74757_a("sickle", !ItemScythe.isSickle(stack));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private void doExtraDrops(EntityPlayer player, ItemStack stack, World world, BlockPos pos, Block block, IBlockState state) {
        boolean isGrass;
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        boolean bl = isGrass = block instanceof BlockTallGrass || block instanceof BlockDoublePlant && state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.GRASS;
        if (isGrass && !ItemScythe.isSickle(stack) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0 && !block.canSilkHarvest(world, pos, state, player)) {
            ItemStack fakeShears = new ItemStack((Item)Items.field_151097_aZ);
            EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)stack), (ItemStack)fakeShears);
            if (block instanceof IShearable && ((IShearable)block).isShearable(fakeShears, (IBlockAccess)world, pos)) {
                List items = ((IShearable)block).onSheared(fakeShears, (IBlockAccess)world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
                for (ItemStack drop : items) {
                    Function.dropItem((World)world, (BlockPos)pos, (ItemStack)drop);
                }
            }
        }
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        Block block = state.func_177230_c();
        if (!player.field_71075_bZ.field_75098_d) {
            if (stack.func_77952_i() + 1 >= stack.func_77958_k() && stack.func_77948_v()) {
                return false;
            }
            this.doExtraDrops(player, stack, world, pos, block, state);
        }
        boolean leaves = block.isLeaves(state, (IBlockAccess)world, pos);
        boolean plant = block instanceof IPlantable;
        if (!leaves && !plant) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        int level = (int)player.field_70163_u + (player.func_70093_af() ? 0 : 1);
        boolean isSickle = ItemScythe.isSickle(stack);
        if (isSickle && pos.func_177956_o() < level || !isSickle && pos.func_177956_o() > level) {
            return false;
        }
        byte mode = ItemScythe.getMode(stack);
        boolean used = false;
        int swingW = ItemScythe.isSickle(stack) ? 1 : 3;
        int swingD = ItemScythe.isSickle(stack) ? 1 : 2;
        for (int sX = -swingW; sX <= swingW; ++sX) {
            for (int sY = -swingD; sY <= swingD; ++sY) {
                for (int sZ = -swingW; sZ <= swingW; ++sZ) {
                    BlockPos sPos;
                    IBlockState sState;
                    Block sBlock;
                    if (sX == 0 && sY == 0 && sZ == 0 || !(sBlock = (sState = world.func_180495_p(sPos = pos.func_177982_a(sX, sY, sZ))).func_177230_c()).canHarvestBlock((IBlockAccess)world, sPos, player)) continue;
                    boolean harvest = false;
                    if (mode == 0) {
                        harvest = leaves && sBlock.isLeaves(sState, (IBlockAccess)world, sPos) || plant && sBlock instanceof IPlantable;
                    } else if (sBlock.isLeaves(sState, (IBlockAccess)world, sPos) || sBlock instanceof IPlantable) {
                        switch (mode) {
                            case 1: {
                                harvest = sBlock == block;
                                break;
                            }
                            case 2: {
                                harvest = sBlock == block && sBlock.func_176201_c(sState) == block.func_176201_c(state);
                                break;
                            }
                            case 3: {
                                harvest = true;
                            }
                        }
                    }
                    if (!harvest) continue;
                    this.doExtraDrops(player, stack, world, sPos, sBlock, sState);
                    if (!player.field_71075_bZ.field_75098_d) {
                        sBlock.func_180657_a(world, player, sPos, sState, world.func_175625_s(sPos), stack);
                        used = true;
                    }
                    sBlock.removedByPlayer(sState, world, sPos, player, true);
                }
            }
        }
        if (used) {
            stack.func_77972_a(1, entity);
        }
        return used;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity victim) {
        return stack.func_77952_i() + 2 >= stack.func_77958_k() && stack.func_77948_v() || super.onLeftClickEntity(stack, player, victim);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, MathHelper.func_76125_a((int)damage, (int)0, (int)this.func_77612_l()));
    }
}

