/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import shetiphian.core.common.FuelHelper;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;

public class ItemBlockSapling
extends ItemBlockMulti
implements FuelHelper.IFuel {
    public ItemBlockSapling(Block block) {
        super(block, "BlockSapling", Values.nameMapper);
    }

    public void getSubItems(NonNullList<ItemStack> list) {
        for (PlantAPI.TreeType treeType : PlantAPI.TreeType.values()) {
            list.add((Object)new ItemStack((Item)this, 1, (int)treeType.getID()));
        }
    }

    public static boolean canPlantSaplingAt(World world, BlockPos pos, PlantAPI.TreeType type) {
        IBlockState gState = world.func_180495_p(pos);
        Block gBlock = gState.func_177230_c();
        boolean canPlant = gBlock.canSustainPlant(gState, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)Blocks.field_150345_g);
        if (!canPlant && type == PlantAPI.TreeType.COCONUT) {
            canPlant = gBlock.canSustainPlant(gState, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)Blocks.field_150434_aF);
        }
        return canPlant;
    }

    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return ItemBlockSapling.canPlantSaplingAt(world, pos, PlantAPI.TreeType.byID(stack.func_77952_i())) && super.func_179222_a(world, pos, side, player, stack);
    }

    public float getItemsSmeltedPerFuel(ItemStack stack) {
        return 0.5f;
    }

    protected void addToNameMap() {
        for (PlantAPI.TreeType tree : PlantAPI.TreeType.values()) {
            this.add(tree.getID(), "trees/", tree.func_176610_l() + "_sapling", tree.func_176610_l());
        }
    }
}

