/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.crafting;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.RecipeHelper;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.machines.EnderTableRecipeHandler;
import shetiphian.terraqueous.api.machines.SimpleEnderTableRecipe;
import shetiphian.terraqueous.common.item.ItemCloudStaff;

public class Recipes {
    public static Recipes INSTANCE = new Recipes();
    private RecipeHelper helper;

    public void loadRecipes() {
        this.helper = new RecipeHelper("terraqueous", Values.logTerraqueous);
        this.rEnderTableRecipes();
        this.rSmeltingRecipes();
        this.rBrewingRecipes();
        this.rStaffRecipes();
    }

    private void rEnderTableRecipes() {
        if (Values.itemCloudTalisman != null) {
            EnderTableRecipeHandler.INSTANCE.addEnderTableRecipe(new SimpleEnderTableRecipe(this.iStack(Values.itemCloudTalisman, new int[0]), this.iStack("talisman_assembled", new int[0]), null, 0, 5, 0.0f, "info.terraqueous.infuse.txt", true));
        }
        if (Values.itemEnderMonocle != null) {
            EnderTableRecipeHandler.INSTANCE.addEnderTableRecipe(new SimpleEnderTableRecipe(this.iStack(Values.itemEnderMonocle, new int[0]), this.iStack(Items.field_151061_bv, new int[0]), "nuggetGold", 9, 5, 0.0f, "info.terraqueous.fusion.txt", true));
        }
    }

    private void rSmeltingRecipes() {
        if (Values.blockPlants != null) {
            this.helper.addSmelting(this.iStack(Items.field_151100_aR, 1, EnumDyeColor.GREEN.func_176767_b()), this.iStack("cactus", new int[0]), 0.2f);
        }
        if (Values.itemMain != null) {
            this.helper.addSmelting(this.iStack("talisman_baked", new int[0]), this.iStack("talisman_unbaked", new int[0]), 0.3f);
            this.helper.addSmelting(this.iStack("burnium_gem", new int[0]), this.iStack("burnium_dust", new int[0]), 2.75f);
            this.helper.addSmelting(this.iStack("endimium_gem", new int[0]), this.iStack("endimium_dust", new int[0]), 2.75f);
            this.helper.addSmelting(this.iStack(Blocks.field_150410_aZ, new int[0]), this.iStack("glass_shard", new int[0]), 0.0f);
            this.helper.addSmelting(this.iStack(Items.field_151079_bi, new int[0]), this.iStack("ender_dust", new int[0]), 1.0f);
            this.helper.addSmelting(this.iStack(Items.field_151042_j, new int[0]), this.iStack("iron_dust", new int[0]), 0.7f);
            this.helper.addSmelting(this.iStack(Items.field_151043_k, new int[0]), this.iStack("gold_dust", new int[0]), 1.0f);
            this.helper.addSmelting(this.iStack(Items.field_151045_i, new int[0]), this.iStack("diamond_dust", new int[0]), 1.5f);
            this.helper.addSmelting(this.iStack(Items.field_151166_bC, new int[0]), this.iStack("emerald_dust", new int[0]), 2.0f);
        }
        if (Values.blockDoodad != null) {
            this.helper.addSmelting(this.iStack(Blocks.field_150359_w, new int[0]), this.iStack("glass_shards", new int[0]), 0.0f);
        }
        if (Values.blockTreeTrunk1 != null) {
            this.helper.addSmelting(this.iStack(Items.field_151044_h, 1, 1), this.iStack(Values.blockTreeTrunk1, 1, Short.MAX_VALUE), 0.15f);
        }
        if (Values.blockTreeTrunk2 != null) {
            this.helper.addSmelting(this.iStack(Items.field_151044_h, 1, 1), this.iStack(Values.blockTreeTrunk2, 1, Short.MAX_VALUE), 0.15f);
        }
    }

    private void rBrewingRecipes() {
        if (Values.itemMain != null) {
            ItemStack splashbottle;
            PotionType burnium = PotionType.func_185168_a((String)"terraqueous:firewater");
            PotionType endimium = PotionType.func_185168_a((String)"terraqueous:displacement");
            PotionType water = PotionType.func_185168_a((String)"water");
            PotionType awkward = PotionType.func_185168_a((String)"awkward");
            ItemStack waterbottle = water != null ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)water) : null;
            ItemStack awkwardbottle = awkward != null ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)awkward) : null;
            ItemStack itemStack = splashbottle = water != null ? PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)water) : null;
            if (burnium != null && burnium != water) {
                ItemStack firewater = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)burnium);
                this.addBrewing(waterbottle, "dustBurnium", firewater);
                this.addBrewing(awkwardbottle, "dustBurnium", PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)burnium));
                this.addBrewing(splashbottle, "dustBurnium", PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)burnium));
            }
            if (endimium != null && endimium != water) {
                ItemStack displacement = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)endimium);
                this.addBrewing(waterbottle, "dustEndimium", displacement);
                this.addBrewing(awkwardbottle, "dustEndimium", PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)endimium));
                this.addBrewing(splashbottle, "dustEndimium", PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)endimium));
            }
        }
    }

    private void addBrewing(ItemStack input, String ingredient, ItemStack output) {
        if (!(input.func_190926_b() || ingredient.isEmpty() || output.func_190926_b())) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingNBT(input.func_77946_l(), ingredient, output.func_77946_l()));
        }
    }

    private void rStaffRecipes() {
        if (Values.itemCloudStaff != null) {
            this.helper.addRecipe("staff-vapor", (IRecipe)new CloudStaffOutputRecipe(this.iStack("water_vapor", 8), ItemCloudStaff.newTool(ItemCloudStaff.EnumMode.VAPOR, true)));
            this.helper.addRecipe("staff-light", (IRecipe)new CloudStaffOutputRecipe(this.iStack("lightcloud_block", 8), ItemCloudStaff.newTool(ItemCloudStaff.EnumMode.LIGHT, true)));
            this.helper.addRecipe("staff-dense", (IRecipe)new CloudStaffOutputRecipe(this.iStack("densecloud_block", 8), ItemCloudStaff.newTool(ItemCloudStaff.EnumMode.DENSE, true)));
            this.helper.addRecipe("staff-storm", (IRecipe)new CloudStaffOutputRecipe(this.iStack("stormcloud_block", 8), ItemCloudStaff.newTool(ItemCloudStaff.EnumMode.STORM, true)));
        }
    }

    private ItemStack iStack(Block block, int ... val) {
        return new ItemStack(block, val.length > 0 ? val[0] : 1, val.length > 1 ? val[1] : 0);
    }

    private ItemStack iStack(Item item, int ... val) {
        return new ItemStack(item, val.length > 0 ? val[0] : 1, val.length > 1 ? val[1] : 0);
    }

    private ItemStack iStack(String name, int ... val) {
        ItemStack stack = Values.stacks.get(name, new int[0]);
        if (stack.func_190926_b()) {
            Values.logTerraqueous.error("Could not find " + name + " in stack map");
            return ItemStack.field_190927_a;
        }
        if (val.length > 0) {
            stack = stack.func_77946_l();
            stack.func_190920_e(val[0]);
        }
        return stack;
    }

    public static class BrewingNBT
    extends BrewingOreRecipe {
        BrewingNBT(ItemStack input, String ingredient, ItemStack output) {
            super(input, ingredient, output);
        }

        public boolean isInput(ItemStack stack) {
            return OreDictionary.itemMatches((ItemStack)this.getInput(), (ItemStack)stack, (boolean)false) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.getInput());
        }
    }

    public static class CloudStaffOutputRecipe
    extends ShapelessRecipes {
        private final ItemCloudStaff.EnumMode mode;

        CloudStaffOutputRecipe(ItemStack output, ItemStack input) {
            super("terraqueous:staff_output", output, NonNullList.func_191197_a((int)1, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input})));
            this.mode = ItemCloudStaff.getEnumMode(input);
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            boolean correct = false;
            for (int column = 0; column < inv.func_174922_i(); ++column) {
                for (int row = 0; row < inv.func_174923_h(); ++row) {
                    ItemCloudStaff.EnumMode stack_mode;
                    ItemStack stack = inv.func_70463_b(row, column);
                    if (stack.func_190926_b()) continue;
                    if (stack.func_77973_b() == Values.itemCloudStaff && (stack_mode = ItemCloudStaff.getEnumMode(stack)) == this.mode && ItemCloudStaff.getBlockCount(stack) >= 8.0) {
                        correct = true;
                        continue;
                    }
                    return false;
                }
            }
            return correct;
        }
    }
}

