/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.IColored;
import shetiphian.core.common.IParticleOverride;
import shetiphian.core.common.MaterialImmovable;
import shetiphian.core.common.ParticleHelper;
import shetiphian.core.common.block.properties.UnlistedPropertyIBlockState;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.fx.FXWaterDrop;
import shetiphian.terraqueous.client.misc.FoliageColor;
import shetiphian.terraqueous.common.item.ItemBlockPergola;
import shetiphian.terraqueous.common.misc.PlantFunctions;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaBase;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaFrame;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaGate;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaWall;

public class BlockPergola
extends Block
implements IShearable,
IBonemealable,
IColored,
IParticleOverride,
IRGB16_Block {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final UnlistedPropertyIBlockState EIBS = UnlistedPropertyIBlockState.create((String)"eibs");
    public static final PropertyEnum<EnumStyle> NDATA = PropertyEnum.func_177709_a((String)"nd", EnumStyle.class);
    public static final PropertyEnum<EnumStyle> EDATA = PropertyEnum.func_177709_a((String)"ed", EnumStyle.class);
    public static final PropertyEnum<EnumStyle> SDATA = PropertyEnum.func_177709_a((String)"sd", EnumStyle.class);
    public static final PropertyEnum<EnumStyle> WDATA = PropertyEnum.func_177709_a((String)"wd", EnumStyle.class);
    public static final PropertyEnum<EnumStyle> XDATA = PropertyEnum.func_177709_a((String)"xd", EnumStyle.class);
    private BlockStateContainer extrasBlockState = new BlockStateContainer((Block)this, new IProperty[]{EDATA, NDATA, SDATA, WDATA, XDATA});

    public BlockPergola() {
        super((Material)MaterialImmovable.TRANSLUCENT);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149675_a(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{VARIANT}, new IUnlistedProperty[]{EIBS});
    }

    public IBlockState func_176203_a(int meta) {
        EnumType type = EnumType.byValue(meta);
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        EnumType type = BlockPergola.getEnumType(state);
        return type.getValue();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityPergolaBase tile = this.getTile(world, pos);
        if (tile != null) {
            state = tile.getActualState(state);
        }
        return state;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityPergolaBase tile = this.getTile(world, pos);
        state = this.func_176221_a(state, world, pos);
        IExtendedBlockState estate = (IExtendedBlockState)state;
        if (tile != null) {
            estate = estate.withProperty((IUnlistedProperty)EIBS, (Object)tile.getExtraState(this.extrasBlockState.func_177621_b()));
        }
        return estate;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        EnumType type = BlockPergola.getEnumType(state);
        switch (type.getBaseType()) {
            case TOP: {
                return new TileEntityPergolaFrame();
            }
            case WALL: {
                return new TileEntityPergolaWall();
            }
            case GATE: {
                return new TileEntityPergolaGate();
            }
        }
        return null;
    }

    private TileEntityPergolaBase getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityPergolaBase ? (TileEntityPergolaBase)tile : null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockPergola.getEnumType(world, pos);
        return type.getBaseType() != EnumBase.GATE;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityPergolaBase tile = this.getTile(world, pos);
        return tile != null ? tile.getBoxBounds() : Block.field_185505_j;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity, boolean p_185477_7_) {
        TileEntityPergolaBase tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            for (AxisAlignedBB box : tile.getCollisionBoxes()) {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)box);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos pos2) {
        TileEntityPergolaBase tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            tile.neighborChanged(neighbor);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta == 8 ? 14 : meta);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        EnumType type = BlockPergola.getEnumType((IBlockAccess)world, pos);
        EnumCover cover = type.getCoverType();
        if (cover != EnumCover.NONE) {
            if (Values.itemMultiFood != null) {
                if (cover == EnumCover.GRAPEVINE_FRUIT) {
                    Function.dropItem((World)world, (BlockPos)pos, (ItemStack)Values.stacks.get("grapes", new int[0]));
                } else if (cover == EnumCover.LIFEVINE_FRUIT) {
                    Function.dropItem((World)world, (BlockPos)pos, (ItemStack)Values.stacks.get("lifefruit", new int[0]));
                } else if (cover == EnumCover.DEATHVINE_FRUIT) {
                    Function.dropItem((World)world, (BlockPos)pos, (ItemStack)Values.stacks.get("deathfruit", new int[0]));
                }
            }
            EnumType newType = EnumType.withTypes(type.getBaseType(), EnumCover.NONE);
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)newType)), (boolean)true);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityPergolaGate) {
                ((TileEntityPergolaGate)tile).setCover(EnumCover.NONE);
            }
            return false;
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityPergolaBase tile;
        ItemStack stack = new ItemStack((Block)this, 1, this.func_180651_a(state));
        if (stack.func_77973_b() instanceof IRGB16_Item && (tile = this.getTile(world, pos)) != null) {
            ((IRGB16_Item)stack.func_77973_b()).setRGB16(stack, tile.getRGB16(null).getIndex());
        }
        drops.add((Object)stack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumType type = BlockPergola.getEnumType(state, (IBlockAccess)world, pos);
        if (type.getBaseType() == EnumBase.GATE) {
            ItemStack heldItem;
            if (player != null && !(heldItem = player.func_184586_b(hand)).func_190926_b() && heldItem.func_77973_b() instanceof ItemBlockPergola && (facing == EnumFacing.UP || facing == EnumFacing.DOWN || heldItem.func_77952_i() > 0 && heldItem.func_77952_i() < 7)) {
                return false;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityPergolaGate) {
                return ((TileEntityPergolaGate)tile).blockActivated(player);
            }
        } else {
            EnumCover cover = type.getCoverType();
            String name = cover.toString();
            if (name.contains("fruit") && Values.itemMultiFood != null) {
                EnumType newType;
                if (cover == EnumCover.GRAPEVINE_FRUIT) {
                    Function.giveItem((EntityPlayer)player, (ItemStack)Values.stacks.get("grapes", new int[0]));
                    newType = EnumType.withTypes(type.getBaseType(), EnumCover.GRAPEVINE);
                } else if (cover == EnumCover.LIFEVINE_FRUIT) {
                    Function.giveItem((EntityPlayer)player, (ItemStack)Values.stacks.get("lifefruit", new int[0]));
                    newType = EnumType.withTypes(type.getBaseType(), EnumCover.LIFEVINE);
                } else if (cover == EnumCover.DEATHVINE_FRUIT) {
                    Function.giveItem((EntityPlayer)player, (ItemStack)Values.stacks.get("deathfruit", new int[0]));
                    newType = EnumType.withTypes(type.getBaseType(), EnumCover.DEATHVINE);
                } else {
                    newType = EnumType.withTypes(type.getBaseType(), EnumCover.NONE);
                }
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)newType)), (boolean)true);
                return true;
            }
        }
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityPergolaGate ? ((TileEntityPergolaGate)tile).blockMovementAI() : super.func_176205_b(world, pos);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.isShearable(null, (IBlockAccess)world, pos) ? 0.2f : this.field_149782_v;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockPergola.getEnumType(world, pos);
        return type.getCoverType() != EnumCover.NONE;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int vine = this.vineDropped(world.func_180495_p(pos));
        if (vine > 0) {
            list.add(new ItemStack((Block)this, 1, vine));
        }
        return list;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!this.canGrow(world, pos, state, false)) {
            return;
        }
        this.grow(world, random, pos, state);
    }

    public boolean canUseBonemeal(World world, Random random, BlockPos pos, IBlockState state) {
        return this.canGrow(world, pos, state, false) && random.nextFloat() < 0.45f;
    }

    public boolean canGrow(World world, BlockPos pos, IBlockState state, boolean isClient) {
        EnumType type = BlockPergola.getEnumType(state, (IBlockAccess)world, pos);
        if (type.getCoverType() == EnumCover.NONE) {
            return false;
        }
        String name = type.getCoverType().toString();
        if (!name.endsWith("fruit") && type.getBaseType() != EnumBase.GATE) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            if (this.isBlockOvergrown(world, pos.func_177972_a(facing))) continue;
            return true;
        }
        return false;
    }

    private boolean isBlockOvergrown(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return false;
        }
        EnumType type = BlockPergola.getEnumType(state, (IBlockAccess)world, pos);
        if (type.getBaseType() == EnumBase.GATE) {
            TileEntity tile = world.func_175625_s(pos);
            return tile instanceof TileEntityPergolaGate && ((TileEntityPergolaGate)tile).isOvergrown();
        }
        return type.getCoverType() != EnumCover.NONE;
    }

    public void grow(World world, Random random, BlockPos pos, IBlockState state) {
        EnumType type = BlockPergola.getEnumType(state, (IBlockAccess)world, pos);
        EnumType newType = null;
        switch (type.getCoverType()) {
            case NONE: {
                break;
            }
            case GRAPEVINE: {
                if (random.nextBoolean() && PlantFunctions.canGrowFruit(world, pos, PlantAPI.PlantType.GRAPEVINE)) {
                    newType = EnumType.withTypes(type.getBaseType(), EnumCover.GRAPEVINE_FRUIT);
                    break;
                }
            }
            case GRAPEVINE_FRUIT: {
                if (!PlantFunctions.canSpread(world, pos, PlantAPI.PlantType.GRAPEVINE)) break;
                this.doSpread(world, this.getSpread(world, pos), EnumCover.GRAPEVINE);
                break;
            }
            case LIFEVINE: {
                if (random.nextBoolean() && PlantFunctions.canGrowFruit(world, pos, PlantAPI.PlantType.LIFEVINE)) {
                    newType = EnumType.withTypes(type.getBaseType(), EnumCover.LIFEVINE_FRUIT);
                    break;
                }
            }
            case LIFEVINE_FRUIT: {
                if (!PlantFunctions.canSpread(world, pos, PlantAPI.PlantType.LIFEVINE)) break;
                this.doSpread(world, this.getSpread(world, pos), EnumCover.LIFEVINE);
                break;
            }
            case DEATHVINE: {
                if (random.nextBoolean() && PlantFunctions.canGrowFruit(world, pos, PlantAPI.PlantType.DEATHVINE)) {
                    newType = EnumType.withTypes(type.getBaseType(), EnumCover.DEATHVINE_FRUIT);
                    break;
                }
            }
            case DEATHVINE_FRUIT: {
                if (!PlantFunctions.canSpread(world, pos, PlantAPI.PlantType.DEATHVINE)) break;
                this.doSpread(world, this.getSpread(world, pos), EnumCover.DEATHVINE);
            }
        }
        if (newType != null && type.getBaseType() != EnumBase.GATE) {
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, newType), (boolean)true);
        }
    }

    private BlockPos getSpread(World world, BlockPos pos) {
        ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
        list.add(EnumFacing.UP);
        list.add(EnumFacing.DOWN);
        list.add(EnumFacing.NORTH);
        list.add(EnumFacing.EAST);
        list.add(EnumFacing.SOUTH);
        list.add(EnumFacing.WEST);
        int attempts = list.size();
        for (int attempt = 0; attempt < attempts; attempt = (int)((byte)(attempt + 1))) {
            int index = Function.random.nextInt(attempts - attempt);
            EnumFacing facing = (EnumFacing)list.get(index);
            list.remove(index);
            BlockPos sPos = pos.func_177972_a(facing);
            IBlockState state = world.func_180495_p(sPos);
            if (state.func_177230_c() != this || this.isBlockOvergrown(world, sPos)) continue;
            return sPos;
        }
        return null;
    }

    private void doSpread(World world, BlockPos pos, EnumCover cover) {
        if (pos == null || cover == null) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return;
        }
        EnumType type = BlockPergola.getEnumType((IBlockAccess)world, pos);
        if (type.getBaseType() == EnumBase.GATE) {
            TileEntityPergolaGate gate;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityPergolaGate && !cover.getName().endsWith("_fruit") && (gate = (TileEntityPergolaGate)tile).shouldOvergrow()) {
                gate.setCover(cover);
            }
            return;
        }
        EnumType newType = EnumType.withTypes(type.getBaseType(), cover);
        Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)newType)), (boolean)true);
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = BlockPergola.getEnumType(state);
        return type.getBaseType() == EnumBase.GATE ? 8 : (int)type.getBaseType().getValue();
    }

    private int vineDropped(IBlockState state) {
        EnumType type = BlockPergola.getEnumType(state);
        return type.getCoverType().getVineDrop();
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntityPergolaBase tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            EnumDyeColor current = tile.getRGB16(null).getDyeColor();
            tile.setRGB16(RGB16Helper.getIndexFor((EnumDyeColor)color), null);
            return current != color;
        }
        return false;
    }

    public boolean recolorBlock(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, Vec3d hitVec, String dyeName) {
        TileEntityPergolaBase tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = this.getTile((IBlockAccess)world, pos)) != null) {
            if (!world.field_72995_K) {
                tile.getRGB16(player).recolor(player, dyeName);
                Function.syncTile((TileEntity)tile);
            }
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        EnumType type;
        if (side == EnumFacing.UP && (type = BlockPergola.getEnumType(state)).base == EnumBase.TOP) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (world.func_175727_C(pos.func_177984_a()) && world.func_175623_d(pos.func_177977_b()) && rand.nextInt(10) == 1) {
            FXWaterDrop drop = new FXWaterDrop(world, (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + 0.7, (double)pos.func_177952_p() + rand.nextDouble());
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)drop);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (data.world != null && data.pos != null) {
            if (index == 0) {
                TileEntityPergolaBase tile = this.getTile(data.world, data.pos);
                if (tile != null) {
                    return tile.colorMultiplier();
                }
            } else if (index == 6) {
                EnumType type = BlockPergola.getEnumType(data.world, data.pos);
                return FoliageColor.getBiomeColor(data.world, data.pos, FoliageColor.EnumFoliage.getFoliage(type.getCoverType().getPlantType()));
            }
        }
        return 0xFFFFFF;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState state2, EntityLivingBase entity, int numberOfParticles) {
        return ParticleHelper.addLandingEffects((WorldServer)world, (BlockPos)pos, (EntityLivingBase)entity, (int)numberOfParticles, (int)this.getParticleStateId(state, (World)world, pos, (Entity)entity));
    }

    public boolean overrideRunningEffects(World world, BlockPos pos, IBlockState state, Entity entity) {
        return ParticleHelper.addRunningEffects((World)world, (BlockPos)pos, (Entity)entity, (int)this.getParticleStateId(state, world, pos, entity));
    }

    private int getParticleStateId(IBlockState state, World world, BlockPos pos, Entity entity) {
        int stateId = entity != null ? Block.func_176210_f((IBlockState)ParticleHelper.getStateForParticle((Entity)entity, (BlockPos)pos, (IBlockState)state, BlockPergola.class)) : Block.func_176210_f((IBlockState)ParticleHelper.getStateForParticle((IBlockState)state, (World)world, (BlockPos)pos));
        return stateId;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int vine;
        if (player != null && player.func_70093_af() && (vine = this.vineDropped(state)) > 0) {
            return new ItemStack((Block)this, 1, vine);
        }
        ItemStack stack = new ItemStack((Block)this, 1, this.func_180651_a(state));
        if (stack.func_77973_b() instanceof IRGB16_Item) {
            TileEntityPergolaBase tile = this.getTile((IBlockAccess)world, pos);
            if (tile != null) {
                ((IRGB16_Item)stack.func_77973_b()).setRGB16(stack, tile.getRGB16(null).getIndex());
            }
            return stack;
        }
        return null;
    }

    public static IBlockState getStateWithTypes(EnumBase base, EnumCover cover) {
        if (Values.blockPergola == null) {
            return null;
        }
        return Values.blockPergola.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.withTypes(base, cover)));
    }

    public static EnumType getEnumType(IBlockAccess world, BlockPos pos) {
        return BlockPergola.getEnumType(world.func_180495_p(pos), world, pos);
    }

    public static EnumType getEnumType(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockPergola.getEnumType(state);
        if (type.getBaseType() == EnumBase.GATE) {
            type = BlockPergola.getEnumType(state.func_177230_c().func_176221_a(state, world, pos));
        }
        return type;
    }

    public static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.TOP_NONE;
            Terraqueous.errorPropertyNotFound("BlockPergola.VARIANT", "TOP_NONE", state.toString());
        }
        return type;
    }

    public static enum EnumStyle implements IStringSerializable
    {
        NONE,
        NORMAL,
        BOTTOM,
        MIDDLE,
        TOP;

        private static final Map<String, EnumStyle> map;

        public static EnumStyle byName(String name) {
            return map.containsKey(name = name.toLowerCase().trim()) ? map.get(name) : NONE;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            map = new HashMap<String, EnumStyle>();
            map.clear();
            for (EnumStyle value : EnumStyle.values()) {
                map.put(value.func_176610_l(), value);
            }
        }
    }

    public static enum EnumCover {
        NONE(0, null),
        GRAPEVINE(1, PlantAPI.PlantType.GRAPEVINE),
        GRAPEVINE_FRUIT(2, PlantAPI.PlantType.GRAPEVINE),
        LIFEVINE(3, PlantAPI.PlantType.LIFEVINE),
        LIFEVINE_FRUIT(4, PlantAPI.PlantType.LIFEVINE),
        DEATHVINE(5, PlantAPI.PlantType.DEATHVINE),
        DEATHVINE_FRUIT(6, PlantAPI.PlantType.DEATHVINE);

        private static final Map<String, EnumCover> map;
        private final byte value;
        private final PlantAPI.PlantType plant;

        private EnumCover(int value, PlantAPI.PlantType plant) {
            this.value = (byte)value;
            this.plant = plant;
        }

        public byte getValue() {
            return this.value;
        }

        public PlantAPI.PlantType getPlantType() {
            return this.plant;
        }

        public int getVineDrop() {
            return this.value % 2 == 1 ? this.value : this.value - 1;
        }

        public static EnumCover byName(String name) {
            return map.containsKey(name = name.toLowerCase().trim()) ? map.get(name) : NONE;
        }

        public String getName() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            map = new HashMap<String, EnumCover>();
            map.clear();
            for (EnumCover value : EnumCover.values()) {
                map.put(value.getName(), value);
            }
        }
    }

    public static enum EnumBase {
        TOP(0),
        WALL(7),
        GATE(14);

        private final byte value;

        private EnumBase(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        TOP_NONE(0, EnumBase.TOP, EnumCover.NONE),
        TOP_GRAPEVINE(1, EnumBase.TOP, EnumCover.GRAPEVINE),
        TOP_GRAPEVINE_FRUIT(2, EnumBase.TOP, EnumCover.GRAPEVINE_FRUIT),
        TOP_LIFEVINE(3, EnumBase.TOP, EnumCover.LIFEVINE),
        TOP_LIFEVINE_FRUIT(4, EnumBase.TOP, EnumCover.LIFEVINE_FRUIT),
        TOP_DEATHVINE(5, EnumBase.TOP, EnumCover.DEATHVINE),
        TOP_DEATHVINE_FRUIT(6, EnumBase.TOP, EnumCover.DEATHVINE_FRUIT),
        WALL_NONE(7, EnumBase.WALL, EnumCover.NONE),
        WALL_GRAPEVINE(8, EnumBase.WALL, EnumCover.GRAPEVINE),
        WALL_GRAPEVINE_FRUIT(9, EnumBase.WALL, EnumCover.GRAPEVINE_FRUIT),
        WALL_LIFEVINE(10, EnumBase.WALL, EnumCover.LIFEVINE),
        WALL_LIFEVINE_FRUIT(11, EnumBase.WALL, EnumCover.LIFEVINE_FRUIT),
        WALL_DEATHVINE(12, EnumBase.WALL, EnumCover.DEATHVINE),
        WALL_DEATHVINE_FRUIT(13, EnumBase.WALL, EnumCover.DEATHVINE_FRUIT),
        GATE_NONE(14, EnumBase.GATE, EnumCover.NONE),
        GATE_GRAPEVINE(14, EnumBase.GATE, EnumCover.GRAPEVINE),
        GATE_LIFEVINE(14, EnumBase.GATE, EnumCover.LIFEVINE),
        GATE_DEATHVINE(14, EnumBase.GATE, EnumCover.DEATHVINE);

        private static final EnumType[] array;
        private final byte value;
        private final EnumBase base;
        private final EnumCover cover;

        private EnumType(int value, EnumBase base, EnumCover cover) {
            this.value = (byte)value;
            this.base = base;
            this.cover = cover;
        }

        public byte getValue() {
            return this.value;
        }

        public EnumBase getBaseType() {
            return this.base;
        }

        public EnumCover getCoverType() {
            return this.cover;
        }

        public static EnumType byValue(int value) {
            value = value > array.length || value < 1 ? 0 : value;
            EnumType cover = array[value];
            return cover == null ? TOP_NONE : cover;
        }

        public static EnumType withTypes(EnumBase base, EnumCover cover) {
            if (base == EnumBase.GATE) {
                switch (cover) {
                    case NONE: {
                        return GATE_NONE;
                    }
                    case GRAPEVINE: 
                    case GRAPEVINE_FRUIT: {
                        return GATE_GRAPEVINE;
                    }
                    case LIFEVINE: 
                    case LIFEVINE_FRUIT: {
                        return GATE_LIFEVINE;
                    }
                    case DEATHVINE: 
                    case DEATHVINE_FRUIT: {
                        return GATE_DEATHVINE;
                    }
                }
            }
            int value = (base != null ? base.getValue() : (byte)0) + (cover != null ? cover.getValue() : (byte)0);
            return EnumType.byValue(value);
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[15];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
            EnumType.array[14] = GATE_NONE;
        }
    }
}

