/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.item.ItemCloudStaff;
import shetiphian.terraqueous.common.item.ItemMultiTool;
import shetiphian.terraqueous.common.item.ItemScythe;

public class ModelTool {
    private static ModelResourceLocation sickle = new ModelResourceLocation("terraqueous:tool_scythe", "sickle");
    private static ModelResourceLocation scythe = new ModelResourceLocation("terraqueous:tool_scythe", "scythe");
    private static ModelResourceLocation multi_pickaxe = new ModelResourceLocation("terraqueous:tool_multi", "pickaxe");
    private static ModelResourceLocation multi_shovel = new ModelResourceLocation("terraqueous:tool_multi", "shovel");
    private static ModelResourceLocation multi_hoe = new ModelResourceLocation("terraqueous:tool_multi", "hoe");
    private static ModelResourceLocation multi_weapon = new ModelResourceLocation("terraqueous:tool_multi", "weapon");
    private static ModelResourceLocation multi_broken = new ModelResourceLocation("terraqueous:tool_multi", "broken");
    private static ModelResourceLocation soc_vapor = new ModelResourceLocation("terraqueous:tool_soc", "vapor");
    private static ModelResourceLocation soc_light = new ModelResourceLocation("terraqueous:tool_soc", "light");
    private static ModelResourceLocation soc_dense = new ModelResourceLocation("terraqueous:tool_soc", "dense");
    private static ModelResourceLocation soc_storm = new ModelResourceLocation("terraqueous:tool_soc", "storm");
    private static Map<String, IBakedModel> cache = new HashMap<String, IBakedModel>();
    private static IBakedModel missing_model;

    public static void registerModels() {
        ModelTool.registerCustomModel(Values.itemScythe, 100, sickle);
        ModelTool.registerCustomModel(Values.itemScythe, 101, scythe);
        ModelTool.registerCustomModel(Values.itemMultiTool, 100, multi_pickaxe);
        ModelTool.registerCustomModel(Values.itemMultiTool, 101, multi_shovel);
        ModelTool.registerCustomModel(Values.itemMultiTool, 102, multi_hoe);
        ModelTool.registerCustomModel(Values.itemMultiTool, 103, multi_weapon);
        ModelTool.registerCustomModel(Values.itemMultiTool, 104, multi_broken);
        ModelTool.registerCustomModel(Values.itemCloudStaff, 100, soc_vapor);
        ModelTool.registerCustomModel(Values.itemCloudStaff, 101, soc_light);
        ModelTool.registerCustomModel(Values.itemCloudStaff, 102, soc_dense);
        ModelTool.registerCustomModel(Values.itemCloudStaff, 103, soc_storm);
    }

    private static void registerCustomModel(Item item, int meta, ModelResourceLocation resource) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)resource);
        }
    }

    public static void buildCache(IRegistry<ModelResourceLocation, IBakedModel> registry) {
        cache.clear();
        ModelTool.addModel("sickle", (IBakedModel)registry.func_82594_a((Object)sickle));
        ModelTool.addModel("scythe", (IBakedModel)registry.func_82594_a((Object)scythe));
        ModelTool.addModel("multi_pickaxe", (IBakedModel)registry.func_82594_a((Object)multi_pickaxe));
        ModelTool.addModel("multi_shovel", (IBakedModel)registry.func_82594_a((Object)multi_shovel));
        ModelTool.addModel("multi_hoe", (IBakedModel)registry.func_82594_a((Object)multi_hoe));
        ModelTool.addModel("multi_weapon", (IBakedModel)registry.func_82594_a((Object)multi_weapon));
        ModelTool.addModel("multi_broken", (IBakedModel)registry.func_82594_a((Object)multi_broken));
        ModelTool.addModel("soc_vapor", (IBakedModel)registry.func_82594_a((Object)soc_vapor));
        ModelTool.addModel("soc_light", (IBakedModel)registry.func_82594_a((Object)soc_light));
        ModelTool.addModel("soc_dense", (IBakedModel)registry.func_82594_a((Object)soc_dense));
        ModelTool.addModel("soc_storm", (IBakedModel)registry.func_82594_a((Object)soc_storm));
    }

    private static void addModel(String key, IBakedModel model) {
        if (model != null) {
            cache.put(key, model);
        }
    }

    private static class Composite
    implements IBakedModel {
        private Composite() {
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return new ArrayList<BakedQuad>();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return new ItemOverrideList(Lists.newArrayList()){

                public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                    return this.handleItemState(stack);
                }
            };
        }

        private IBakedModel handleItemState(ItemStack stack) {
            IBakedModel model = null;
            if (stack.func_77973_b() instanceof ItemMultiTool) {
                switch (ItemMultiTool.getEnumType(stack)) {
                    case PICKAXE: {
                        model = (IBakedModel)cache.get("multi_pickaxe");
                        break;
                    }
                    case SHOVEL: {
                        model = (IBakedModel)cache.get("multi_shovel");
                        break;
                    }
                    case HOE: {
                        model = (IBakedModel)cache.get("multi_hoe");
                        break;
                    }
                    case WEAPON: {
                        model = (IBakedModel)cache.get("multi_weapon");
                        break;
                    }
                    case BROKEN: {
                        model = (IBakedModel)cache.get("multi_broken");
                    }
                }
            } else if (stack.func_77973_b() instanceof ItemScythe) {
                model = ItemScythe.isSickle(stack) ? (IBakedModel)cache.get("sickle") : (IBakedModel)cache.get("scythe");
            } else if (stack.func_77973_b() instanceof ItemCloudStaff) {
                switch (ItemCloudStaff.getEnumMode(stack)) {
                    case VAPOR: {
                        model = (IBakedModel)cache.get("soc_vapor");
                        break;
                    }
                    case LIGHT: {
                        model = (IBakedModel)cache.get("soc_light");
                        break;
                    }
                    case DENSE: {
                        model = (IBakedModel)cache.get("soc_dense");
                        break;
                    }
                    case STORM: {
                        model = (IBakedModel)cache.get("soc_storm");
                    }
                }
            }
            return model != null ? model : missing_model;
        }
    }

    public static class Base
    implements IModel {
        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.copyOf(new ArrayList());
        }

        public Collection<ResourceLocation> getTextures() {
            return ImmutableList.copyOf(new ArrayList());
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            if (missing_model == null) {
                IModel model = ModelLoaderRegistry.getMissingModel();
                missing_model = model.bake(model.getDefaultState(), format, bakedTextureGetter);
            }
            return new Composite();
        }

        public IModelState getDefaultState() {
            return ModelLoaderRegistry.getMissingModel().getDefaultState();
        }
    }
}

