/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.core.client.gui.GuiSidedContainer;
import shetiphian.terraqueous.client.gui.Textures;
import shetiphian.terraqueous.common.inventory.ContainerCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftFurnace;

@SideOnly(value=Side.CLIENT)
public class GuiCraftFurnace
extends GuiSidedContainer {
    private TileEntityCraftFurnace furnace;

    public GuiCraftFurnace(InventoryPlayer invPlayer, TileEntityCraftFurnace tile) {
        super((Container)new ContainerCraftFurnace(invPlayer, tile), (TileEntity)tile, true);
        String[] stringArray;
        this.furnace = tile;
        this.field_146999_f = 182;
        int n = this.field_147000_g = this.furnace.isCloud ? 172 : 196;
        if (this.furnace.isCloud) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "gui.craftfurnace.cloud.basic.txt";
            stringArray2[1] = "gui.craftfurnace.items.txt";
            stringArray = stringArray2;
            stringArray2[2] = "gui.craftfurnace.cloud.output.txt";
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "gui.craftfurnace.basic.txt";
            stringArray3[1] = "gui.craftfurnace.items.txt";
            stringArray3[2] = "gui.craftfurnace.fuel.txt";
            stringArray3[3] = "gui.craftfurnace.inputs.txt";
            stringArray = stringArray3;
            stringArray3[4] = "gui.craftfurnace.output.txt";
        }
        this.invNames = stringArray;
    }

    protected List<String> getInfoBoxText() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.furnace.isCloud) {
            lines.add("\u00a79I:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.items.info"));
            lines.add(null);
            lines.add("\u00a76II:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.output.info"));
            lines.add(null);
            lines.add("\u00a7aIII:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.process.info"));
        } else {
            lines.add("\u00a71I:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.fuel.info"));
            lines.add(null);
            lines.add("\u00a79II:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.items.info"));
            lines.add(null);
            lines.add("\u00a76III:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.output.info"));
            lines.add(null);
            lines.add("\u00a7aIV:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.process.info"));
        }
        return lines;
    }

    public void init() {
    }

    protected void buttonClick(GuiButton button) {
    }

    private void drawCommon() {
        if (this.furnace.isCloud) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 84, 182, 74);
        } else {
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 60, 182, 98);
        }
    }

    private void bindTexture() {
        this.field_146297_k.func_110434_K().func_110577_a(this.furnace.isCloud ? Textures.CLOUD_CRAFTFURNACE.get() : Textures.EARTH_CRAFTFURNACE.get());
    }

    protected void drawNormal(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.drawCommon();
        if (this.furnace.isCloud) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r + 74, 0, 158, 182, 98);
        } else {
            this.func_73729_b(this.field_147003_i, this.field_147009_r + 98, 0, 158, 182, 98);
        }
        int offset = this.furnace.isCloud ? 0 : 24;
        int progress = this.furnace.getCookProgressScaled(0, 19);
        this.func_73729_b(this.field_147003_i + 82, this.field_147009_r + 34 + offset - progress, 238, 256 - progress, 18, progress);
        progress = this.furnace.getCookProgressScaled(1, 19);
        this.func_73729_b(this.field_147003_i + 82, this.field_147009_r + 58 + offset - progress, 238, 256 - progress, 18, progress);
        if (!this.furnace.isCloud) {
            progress = this.furnace.getFuelProgressScaled(54);
            this.func_73729_b(this.field_147003_i + 64, this.field_147009_r + 10, 184, 238, progress, 18);
        }
        GuiFunctions.exitDrawTextureStateWithBlend();
    }

    private void drawGuide(boolean info) {
        if (this.furnace.isCloud) {
            GuiCraftFurnace.func_73734_a((int)(this.field_147003_i + 22), (int)(this.field_147009_r + 10), (int)(this.field_147003_i + 58), (int)(this.field_147009_r + 64), (int)-2141891073);
            GuiCraftFurnace.func_73734_a((int)(this.field_147003_i + 124), (int)(this.field_147009_r + 10), (int)(this.field_147003_i + 160), (int)(this.field_147009_r + 64), (int)-2130728448);
            if (info) {
                GuiCraftFurnace.func_73734_a((int)(this.field_147003_i + 82), (int)(this.field_147009_r + 16), (int)(this.field_147003_i + 100), (int)(this.field_147009_r + 58), (int)-2141847723);
            }
        } else {
            GuiCraftFurnace.func_73734_a((int)(this.field_147003_i + 64), (int)(this.field_147009_r + 10), (int)(this.field_147003_i + 118), (int)(this.field_147009_r + 28), (int)-2147483478);
            GuiCraftFurnace.func_73734_a((int)(this.field_147003_i + 22), (int)(this.field_147009_r + 34), (int)(this.field_147003_i + 58), (int)(this.field_147009_r + 88), (int)-2141891073);
            GuiCraftFurnace.func_73734_a((int)(this.field_147003_i + 124), (int)(this.field_147009_r + 34), (int)(this.field_147003_i + 160), (int)(this.field_147009_r + 88), (int)-2130728448);
            if (info) {
                GuiCraftFurnace.func_73734_a((int)(this.field_147003_i + 82), (int)(this.field_147009_r + 40), (int)(this.field_147003_i + 100), (int)(this.field_147009_r + 82), (int)-2141847723);
            }
        }
    }

    private void drawGuideText(boolean info) {
        if (this.furnace.isCloud) {
            this.func_73732_a(this.field_146289_q, "I", this.field_147003_i + 40, this.field_147009_r + 33, -1);
            this.func_73732_a(this.field_146289_q, "II", this.field_147003_i + 142, this.field_147009_r + 33, -1);
            if (info) {
                this.func_73732_a(this.field_146289_q, "III", this.field_147003_i + 91, this.field_147009_r + 33, -1);
            }
        } else {
            this.func_73732_a(this.field_146289_q, "I", this.field_147003_i + 91, this.field_147009_r + 15, -1);
            this.func_73732_a(this.field_146289_q, "II", this.field_147003_i + 40, this.field_147009_r + 57, -1);
            this.func_73732_a(this.field_146289_q, "III", this.field_147003_i + 142, this.field_147009_r + 57, -1);
            if (info) {
                this.func_73732_a(this.field_146289_q, "IV", this.field_147003_i + 91, this.field_147009_r + 57, -1);
            }
        }
    }

    protected void drawInfo(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.drawCommon();
        this.drawGuide(true);
        GuiFunctions.exitDrawTextureStateWithBlend();
        if (this.infoBox != null) {
            this.infoBox.drawScreen(mouseX, mouseY, partialTicks);
        }
        this.drawGuideText(true);
    }

    protected void drawConfig(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.drawCommon();
        this.drawGuide(false);
        GuiFunctions.exitDrawTextureStateWithBlend();
        for (GuiButton button : this.field_146292_n) {
            int color;
            if (button.field_146127_k >= -3) continue;
            byte index = this.indexSide[button.field_146127_k + 9];
            if (this.furnace.isCloud) {
                if (index == 0) {
                    GuiCraftFurnace.func_73734_a((int)button.field_146128_h, (int)button.field_146129_i, (int)(button.field_146128_h + button.field_146120_f), (int)(button.field_146129_i + button.field_146121_g), (int)-22016);
                    GuiCraftFurnace.func_73734_a((int)button.field_146128_h, (int)button.field_146129_i, (int)(button.field_146128_h + button.field_146120_f / 2), (int)(button.field_146129_i + button.field_146121_g), (int)-11184641);
                    continue;
                }
                color = index == 1 ? -11184641 : (index == 2 ? -22016 : Integer.MIN_VALUE);
                GuiCraftFurnace.func_73734_a((int)button.field_146128_h, (int)button.field_146129_i, (int)(button.field_146128_h + button.field_146120_f), (int)(button.field_146129_i + button.field_146121_g), (int)color);
                continue;
            }
            if (index == 0) {
                GuiCraftFurnace.func_73734_a((int)button.field_146128_h, (int)button.field_146129_i, (int)(button.field_146128_h + button.field_146120_f), (int)(button.field_146129_i + button.field_146121_g), (int)-22016);
                GuiCraftFurnace.func_73734_a((int)button.field_146128_h, (int)button.field_146129_i, (int)(button.field_146128_h + button.field_146120_f / 2), (int)(button.field_146129_i + button.field_146121_g), (int)-11184641);
                GuiCraftFurnace.func_73734_a((int)button.field_146128_h, (int)(button.field_146129_i + button.field_146121_g / 2), (int)(button.field_146128_h + button.field_146120_f), (int)(button.field_146129_i + button.field_146121_g), (int)-16777046);
                continue;
            }
            if (index == 3) {
                GuiCraftFurnace.func_73734_a((int)button.field_146128_h, (int)button.field_146129_i, (int)(button.field_146128_h + button.field_146120_f), (int)(button.field_146129_i + button.field_146121_g), (int)-16777046);
                GuiCraftFurnace.func_73734_a((int)button.field_146128_h, (int)button.field_146129_i, (int)(button.field_146128_h + button.field_146120_f / 2), (int)(button.field_146129_i + button.field_146121_g), (int)-11184641);
                continue;
            }
            if (index == 4) {
                GuiCraftFurnace.func_73734_a((int)button.field_146128_h, (int)button.field_146129_i, (int)(button.field_146128_h + button.field_146120_f), (int)(button.field_146129_i + button.field_146121_g), (int)-22016);
                GuiCraftFurnace.func_73734_a((int)(button.field_146128_h + button.field_146120_f / 2), (int)(button.field_146129_i + button.field_146120_f / 2), (int)(button.field_146128_h + button.field_146120_f), (int)(button.field_146129_i + button.field_146121_g), (int)-16777046);
                continue;
            }
            color = index == 1 ? -11184641 : (index == 2 ? -16777046 : Integer.MIN_VALUE);
            GuiCraftFurnace.func_73734_a((int)button.field_146128_h, (int)button.field_146129_i, (int)(button.field_146128_h + button.field_146120_f), (int)(button.field_146129_i + button.field_146121_g), (int)color);
        }
        this.drawGuideText(false);
    }
}

