/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.cloud;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shetiphian.terraqueous.api.cloud.ICloud;
import shetiphian.terraqueous.api.cloud.MaterialCloud;

public class CloudAPI {
    public static final PropertyEnum<CloudType> VARIANT = PropertyEnum.func_177709_a((String)"cloudvariant", CloudType.class);
    public static final PropertyBool KICKABLE = PropertyBool.func_177716_a((String)"generated");
    public static final Material materialCloud = new MaterialCloud();
    public static SoundType soundTypeCloud = new SoundType(1.0f, -5.0f, SoundEvents.field_187807_fF, SoundEvents.field_187815_fJ, SoundEvents.field_187813_fI, SoundEvents.field_187811_fH, SoundEvents.field_187809_fG);
    private static final Table<String, Byte, Boolean> CLOUD_BLOCKS = HashBasedTable.create();
    private static final HashSet<String> CLOUD_WALK_ITEMS = new HashSet();
    private static final HashMap<UUID, HashSet<String>> CLOUD_WALKING_ENTITIES = new HashMap();
    protected static Logger logCloud = LogManager.getLogger((String)"Terraqueous|CloudAPI");

    public static void addCloudBlock(Block block, int lowestMeta, int highestMeta, boolean punchable) {
        if (block != null) {
            CloudAPI.addCloudBlock(block.getRegistryName().toString(), lowestMeta, highestMeta, punchable);
        }
    }

    public static void addCloudBlock(String key, int lowestMeta, int highestMeta, boolean punchable) {
        if (!Strings.isNullOrEmpty((String)key)) {
            if ((lowestMeta = MathHelper.func_76125_a((int)lowestMeta, (int)0, (int)15)) > (highestMeta = MathHelper.func_76125_a((int)highestMeta, (int)0, (int)15))) {
                int temp = lowestMeta;
                lowestMeta = highestMeta;
                highestMeta = temp;
            }
            for (int meta = lowestMeta; meta <= highestMeta; ++meta) {
                CLOUD_BLOCKS.put((Object)key, (Object)((byte)meta), (Object)punchable);
            }
        }
    }

    public static void addCloudWalkItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            CloudAPI.addCloudWalkItem(stack.func_77973_b().getRegistryName().toString(), stack.func_77952_i());
        }
    }

    public static void addCloudWalkItem(String key, int meta) {
        if (!Strings.isNullOrEmpty((String)key)) {
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)Short.MAX_VALUE);
            CLOUD_WALK_ITEMS.add(key + "@" + meta);
        }
    }

    public static void grantCloudWalk(EntityLivingBase entity, String source) {
        if (entity != null && !Strings.isNullOrEmpty((String)source)) {
            CloudAPI.getOrCreate(entity.func_110124_au()).add(source.toLowerCase().trim());
        }
    }

    public static void revokeCloudWalk(EntityLivingBase entity, String source) {
        if (entity != null && !Strings.isNullOrEmpty((String)source)) {
            CloudAPI.getOrCreate(entity.func_110124_au()).remove(source.toLowerCase().trim());
        }
    }

    public static boolean hasCloudWalk(EntityLivingBase entity) {
        if (entity != null) {
            return !CloudAPI.getOrCreate(entity.func_110124_au()).isEmpty();
        }
        return false;
    }

    private static Set<String> getOrCreate(UUID uuid) {
        if (!CLOUD_WALKING_ENTITIES.containsKey(uuid)) {
            CLOUD_WALKING_ENTITIES.put(uuid, new HashSet());
        }
        return CLOUD_WALKING_ENTITIES.get(uuid);
    }

    public static boolean entityCanBeOnClouds(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71075_bZ.field_75098_d || player.field_71075_bZ.field_75101_c) {
                return true;
            }
        }
        return entity != null && CloudAPI.hasCloudWalk(entity);
    }

    public static boolean isCloud(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() instanceof ICloud) {
            return ((ICloud)state.func_177230_c()).isCloudBlock(state, world, pos);
        }
        return CloudAPI.isCloud(state, state.func_177230_c().func_176201_c(state));
    }

    public static boolean isCloud(IBlockState state) {
        return CloudAPI.isCloud(state, state.func_177230_c().func_176201_c(state));
    }

    public static boolean isCloud(IBlockState state, int metadata) {
        if (state.func_185904_a() instanceof MaterialCloud) {
            return true;
        }
        ResourceLocation id = state.func_177230_c().getRegistryName();
        return id != null && CLOUD_BLOCKS.contains((Object)id, (Object)metadata);
    }

    public static boolean isCloudWalkItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            String key = stack.func_77973_b().getRegistryName().toString() + "@";
            return CLOUD_WALK_ITEMS.contains(key + stack.func_77952_i()) || CLOUD_WALK_ITEMS.contains(key + Short.MAX_VALUE);
        }
        return false;
    }

    public static boolean canBlockTouchClouds(IBlockState state, IBlockAccess world, BlockPos pos) {
        return world.func_175623_d(pos) || state.func_185904_a().func_76222_j() || CloudAPI.isCloud(state, world, pos);
    }

    public static boolean canPlaceCloudAt(IBlockAccess world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos sPos = pos.func_177972_a(dir);
            IBlockState sState = world.func_180495_p(sPos);
            if (CloudAPI.canBlockTouchClouds(sState, world, sPos)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCloudKickable(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() instanceof ICloud) {
            return ((ICloud)state.func_177230_c()).isCloudKickable(state, world, pos);
        }
        boolean kickable = false;
        try {
            kickable = (Boolean)state.func_177229_b((IProperty)KICKABLE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return kickable || CloudAPI.isCloudKickable(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public static boolean isCloudKickable(Block block, int metadata) {
        ResourceLocation id = block.getRegistryName();
        return id != null && CLOUD_BLOCKS.contains((Object)id, (Object)metadata) && (Boolean)CLOUD_BLOCKS.get((Object)id, (Object)metadata) != false;
    }

    public static boolean getKickable(IBlockState state) {
        boolean kickable;
        try {
            kickable = (Boolean)state.func_177229_b((IProperty)KICKABLE);
        }
        catch (Exception e) {
            kickable = false;
            CloudAPI.errorPropertyNotFound("CloudAPI.KICKABLE", "FALSE", state.toString());
        }
        return kickable;
    }

    public static CloudType getCloudType(IBlockState state) {
        CloudType type;
        try {
            type = (CloudType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = CloudType.LIGHT;
            CloudAPI.errorPropertyNotFound("CloudAPI.VARIANT", "LIGHT", state.toString());
        }
        return type;
    }

    public static void errorPropertyNotFound(String property, String returning, String state) {
        logCloud.error("PropertyEnum '" + property + "' not found in provided BlockState, returning '" + returning + "'. Provided BlockState: " + state);
    }

    public static enum CloudType implements IStringSerializable
    {
        LIGHT(0),
        DENSE(1),
        STORM(2);

        private static final CloudType[] array;
        private final byte id;

        private CloudType(int id) {
            this.id = (byte)id;
        }

        public byte getID() {
            return this.id;
        }

        public static CloudType byID(int id) {
            return array[MathHelper.func_76125_a((int)id, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new CloudType[]{LIGHT, DENSE, STORM};
        }
    }
}

